<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX003"
	title	= "対訳"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command = "{@command}" debug="{@debug}">
	select SYSTEM_ID,KEYWORD,GENBUN,YAKU,LANG_YAKU,KBYAKU,KBHORYU,ID,COMMENTS,UNIQ,FGJ
	from   GF28 A
	where exists (select 'X' from GF28 B
					where A.SYSTEM_ID = B.SYSTEM_ID
					and   A.GENBUN    = B.GENBUN
					and ( A.YAKU = B.YAKU or A.LANG_YAKU = B.LANG_YAKU )
					and   A.UNIQ     != B.UNIQ
					and   A.KBHORYU  != '9'
					and   B.KBHORYU  != '9'
					and   A.FGJ       = '1'
					and   B.FGJ       = '1'
		)
	<og:where startKey="and">
		<og:and value = "SYSTEM_ID	= '{@SYSTEM_ID}'"	/>
	</og:where>
	order by SYSTEM_ID,GENBUN,LANG_YAKU,UNIQ
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

	<!-- 登録、取消、リセットボタンを作成します。 -->
	<og:writeCheck>
		<og:submit  action="MODIFY" lbl="KBHORYU" columnWritable="KBHORYU"
						keys="KBHORYU" vals="9" />
		<og:submit  action="DELETE"  columnWritable="null"    />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType = "HTMLTable"
		command 	 = "{@command}"
		noDisplay    = "FGJ"
		checked      = "{@checked}"
		startNo      = "{@startNo}" 
		pageSize     = "{@pageSize}"
		rowspan      = "2"
	/>
</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
