<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:upload
	fileURL     = "{@USER.ID}"
	maxPostSize = "0"
/>

<og:columnCheck
	command   = "NEW"
	nullCheck = "file1,SYSTEM_ID"
/>

<og:file fileURL="{@USER.ID}" file1="{@file1}" action="existsLength" >
	<og:message lbl="MSG0064" comment="ファイルが存在していません。" />
	<og:text>fileURL="{@USER.ID}" file1="{@file1}"</og:text>
</og:file>

<og:readTable
	command		= "NEW"
	readerClass = "POI"
	useNumber   = "false"
	modifyType	= "A"
	fileURL		= "{@USER.ID}"
	filename	= "{@file1}"
	maxRowCount	= "0"
	nullSkipClm	= "TEXT"
	debug		= "{@debug}"
/>

<og:tableMerge
	action		= "GROUP"
	masterKeys	= "TEXT"
/>

<!-- 登録処理をおこないます。 -->
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" debug="{@debug}" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF28"
			asNames		= "TEXT"
			orgNames	= "GENBUN"
			constKeys	= "SYSTEM_ID,KEYWORD,LANG_YAKU,KBYAKU,KBHORYU,FGJ"
			constVals	= "{@SYSTEM_ID},{@file1},**,4,0,1"
		/>
	</og:tableUpdate>
	<og:forward page="result.jsp" keys="command" vals="RENEW" />

<!--
		<og:view
			viewFormType = "HTMLTable"
			command 	 = "NEW"
		/>
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
