/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.io;

import java.io.File;										// 6.2.0.0 (2015/02/27)
// import java.util.Arrays;									// 6.2.0.0 (2015/02/27)

import org.opengion.fukurou.model.POIUtil;					// 6.1.0.0 (2014/12/26) イベント方式
// import org.opengion.fukurou.model.TableModelHelper;		// 6.2.0.0 (2015/02/27) クラス名変更

// import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.AbstractTableReader;		// 6.2.0.0 (2015/02/27)

import static org.opengion.fukurou.util.HybsConst.CR ;		// 6.2.2.0 (2015/03/27)

/**
 * POI による、Word,PoworPoint,Excel,Textのファイルを読み取る実装クラスです。
 *
 * ファイル名、シート名を指定して、データを読み取ることが可能です。
 * 入力形式は、openXML形式にも対応しています。
 *
 * POIUtil#extractor(File)を使用して、行分割しますので、第一カラムが # で始まる行も
 * 読み取り対象にします。
 * カラム名は、TEXT 一つだけになります。
 * 通常のTableReader の各種機能は、使用できませんので、ご注意ください。
 *
 * @og.rev 6.2.3.0 (2015/05/01) 新規作成
 * @og.group ファイル入力
 *
 * @version  6.2
 * @author   Kazuhiko Hasegawa
 * @since    JDK8.0,
 */
public class TableReader_POI extends AbstractTableReader {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.2.3.0 (2015/05/01)" ;

	/**
	 * DBTableModel から 各形式のデータを作成して,BufferedReader より読み取ります。
	 * コメント/空行を除き、最初の行は、必ず項目名が必要です。
	 * それ以降は、コメント/空行を除き、データとして読み込んでいきます。
	 * このメソッドは、EXCEL 読み込み時に使用します。
	 *
	 * @og.rev 6.2.3.0 (2015/05/01) 新規作成
	 *
	 * @param   file 読み取り元ファイル
	 * @param   enc ファイルのエンコード文字列(未使用)
	 */
	@Override
	public void readDBTable( final File file , final String enc ) {
		final boolean isDebug = isDebug();			// 5.5.7.2 (2012/10/09) デバッグ情報

		if( isDebug ) { System.out.println( " Filename=" + file ) ; }

		final String data = enc == null ? POIUtil.extractor( file ) : POIUtil.extractor( file,enc ) ;

		setTableDBColumn( new String[] { "TEXT" } ) ;

		final String[] datas = data.split( CR );
		int rowNo = 0;
		for( int i=getSkipRowCount(); i<datas.length; i++ ) {
			final String[] vals = new String[] { datas[i] } ;
			setTableColumnValues( vals,rowNo++ );				// SkipRowCount があるので、0 から始める。
		}

		if( isDebug ) { System.out.println( "  TableReader End." ) ; }
	}
}
