<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2190"
	title	= "移行DB対応明細"
	date	= "2014/05/01"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- FIRSTシートに表示する対象テーブル一覧の検索。後ろは、各テーブルごとの明細検索。 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request" >
		select 	'1' as ODER , NOJUN , 0 as SEQNO 
				, TABLE_NAME , NAME_JA as TABLE_LBL , F_TABLE_NAME , F_NAME_JA as F_TABLE_LBL
				, SUIKOU , F_SUIKOU , CDIKOU  , DESCRIPTION
				, '' as NAME_JA , '' as CLM , '' as CLS_NAME , '' as USE_LENGTH , '' as DTYPE
				, '' as DATA_DEFAULT , '' as NOT_NULL , '' as BIKO
				, '' as F_NAME_JA , '' as F_CLM , '' as F_CLS_NAME , '' as F_USE_LENGTH , '' as F_DTYPE , '' as F_DESCRIPTION
				, '{@LBL.GF2180}' as PAGEBREAK
		from GF84
		where SYSTEM_ID	= '{@SYSTEM_ID}'
		and   FGJ		in  ('0','1')
		union all
		select 	'2' as ODER , B.NOJUN , A.SEQNO
				, A.TABLE_NAME , B.NAME_JA as TABLE_LBL , B.F_TABLE_NAME , B.F_NAME_JA as F_TABLE_LBL
				, 0 as SUIKOU , 0 as F_SUIKOU , B.CDIKOU  , B.DESCRIPTION as DESCRIPTION
				, A.NAME_JA , A.CLM , A.CLS_NAME , A.USE_LENGTH , '' as DTYPE
				, A.DATA_DEFAULT , A.NOT_NULL , A.BIKO
				, A.F_NAME_JA , A.F_CLM , A.F_CLS_NAME , A.F_USE_LENGTH , '' as F_DTYPE , A.DESCRIPTION as F_DESCRIPTION
				, A.TABLE_NAME || '(' || B.NAME_JA || ')' as PAGEBREAK
		from GF85 A left outer join GF84 B
				on  A.SYSTEM_ID  = B.SYSTEM_ID
				and A.TABLE_NAME = B.TABLE_NAME
		where A.SYSTEM_ID	= '{@SYSTEM_ID}'
		and   A.FGJ			in  ('0','1')
		order by 1,2,3,4
</og:query>

<!-- CLS_NAME,USE_LENGTH,DTYPE カラムが必須。異なる場合は、keys,vals で指定します。 -->
<og:tableFilter scope="request" classId="DTYPE" keys="CLS_NAME,USE_LENGTH,DTYPE" vals="CLS_NAME,USE_LENGTH,DTYPE" />
<og:tableFilter scope="request" classId="DTYPE" keys="CLS_NAME,USE_LENGTH,DTYPE" vals="F_CLS_NAME,F_USE_LENGTH,F_DTYPE" />

<!-- useSheetName="true" で、PAGEBREAK の値を、シート名に使用します。 -->
<og:report2
	scope			= "request"
	fileURL			= "{@SYS.REAL_PATH}jsp/{@GUI.ADDRESS}"
	listId			= "DBDEF1"
	outFileURL		= "{@USER.ID}"
	outFilename		= "{@GUI.NAME}.xls"
	useSheetName	= "true"
	fgrun			= "E"
	debug			= "{@debug}"
/>

<og:forward page="{@SYS.JSP}/fileDownload" keys="file" vals="{@SYS.FILE_URL}{@USER.ID}/{@GUI.NAME}.xls" useRedirect="true" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
