<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:tld="http://java.sun.com/xml/ns/j2ee" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:template match="/">
    <xsl:apply-templates select="tld:taglib" />
  </xsl:template>

  <xsl:template match="tld:taglib">
    <xsl:variable name="version" select="tld:tlib-version" />
    <xsl:variable name="prefix"  select="tld:short-name" />
    <ROWSET tableName="GF21">
      <EXEC_SQL>delete from GF21 where VERNO = '<xsl:value-of select="$version" />'</EXEC_SQL>
      <xsl:for-each select="tld:tag">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="tld:tag" />
          </xsl:attribute>
          <VERNO><xsl:value-of select="$version" /></VERNO>
          <PRE_FIX><xsl:value-of select="$prefix" /></PRE_FIX>
          <TAGNAME><xsl:value-of select="tld:name" /></TAGNAME>
          <SEQ><xsl:number level="any" format="1" count="tld:tag" /></SEQ>
          <TAGCLASS><xsl:value-of select="tld:tag-class" /></TAGCLASS>
          <TEICLASS><xsl:value-of select="tld:tei-class" /></TEICLASS>
          <BODYCONTENT>
            <xsl:variable name="bodyCtxt" select="tld:body-content"/>
            <xsl:if test="$bodyCtxt='JSP'"         >1</xsl:if>
            <xsl:if test="$bodyCtxt='empty'"       >2</xsl:if>
            <xsl:if test="$bodyCtxt='tagdependent'">3</xsl:if>
          </BODYCONTENT>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
