<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP01"
	title    = "要求テーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここから -->
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_OUT_FILE" value="OUTFILE" />
	<og:value command="SET" key="C_OUT_DIR" value="OUTDIR" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_OUT_FILE" value="OUT_FILE" />
	<og:value command="SET" key="C_OUT_DIR" value="OUT_DIR" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,YKNO,GROUPID,LISTID,FGKAN"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select  a.FGKAN,a.YKNO,a.LISTID,b.LISTNAME,a.JOKEN,a.GROUPID,
				a.SUDATA as CNT,
				a.{@C_OUT_DIR} OUT_DIR,a.{@C_OUT_FILE} OUT_FILE,a.COMMENTS,a.PDF_PASSWD,a.SYSTEM_ID,a.DMN_NAME,a.DMN_HOST,
				a.FGJ,a.DYSET,a.DYUPD,a.USRSET,a.USRUPD,a.PGUPD
		from    GE50 a left outer join GE54 b
		on		a.SYSTEM_ID = b.SYSTEM_ID
		and		a.LISTID    = b.LISTID
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "a.SYSTEM_ID = '{@SYSTEM_ID}'" />
		<og:and value = "a.YKNO      =    '{@YKNO}'"       />
		<og:and value = "a.GROUPID   LIKE '{@GROUPID}'"   />
		<og:and value = "a.LISTID    LIKE '{@LISTID}'"    />
		<og:and value = "a.FGKAN     =    '{@FGKAN}'"      />
		<og:and value = "a.JOKEN     LIKE '{@JOKEN}'"     />
		<og:and value = "a.FGJ       in   ( '0','1' )"     />
		<og:and value = "a.{@C_OUT_FILE}   LIKE '{@OUT_FILE}'"   />
		<og:and value = "a.DYSET    &gt;= '{@DYSETFROM}'"  />
		<og:and value = "a.DYSET    &lt;= '{@DYSETTO}99'"  />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="a.SYSTEM_ID,a.YKNO DESC" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="JOKEN" must="true" editor="DBMENU" addNoValue="false" >
	select JOKEN,JOKEN
	from GE53 
	where FGJ in ('0','1')
	<og:where startKey="and">
		<og:and value = "SYSTEM_ID = '{@SYSTEM_ID}'"	/>
	</og:where>
	group by JOKEN,JOKEN
	order by 1
</og:columnEditor>
<og:columnEditor column="FGKAN" must="true" />

<og:viewLink command="{@command}">
	<og:link column="FGKAN" gamenId="REP07" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,YKNO" vals="NEW,[SYSTEM_ID],[YKNO]" />
	<og:link column="YKNO" gamenId="REP02" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,YKNO,LISTID" vals="NEW,[SYSTEM_ID],[YKNO],[LISTID]" />
	<og:link column="LISTID" gamenId="REP05" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,LISTID" vals="NEW,[SYSTEM_ID],[LISTID]" />
	<og:link column="JOKEN" gamenId="REP04" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,JOKEN" vals="NEW,[SYSTEM_ID],[JOKEN]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="Z" />

	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
/>

</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
