/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.ErrorConstants;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.opengion.fukurou.model.EventReader;
import org.opengion.fukurou.model.ExcelStyleFormat;
import org.opengion.fukurou.model.TableModelHelper;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsConst;

public final class EventReader_XLS
implements EventReader {
    private static final String VERSION = "6.2.0.0 (2015/02/27)";

    @Override
    public void eventReader(File file, TableModelHelper tableModelHelper) {
        BufferedInputStream bufferedInputStream = null;
        DocumentInputStream documentInputStream = null;
        try {
            tableModelHelper.startFile(file);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)bufferedInputStream);
            documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
            HSSFRequest hSSFRequest = new HSSFRequest();
            hSSFRequest.addListenerForAllRecords((HSSFListener)new ExcelListener(tableModelHelper));
            HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
            hSSFEventFactory.processEvents(hSSFRequest, (InputStream)documentInputStream);
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u53d6\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + file + HybsConst.CR + iOException.getMessage();
                throw new RuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(documentInputStream);
                Closer.ioClose(bufferedInputStream);
                tableModelHelper.endFile(file);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)documentInputStream);
        Closer.ioClose(bufferedInputStream);
        tableModelHelper.endFile(file);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.EventReader_XLS \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d");
            return;
        }
        File file = new File(stringArray[0]);
        EventReader_XLS eventReader_XLS = new EventReader_XLS();
        eventReader_XLS.eventReader(file, new TableModelHelper(){

            @Override
            public boolean startSheet(String string, int n) {
                System.out.println("S[" + n + "]=" + string);
                return super.startSheet(string, n);
            }

            @Override
            public boolean value(String string, int n, int n2) {
                System.out.println("R[" + n + "],C[" + n2 + "]=" + string);
                return super.value(string, n, n2);
            }
        });
    }

    private static final class ExcelListener
    implements HSSFListener {
        private final TableModelHelper helper;
        private final ExcelStyleFormat format;
        private final List<String> shtNms = new ArrayList<String>();
        private SSTRecord sstrec;
        private int shtNo = -1;
        private String shtNm;
        private boolean isNextRecord;
        private boolean isReadSheet = true;
        private int rcdLvl;
        private int rowNo;
        private int colNo;
        private final boolean useDebug;

        public ExcelListener(TableModelHelper tableModelHelper) {
            this.helper = tableModelHelper;
            this.useDebug = tableModelHelper.isDebug();
            this.format = new ExcelStyleFormat();
        }

        public void processRecord(Record record) {
            Object object;
            if (record instanceof CellRecord) {
                object = (CellRecord)record;
                this.rowNo = object.getRow();
                if (this.helper.isSkip(this.rowNo)) {
                    return;
                }
                this.colNo = object.getColumn();
            }
            object = null;
            block0 : switch (record.getSid()) {
                case 2057: {
                    BOFRecord bOFRecord = (BOFRecord)record;
                    if (bOFRecord.getType() == 16) {
                        if (this.shtNo < 0) {
                            this.helper.sheetSize(this.shtNms.size());
                        }
                        ++this.shtNo;
                        this.shtNm = this.shtNms.get(this.shtNo);
                        this.rcdLvl = 0;
                        this.isReadSheet = this.helper.startSheet(this.shtNm, this.shtNo);
                        if (!this.useDebug) break;
                        System.out.println("\u2460 BOFRecord:" + record);
                        break;
                    }
                    ++this.rcdLvl;
                    break;
                }
                case 10: {
                    if (this.rcdLvl == 0) {
                        this.helper.endSheet(this.shtNo);
                        this.isReadSheet = true;
                        if (!this.useDebug) break;
                        System.out.println("\u2461 EOFRecord" + record);
                        break;
                    }
                    --this.rcdLvl;
                    break;
                }
                case 133: {
                    if (this.useDebug) {
                        System.out.println("\u2462 BoundSheetRecord");
                    }
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    this.shtNms.add(boundSheetRecord.getSheetname());
                    break;
                }
                case 252: {
                    if (this.useDebug) {
                        System.out.println("\u2463 SSTRecord");
                    }
                    this.sstrec = (SSTRecord)record;
                    break;
                }
                case 224: {
                    this.format.addExtFmtRec((ExtendedFormatRecord)record);
                    break;
                }
                case 1054: {
                    this.format.addFmtRec((FormatRecord)record);
                    break;
                }
                case 515: {
                    if (!this.isReadSheet) break;
                    object = this.format.getNumberValue((NumberRecord)record);
                    break;
                }
                case 253: {
                    if (!this.isReadSheet) break;
                    LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                    object = this.sstrec.getString(labelSSTRecord.getSSTIndex()).getString();
                    break;
                }
                case 517: {
                    if (!this.isReadSheet) break;
                    BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                    byte by = boolErrRecord.getErrorValue();
                    object = by == 0 ? Boolean.toString(boolErrRecord.getBooleanValue()) : ErrorConstants.getText((int)by);
                    break;
                }
                case 6: {
                    if (!this.isReadSheet) break;
                    FormulaRecord formulaRecord = (FormulaRecord)record;
                    switch (formulaRecord.getCachedResultType()) {
                        case 0: {
                            double d = formulaRecord.getValue();
                            if (Double.isNaN(d)) {
                                this.isNextRecord = true;
                                break block0;
                            }
                            object = NumberToTextConverter.toText((double)d);
                            break block0;
                        }
                        case 4: {
                            object = Boolean.toString(formulaRecord.getCachedBooleanValue());
                            break block0;
                        }
                        case 5: {
                            object = ErrorConstants.getText((int)formulaRecord.getCachedErrorValue());
                            break block0;
                        }
                        case 1: {
                            this.isNextRecord = true;
                            break block0;
                        }
                    }
                    break;
                }
                case 519: {
                    if (!this.isReadSheet || !this.isNextRecord) break;
                    StringRecord stringRecord = (StringRecord)record;
                    object = stringRecord.getString();
                    this.isNextRecord = false;
                    break;
                }
            }
            if (object != null) {
                this.helper.value((String)object, this.rowNo, this.colNo);
            }
        }
    }
}

