/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.taglib.HTMLTagSupport;

public class ColumnEditorTag
extends HTMLTagSupport {
    private static final String VERSION = "6.2.3.0 (2015/05/01)";
    private static final long serialVersionUID = 623020150501L;
    private static final String CHECK_TYPE = "|text|search|tel|url|email|datetime|date|month|week|time|datetime-local|number|range|color|";
    private static final String DEFAULT_ADD_NO_VALUE = "true";
    private transient LabelData labelData;
    private String tableId = "h_tblmdl";
    private String[] columns;
    private boolean allColumns;
    private String className;
    private String fieldSize;
    private String viewSize;
    private String maxlength;
    private String writable;
    private String renderer;
    private String editor;
    private String dbType;
    private String codeName;
    private String codeList;
    private String codeGroup;
    private String defaultVal;
    private String parameter;
    private String dbid;
    private String addNoValue;
    private String addKeyLabel;
    private boolean writeKeyLabel;
    private String eventColumn;
    private String rawParameter;
    private String eventURL;
    private boolean useLabelMap;
    private String useSLabel;
    private String noDisplayVal;
    private Map<String, LabelData> labelMap;
    private boolean noResource;
    private boolean stringOutput = HybsSystem.sysBool("USE_STRING_EXCEL_OUTPUT");

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            if ("DBMENU".equalsIgnoreCase(this.editor)) {
                this.className = "VARCHAR2";
                this.renderer = "DBMENU";
                this.editor = "DBMENU";
                if (this.addNoValue == null) {
                    this.addNoValue = DEFAULT_ADD_NO_VALUE;
                }
            }
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        String string = this.getBodyString();
        if (string != null && string.length() > 0) {
            if (this.useLabelMap) {
                this.labelMap = this.getResource().getLabelMap(string.trim());
            } else {
                if (this.eventColumn != null && this.eventColumn.length() > 0) {
                    this.rawParameter = this.getReservedParameter(this.getBodyRawString().trim());
                }
                this.parameter = string.trim();
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        block7: {
            this.debugPrint();
            if (!this.useTag()) {
                return 6;
            }
            DBTableModel dBTableModel = (DBTableModel)this.getObject(this.tableId);
            if (dBTableModel == null) {
                return 6;
            }
            if (this.columns == null) break block7;
            String string = this.getMustType();
            if (this.allColumns) {
                int n = dBTableModel.getColumnCount();
                block0: for (int i = 0; i < n; ++i) {
                    DBColumn dBColumn = dBTableModel.getDBColumn(i);
                    for (int j = 0; j < this.columns.length; ++j) {
                        String string2 = this.columns[j].replace("*", "");
                        if (dBColumn.getName().indexOf(string2) != 0) continue;
                        DBColumnConfig dBColumnConfig = this.getModifyConfig(dBColumn);
                        dBTableModel.setDBColumn(i, new DBColumn(dBColumnConfig));
                        if (string == null) continue block0;
                        dBTableModel.addMustType(i, string);
                        continue block0;
                    }
                }
            } else {
                for (int i = 0; i < this.columns.length; ++i) {
                    int n = dBTableModel.getColumnNo(this.columns[i]);
                    DBColumn dBColumn = dBTableModel.getDBColumn(n);
                    DBColumnConfig dBColumnConfig = this.getModifyConfig(dBColumn);
                    dBTableModel.setDBColumn(n, new DBColumn(dBColumnConfig));
                    if (string == null) continue;
                    dBTableModel.addMustType(n, string);
                }
            }
        }
        return 6;
    }

    @Override
    protected String makeTag() {
        return null;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.columns = null;
        this.allColumns = false;
        this.labelData = null;
        this.className = null;
        this.fieldSize = null;
        this.viewSize = null;
        this.maxlength = null;
        this.writable = null;
        this.renderer = null;
        this.editor = null;
        this.dbType = null;
        this.codeName = null;
        this.codeList = null;
        this.codeGroup = null;
        this.defaultVal = null;
        this.parameter = null;
        this.dbid = null;
        this.addNoValue = null;
        this.addKeyLabel = null;
        this.writeKeyLabel = false;
        this.useLabelMap = false;
        this.useSLabel = null;
        this.noDisplayVal = null;
        this.labelMap = null;
        this.eventColumn = null;
        this.rawParameter = null;
        this.eventURL = null;
        this.noResource = false;
        this.stringOutput = HybsSystem.sysBool("USE_STRING_EXCEL_OUTPUT");
    }

    private DBColumnConfig getModifyConfig(DBColumn dBColumn) {
        Object object;
        String string;
        String string2;
        if (this.noResource) {
            this.labelData = new LabelData(dBColumn.getName());
            this.renderer = "LABEL";
        }
        DBColumnConfig dBColumnConfig = dBColumn.getConfig();
        String string3 = (String)this.getSessionAttribute("h_html5_key");
        if ("FALSE".equalsIgnoreCase(string3) && ("DATALIST".equalsIgnoreCase(this.editor) || "DATALIST".equalsIgnoreCase(dBColumnConfig.getEditor()))) {
            this.editor = "INDBMENU";
        }
        if ((string2 = this.get("lang")) != null) {
            dBColumnConfig.setLang(string2);
        }
        if (this.labelData != null) {
            dBColumnConfig.setLabelData(this.labelData);
        }
        if (this.className != null) {
            dBColumnConfig.setClassName(this.className);
        }
        if (this.fieldSize != null) {
            dBColumnConfig.setFieldSize(this.fieldSize);
        }
        if (this.viewSize != null) {
            dBColumnConfig.setViewLength(this.viewSize);
        }
        if (this.maxlength != null) {
            dBColumnConfig.setMaxlength(this.maxlength);
        }
        if (this.writable != null) {
            dBColumnConfig.setWritable(this.writable);
        }
        if (this.renderer != null) {
            dBColumnConfig.setRenderer(this.renderer);
        }
        if (this.editor != null) {
            dBColumnConfig.setEditor(this.editor);
        }
        if (this.dbType != null) {
            dBColumnConfig.setDbType(this.dbType);
        }
        if (this.defaultVal != null) {
            dBColumnConfig.setDefault(this.defaultVal);
        }
        if (this.parameter != null) {
            dBColumnConfig.setParameter(this.parameter);
        }
        if (this.dbid != null) {
            dBColumnConfig.setDbid(this.dbid);
        }
        if (this.eventColumn != null) {
            dBColumnConfig.setEventColumn(this.eventColumn);
        }
        if (this.eventURL != null) {
            dBColumnConfig.setEventURL(this.eventURL);
        }
        if (this.rawParameter != null) {
            dBColumnConfig.setRawParameter(this.rawParameter);
        }
        if (this.useSLabel != null) {
            dBColumnConfig.setUseSLabel(this.useSLabel);
        }
        if (this.noDisplayVal != null) {
            dBColumnConfig.setNoDisplayVal(this.noDisplayVal);
        }
        if (this.addKeyLabel != null) {
            dBColumnConfig.setAddKeyLabel(this.addKeyLabel);
        }
        if (this.writeKeyLabel) {
            dBColumnConfig.setWriteKeyLabel(this.writeKeyLabel);
        }
        if ((string = this.get("roles")) != null) {
            dBColumnConfig.setRoles(string);
        }
        if (this.codeName != null) {
            object = this.getResource().getCodeData(this.codeName);
            dBColumnConfig.setCodeData((CodeData)object);
        }
        if (this.codeList != null && (object = dBColumnConfig.getCodeData()) != null) {
            dBColumnConfig.setCodeData(((CodeData)object).subsetList(this.codeList));
        }
        if (this.codeGroup != null && (object = dBColumnConfig.getCodeData()) != null && ((CodeData)object).useGroup()) {
            dBColumnConfig.setCodeData(((CodeData)object).subsetGroup(this.codeGroup));
        }
        if (this.addNoValue != null) {
            dBColumnConfig.setAddNoValue(Boolean.parseBoolean(this.addNoValue));
        }
        dBColumnConfig.setEditorAttributes(this.getAttributes());
        if (this.useLabelMap && this.labelMap != null && (object = this.labelMap.get(dBColumn.getName())) != null) {
            dBColumnConfig.setLabelData((LabelData)object);
        }
        dBColumnConfig.setStringOutput(this.stringOutput);
        return dBColumnConfig;
    }

    public void setColumn(String string) {
        if (this.columns != null) {
            String string2 = "columns \u3068\u306e\u540c\u6642\u30bb\u30c3\u30c8\u306f\u51fa\u6765\u307e\u305b\u3093\u3002: " + CR + "column=[" + string + "] , " + "columns=[" + StringUtil.array2csv((String[])this.columns) + "]";
            throw new HybsSystemException(string2);
        }
        String string3 = this.getRequestParameter(string);
        if (string3 != null && string3.length() > 0) {
            this.columns = new String[]{string3};
            this.allColumns = string3.indexOf(42) >= 0;
        }
    }

    public void setColumns(String string) {
        if (this.columns != null) {
            String string2 = "column \u3068\u306e\u540c\u6642\u30bb\u30c3\u30c8\u306f\u51fa\u6765\u307e\u305b\u3093\u3002: " + CR + "column=[" + StringUtil.array2csv((String[])this.columns) + "] , " + "columns=[" + string + "]";
            throw new HybsSystemException(string2);
        }
        String string3 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string3 != null) {
            this.allColumns = string3.indexOf(42) >= 0;
            this.columns = StringUtil.csv2Array((String)string3);
            if (this.columns.length == 0) {
                this.columns = null;
            }
        }
    }

    public void setLabel(String string) {
        this.labelData = this.getResource().getLabelData(this.getRequestParameter(string));
    }

    public void setClassName(String string) {
        this.className = StringUtil.nval((String)this.getRequestParameter(string), (String)this.className);
    }

    public void setMaxlength(String string) {
        this.maxlength = StringUtil.nval((String)this.getRequestParameter(string), (String)this.maxlength);
        if ("0".equals(this.maxlength)) {
            this.set("NO_MAXLEN", DEFAULT_ADD_NO_VALUE);
        }
    }

    public void setSize(String string) {
        this.fieldSize = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setViewSize(String string) {
        this.viewSize = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setWritable(String string) {
        this.writable = StringUtil.nval((String)this.getRequestParameter(string), (String)this.writable);
    }

    public void setRenderer(String string) {
        this.renderer = StringUtil.nval((String)this.getRequestParameter(string), (String)this.renderer);
    }

    public void setEditor(String string) {
        this.editor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.editor);
    }

    public void setDbType(String string) {
        this.dbType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbType);
    }

    public void setCodeName(String string) {
        this.codeName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeName);
    }

    public void setCodeList(String string) {
        this.codeList = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeList);
    }

    public void setCodeGroup(String string) {
        this.codeGroup = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeGroup);
    }

    public void setParam(String string) {
        this.parameter = StringUtil.nval((String)this.getRequestParameter(string), (String)this.parameter);
        this.rawParameter = StringUtil.nval((String)string, (String)this.parameter);
    }

    public void setDefaultVal(String string) {
        this.defaultVal = StringUtil.nval((String)this.getRequestParameter(string), (String)this.defaultVal);
    }

    public void setAddNoValue(String string) {
        this.addNoValue = StringUtil.nval((String)this.getRequestParameter(string), (String)this.addNoValue);
    }

    public void setAddKeyLabel(String string) {
        this.addKeyLabel = StringUtil.nval((String)this.getRequestParameter(string), (String)this.addKeyLabel);
    }

    public void setWriteKeyLabel(String string) {
        this.writeKeyLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.writeKeyLabel);
    }

    public void setUseLabelMap(String string) {
        this.useLabelMap = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLabelMap);
    }

    public void setUseSLabel(String string) {
        this.useSLabel = StringUtil.nval((String)this.getRequestParameter(string), (String)this.useSLabel);
        if (!(this.useSLabel == null || "auto".equalsIgnoreCase(this.useSLabel) || DEFAULT_ADD_NO_VALUE.equalsIgnoreCase(this.useSLabel) || "false".equalsIgnoreCase(this.useSLabel))) {
            String string2 = "useSLabel \u306f\u3001[auto:\u81ea\u52d5/true:\u5229\u7528\u3059\u308b/false:\u5229\u7528\u3057\u306a\u3044] \u304b\u3089\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002useSLabel=[" + string + "]" + CR;
            throw new HybsSystemException(string2);
        }
    }

    public void setNoDisplayVal(String string) {
        this.noDisplayVal = StringUtil.nval((String)this.getRequestParameter(string), (String)this.noDisplayVal);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setEventColumn(String string) {
        this.eventColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.eventColumn);
    }

    public void setEventURL(String string) {
        this.eventURL = StringUtil.nval((String)this.getRequestParameter(string), (String)this.eventURL);
    }

    public void setEventCallback(String string) {
        if (string != null && string.length() > 0) {
            this.add("optionAttributes", "eventCallback='" + this.getRequestParameter(string) + "'");
        }
    }

    public void setType(String string) {
        String string2 = this.getRequestParameter(string);
        if (!this.check("|" + string2 + "|", CHECK_TYPE)) {
            String string3 = "type \u5c5e\u6027\u306f\u3001\u4e0b\u8a18\u306e\u4e2d\u304b\u3089\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002type=[" + string2 + "  in [" + CHECK_TYPE + "]";
            throw new HybsSystemException(string3);
        }
        this.set("type", string2);
    }

    public void setNoResource(String string) {
        this.noResource = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.noResource);
    }

    public void setStringOutput(String string) {
        this.stringOutput = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stringOutput);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("columns", (Object[])this.columns).println("allColumns", (Object)this.allColumns).println("className", (Object)this.className).println("size", (Object)this.fieldSize).println("viewSize", (Object)this.viewSize).println("maxlength", (Object)this.maxlength).println("writable", (Object)this.writable).println("renderer", (Object)this.renderer).println("editor", (Object)this.editor).println("codeName", (Object)this.codeName).println("dbType", (Object)this.dbType).println("defaultVal", (Object)this.defaultVal).println("parameter", (Object)this.parameter).println("dbid", (Object)this.dbid).println("addNoValue", (Object)this.addNoValue).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

