/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.opengion.fukurou.util.Closer;
import org.opengion.hayabusa.filter.GZIPResponseStream;

public class GZIPResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse origResponse;
    protected ServletOutputStream stream;
    protected PrintWriter writer;

    public GZIPResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.origResponse = httpServletResponse;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new GZIPResponseStream(this.origResponse);
    }

    public void finishResponse() {
        Closer.ioClose((Closeable)this.writer);
        Closer.ioClose((Closeable)this.stream);
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called!");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called!");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, "UTF-8"));
        return this.writer;
    }

    public void setContentLength(int n) {
    }
}

