/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * TableFilter_INDEX_HSQLDB は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。とくに、HSQLDB用のインデックス作成スクリプトを作成します。
 *
 * ここでは、テーブル一覧の検索結果より、GF07 のインデックスカラム定義テーブルから
 * 必要な情報を取得し、テーブル作成スクリプトを作成します。
 * 出力ファイルは、テーブル名＋"I.sql" という命名規則で作成します。
 * 検索では、(SYSTEM_ID,TBLSYU,TABLE_NAME,TABLE_LABEL,INDEX_NAME,NAME_JA,INDTYPE,TABLESPACE_NAME,INITIAL_EXTENT)
 * の項目を取得する必要があります。
 *
 * @og.rev 4.0.0.0 (2005/08/31) 新規作成
 *
 * @version  0.9.0  2000/10/17
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.1,
 */
public class TableFilter_INDEX_HSQLDB extends TableFilter_INDEX {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.0.2.3 (2014/10/10)" ;

	// 5.7.2.0 (2014/01/10) 特別処理 isXml=true の時に、UNIQ のため、処理しなかった場合は、EXEC_END_TAG を出さない。
	private boolean useUniq	;

	/**
	 * インデックス作成の処理を実行します。
	 *
	 * ただし、UNIQ と UNIQSEQ には、IDENTITY を付けている為、PRIMARY KEY 制約を付けません。
	 *
	 * @og.rev 5.7.2.0 (2014/01/10) ﾃｰﾌﾞﾙ作成時に、IDENTITY を付けている場合は、PRIMARY KEY 制約を付けない。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 * @param   clms	カラム名(CSV形式)
	 *
	 * @return	作成された１行分の文字列
	 */
	@Override
	protected String makeLineList( final int[] clmNo,final String[] data,final String clms ) {

		// 5.7.2.0 (2014/01/10) IDENTITY を付ける条件と同じ判定基準を使います。
		// ※ useUniq ﾌﾗｸﾞは、makeEndLine メソッドの条件判定にも使います。
		useUniq = "UNIQ".equalsIgnoreCase( clms ) || "UNIQSEQ".equalsIgnoreCase( clms ) ;

		return useUniq ? "" : super.makeLineList( clmNo,data,clms );
	}

	/**
	 * 定義の最後の部分の処理を実行します。
	 *
	 * @og.rev 5.7.2.0 (2014/01/10) UNIQ カラムで、処理しなかった場合は、EXEC_END_TAG を出さない。
	 * @og.rev 6.0.2.3 (2014/10/10) isXml で、CR + EXEC_END_TAG のキャッシュを利用します。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	定義の最後の部分
	 */
	@Override
	protected String makeEndLine( final int[] clmNo,final String[] data ) {
//		return useUniq ? "" : ( isXml ? EXEC_END_TAG : ";" );
		return useUniq ? "" : execEndTag ;
	}
}
