/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGElement;
import org.opengion.fukurou.xml.OGAttributes;

/**
 * result.jspの&lt;og:view&gt;タグを作成します。
 *
 * ●使用例
 *      JspConvertEntity e = new JspConvertEntity();
 *      e.setTableName("GF92");
 *      e.setColumnName("CLM");
 *      List&lt; JspConvertEntity&gt; a = new ArrayList&lt; JspConvertEntity&gt;();
 *      a.add( e );
 *      Map&lt; String , List&lt; JspConvertEntity&gt; &gt; m = new Map&lt; String , List&lt; JspConvertEntity &gt; &gt;();
 *      m.put( "RESULT", a );
 *      JspCreate  j = JspCreateFactory.newInstance( "QUERY",m );
 *      j.execute("&lt;og:view /&gt;");
 *
 * @og.rev 5.6.1.2 (2013/02/22) 文字列連結から、XML処理するように変更します。
 * @author Takeshi.Takada
 *
 */
public class JspCreate_VIEW extends AbstractJspCreate {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.6.1.2 (2013/02/22)" ;

	private List<JspConvertEntity> RESULT_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 *
	 * 内部で使用する JspConvertEntityのリストのマップを受け取り、初期化を行います。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、名前空間指定無しに変更します。
	 * @og.rev 5.6.1.2 (2013/02/22) 対象ファイルを、result だけから、update も含めるように変更。
	 *
	 * @param	master	JspConvertEntityのリストのマップ
	 */
	@Override
	protected void init( final Map<String,List<JspConvertEntity>> master ) {
		RESULT_ROWS	= master.get( "RESULT" );
		IS_NULL = !isNotEmpty( RESULT_ROWS );
		KEY  = ":view";		// 5.2.1.0 (2010/10/01) 名前空間指定無し
		NAME = "result,update";
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) メソッドの引数を、OGAttributes から OGElement に変更します。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、引数を使用するように変更します。
	 *
	 * @param ele OGElementエレメントオブジェクト
	 * @param	nameSpace	このドキュメントのnameSpace( og とか mis とか )
	 *
	 * @return	変換された文字列
	 * @og.rtnNotNull
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
		if( IS_NULL ) { return ""; }

		final List<String> no_displays = new ArrayList<String>();
		for( final JspConvertEntity display : RESULT_ROWS){
			// 非表示は、GF92の属性(Remarks)に、何もセットされていないカラムの事
			final String remks = display.getRemarks();
//			if ( remks == null || remks.trim().length() == 0 ) {
			if ( remks == null || remks.trim().isEmpty() ) {		// 6.0.2.5 (2014/10/31) refactoring
				no_displays.add( display.getColumnName() );
			}
		}

		final OGAttributes attri = ele.getOGAttributes();		// OGElementの内部オブジェクトなので、副作用あり
		attri.setUseCR( true );
		if ( ! no_displays.isEmpty() ) {
			attri.setVal( "noDisplay" , chainChar( no_displays ,",") );		// あれば更新、なければ追加
		}
		return ele.getText( 0 );

	//	sbTub.append( "<" ).append( ns ).append( "view" ).append( CR );
	//	sbTub.append( "\tviewFormType = \"HTMLTable\"" ).append( CR );
	//	sbTub.append( "\tcommand		= \"{@command}\"" ).append( CR );
	//	if ( ! no_displays.isEmpty() ) {
	//		sbTub.append( "\tnoDisplay	= \"").append(chainChar( no_displays ,",") ).append("\"" ).append( CR );
	//	}
	//	sbTub.append( "/>" ).append( CR );

	//	return sbTub.toString();
	}
}
