<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
    xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:og="hybs-taglib.tld"
    version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6380"
	title	= "ファイルクエリー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<form>
<og:select name="FileOption">
    <og:fileOption
		from	= "{@from}"
		value	= "{@VALUE}"
		orderBy	= "{@orderBy}"
		desc	= "{@desc}"
	>
			<og:fileWhere
				startsWith		= "{@startsWith}"
				endsWith		= "{@endsWith}"
				instr			= "{@instr}"
				equals			= "{@equals}"
				matches			= "{@matches}"
				unMatches		= "{@unMatches}"
				lastModified	= "{@lastModified}"
				isLarger		= "{@isLarger}"
				isSmaller		= "{@isSmaller}"
				isHidden		= "{@isHidden}"
				useDir			= "{@useDir}"
			/>
    </og:fileOption>
</og:select>

<og:column name="FileOptionList" list="dl_FileOptionList" />
<og:datalist id="dl_FileOptionList">
    <og:fileOption
		from	= "{@from}"
		value	= "{@VALUE}"
		orderBy	= "{@orderBy}"
		desc	= "{@desc}"
	>
			<og:fileWhere
				startsWith		= "{@startsWith}"
				endsWith		= "{@endsWith}"
				instr			= "{@instr}"
				equals			= "{@equals}"
				matches			= "{@matches}"
				unMatches		= "{@unMatches}"
				lastModified	= "{@lastModified}"
				isLarger		= "{@isLarger}"
				isSmaller		= "{@isSmaller}"
				isHidden		= "{@isHidden}"
				useDir			= "{@useDir}"
			/>
    </og:fileOption>
</og:datalist>

</form>

<br />
<og:message lbl="FileQuery:" />
<br />
<og:fileQuery
	command			= "{@command}"
	from			= "{@from}"
	multi			= "{@multi}"
	level			= "{@level}"
	orderBy			= "{@orderBy}"
	desc			= "{@desc}"
	useWritable 	= "{@useWritable}"
	useMD5			= "{@useMD5}"
	useUpdateClms	= "{@useUpdateClms}"
	addClms			= "{@addClms}"
	stopZero		= "{@stopZero}"
	maxRowCount		= "{@maxRowCount}"
	fileType		= "{@fileType}"
>
	<og:fileWhere
		startsWith		= "{@startsWith}"
		endsWith		= "{@endsWith}"
		instr			= "{@instr}"
		equals			= "{@equals}"
		matches			= "{@matches}"
		unMatches		= "{@unMatches}"
		lastModified	= "{@lastModified}"
		isLarger		= "{@isLarger}"
		isSmaller		= "{@isSmaller}"
		isHidden		= "{@isHidden}"
		useDir			= "{@useDir}"
	/>
</og:fileQuery>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="NAME" href="../fileDownload" useGamenId="false" target="_NEW" 
		keys="file,name" vals="[PARENT]/[NAME],[NAME]" />
</og:viewLink>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:equals val1="{@useUpdateClms}" val2="true">
	<og:writeCheck>
		<og:submit  action="COPY"    noWritable="LEVEL,FILE_TYPE,PARENT,NAME,LASTMODIFIED,FILE_LENGTH,RWH" />
		<og:submit  action="MODIFY"  noWritable="LEVEL,FILE_TYPE,PARENT,NAME,LASTMODIFIED,FILE_LENGTH,RWH" />
		<og:submit  action="DELETE"  columnWritable="null" />
	<br />
	</og:writeCheck>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>
</form>

<og:equals val1="{@selectedAll}" val2="true">
	<og:fileUpdate
		action			= "COPY"
		command			= "ENTRY"
		targetDir		= "{@targetDir}"
		createDir		= "{@createDir}"
		selectedAll		= "{@selectedAll}"
		keepTimeStamp	= "{@keepTimeStamp}"
	/>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
