<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC20"
	title	= "環境管理ﾃｰﾌﾞﾙ"
	date	= "2013/08/20"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select CNTXT_ID,SYSTEM_ID,NMSYS,TBLSYU,BASE_PATH,DBID,TITLE,
				DB_URL,DB_USER,DB_PASS,WEB_URL,WEB_USER,WEB_PASS,
				OS_INFO,SERVER_INFO,SERVLET_INFO,
				REAL_PATH,TOMCAT_HOME,JDK_INFO,JAVA_HOME,ENGINE_INFO,
				FGJ,UNIQ
		from GF78
	<og:where>
		<og:and value = "CNTXT_ID	like '{@CNTXT_ID}%'"	/>
		<og:and value = "SYSTEM_ID	like '{@SYSTEM_ID}%'"	/>
		<og:and value = "TBLSYU		= '{@TBLSYU}'"		/>
		<og:and value = "NMSYS		like '{@NMSYS}%'"	/>
		<og:and value = "TITLE		like '{@TITLE}%'"	/>
		<og:and value = "DBID		like '{@DBID}%'"	/>
		<og:and value = "FGJ		in  ('0','1')"		/>
	</og:where>
	<og:appear startKey="ORDER BY" value="{@ORDER_BY}" defaultVal="SYSTEM_ID,TBLSYU,DBID" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit action="COPY"	noWritable="null"	/>
	<og:submit action="MODIFY"	noWritable="CNTXT_ID,SYSTEM_ID,TBLSYU,DBID"	/>
	<og:submit action="DELETE"	columnWritable="null"	/>
	　　　<og:submit value="configSet" lbl="DBConfig Set"
				noWritable="null" keys="command" vals="NEW"	/>
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ,UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
