<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false"/>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "FAQRGST"
	title	= "標準(FAQ登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" dbid="RESOURCE">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	CASE WHEN SYSTEM_ID = '{@SYSTEM_ID}' THEN '1'
					ELSE '0' END WRITABLE
				,FGJ													<!-- 状況 -->
				,KBFAQ													<!-- FAQ区分-->
				,CDBNRUI												<!-- 分類名 -->
				,TITLE													<!-- ﾀｲﾄﾙ -->
				,SEQNO													<!-- 表示順 -->
				,SYSCODE												<!-- ｼｽﾃﾑｺｰﾄﾞ -->
				,SYSTEM_ID												<!-- ｼｽﾃﾑID -->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ -->
				,QANO													<!-- (非表示)質問番号-->
				,CASE WHEN SYSTEM_ID = '**' THEN '1'
					ELSE '0' END SYS_SEQNO								<!-- (非表示)表示順_ｼｽﾃﾑID -->
		FROM	GE80
		WHERE	SYSTEM_ID	IN	('{@SYSTEM_ID}','{@AST}')
	<og:where startKey="and">
		<og:equals val1="{@CHECK}" val2="1">
			<og:and value = "FGJ			IN		('0','1')"		/>	<!-- GE80》状態ﾌﾗｸﾞ IN ('0','1')-->
		</og:equals>
			<og:and value = "SYSCODE		=		'{@SYSCODE}'"	/>	<!-- GE80》ｼｽﾃﾑｺｰﾄﾞ	= 画面》ｼｽﾃﾑｺｰﾄﾞ-->
			<og:and value = "KBFAQ			!=		'0'"			/>	<!-- GE80》FAQ区分	≠ '0'			-->
			<og:and value = "CDBNRUI		LIKE	'{@CDBNRUI}%'"	/>
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,SYSCODE,SEQNO" />				<!-- 表示順	-->
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:equals val1="{@USER.ROLES}" val2="root" notEquals="true">	
	<og:columnEditor columns="SYSTEM_ID" defaultVal="{@SYS.SYSTEM_ID}" must="true" optionAttributes="readonly" style="border-style:solid;border:0px;background:transparent;" />
</og:equals>
<og:equals val1="{@USER.ROLES}" val2="root" >	
	<og:columnEditor columns="SYSTEM_ID" must="true" defaultVal="{@SYSTEM_ID}" optionAttributes="readonly" style="border-style:solid;border:0px;background:transparent;" />
</og:equals>
<og:columnEditor columns="TITLE,SYSCODE,CDBNRUI" must="true" />
<og:columnEditor columns="KBFAQ" codeGroup="1"/>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit value="update1" command="INSERT" lbl="INSERT" accesskey="I"
			keys="lblKey,noWritable" vals="MSG0044,UNIQ" />
	<og:submit value="update1" command="COPY"   lbl="COPY"   accesskey="C"  
			keys="lblKey,noWritable" vals="MSG0045,UNIQ" />
	<og:submit value="update1" command="MODIFY" lbl="MODIFY" accesskey="M" 
			keys="noWritable" vals='"QANO,UNIQ,SYSTEM_ID,SYSCODE,CDBNRUI,KBFAQ"' />
	<og:submit  value="update1" command="DELETE" lbl="DELETE" accesskey="Z" 
			keys="noWritable" vals='"SYSTEM_ID,SYSCODE,FGJ,CDBNRUI,TITLE,SEQNO,KBFAQ"'/>
<br />
</og:writeCheck>


<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ,QANO,SYS_SEQNO"
	selectedType = "radio"  />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
