CREATE OR REPLACE FUNCTION VIEW_ZOOM(
	XVAL    IN NUMBER   ,
	XZOOM   IN VARCHAR2 ,
	XBASE   IN NUMBER := 12  )
RETURN NUMBER
/**********************************************************************/
/* ^XŇxs܂B                                       */
/*  VIEW_ZOOM( VAL,ZOOM,BASE )                                        */
/*                                                                    */
/*	 VAL       IN NUMBER  ()   vZ錳̒l                 */
/*	 ZOOM      IN VARCHAR2           \Y[p[^             */
/*	 BASE      IN NUMBER             P\̊l = 12        */
/*                                                                    */
/*	 ^[l   vZ̒l ij                                 */
/*                                                                    */
/*	\Y[p[^ ɑΉ{vZ傫Ԃ܂B   */
/*	ΌvZׁAP\ꍇ̑傫x[XƂ          */
/*	w肷邱ƂŁAʂɉ傫ɕύXł܂B                */
/*	x[X́AftHg 12 łB                                  */
/*                                                                    */
/*    ZOOM  x        sNZϊ                          */
/*  =================================================                 */
/*      0 : PT  * 12 * 4   48    48px =  1                  */
/*      1 : QT  * 12 * 2   24    24px =  1                  */
/*      2 : P  * 12       12    12px =  1                  */
/*      3 : Q  * 12 / 1.5  8    56px =  7 Ver3.6.0.0   */
/*      4 : R  * 12 / 3    4    56px = 14                  */
/*      5 : S  * 12 / 4    3    90px = 30                  */
/*      6 : U  * 12 / 6    2    60px = 30                  */
/*      7 : PN    * 12 / 12   1    90px = 90                  */
/*      8 : QN    * 12 / 24   0.5  90px =180                  */
/*      9 : RN    * 12 / 36   0.33 60px =180                  */
/*     10 : TP  * 12 / 3.5  3.43 24px =  7                  */
/*     11 : \ς(gpς)                                  */
/*     12 : \ς(gpς)                                  */
/*     20 :  1    * 12 * 4        48 48px = 1(100)        */
/*     21 :  12   * 12 * 2        24 24px = 1(100)        */
/*     22 :  2    * 12 * 4  /  2  24 48px = 2(100) Ver 3.8.9.2 */
/*     23 :  22   * 12 * 2  /  2  12 24px = 2(100) Ver 3.8.9.2 */
/*     24 :  4    * 12 * 4  /  4  12 48px = 4(100) Ver 3.8.9.2 */
/*     25 :  42   * 12 * 2  /  4   6 24px = 4(100) Ver 3.8.9.2 */
/*     26 :  6    * 12 * 4  /  6   8 48px = 6(100) Ver 3.8.9.2 */
/*     27 :  62   * 12 * 2  /  6   4 24px = 6(100) Ver 3.8.9.2 */
/*     28 :  8    * 12 * 4  /  8   6 48px = 8(100) Ver 3.8.9.2 */
/*     29 :  82   * 12 * 2  /  8   3 24px = 8(100) Ver 3.8.9.2 */
/*     30 : 12    * 12 * 4  / 12   4 48px =12(100) Ver 3.8.9.2 */
/*     31 : 122   * 12 * 2  / 12   2 24px =12(100) Ver 3.8.9.2 */
/*                                                                    */
/**********************************************************************/
IS
    RTN     NUMBER(6);

BEGIN

	IF    XZOOM = '0'  THEN RTN := TRUNC( XVAL * XBASE * 4.0  );
	ELSIF XZOOM = '1'  THEN RTN := TRUNC( XVAL * XBASE * 2.0  );
	ELSIF XZOOM = '2'  THEN RTN := TRUNC( XVAL * XBASE        );
	ELSIF XZOOM = '3'  THEN RTN := TRUNC( XVAL * XBASE / 1.5  );
	ELSIF XZOOM = '4'  THEN RTN := TRUNC( XVAL * XBASE / 3.0  );
	ELSIF XZOOM = '5'  THEN RTN := TRUNC( XVAL * XBASE / 4.0  );
	ELSIF XZOOM = '6'  THEN RTN := TRUNC( XVAL * XBASE / 6.0  );
	ELSIF XZOOM = '7'  THEN RTN := TRUNC( XVAL * XBASE / 12.0 );
	ELSIF XZOOM = '8'  THEN RTN := TRUNC( XVAL * XBASE / 24.0 );
	ELSIF XZOOM = '9'  THEN RTN := TRUNC( XVAL * XBASE / 36.0 );
	ELSIF XZOOM = '10' THEN RTN := TRUNC( XVAL * XBASE / 3.5  );
	ELSIF XZOOM = '20' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  100.0 );
	ELSIF XZOOM = '21' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  100.0 );
	ELSIF XZOOM = '22' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  200.0 );
	ELSIF XZOOM = '23' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  200.0 );
	ELSIF XZOOM = '24' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  400.0 );
	ELSIF XZOOM = '25' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  400.0 );
	ELSIF XZOOM = '26' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  600.0 );
	ELSIF XZOOM = '27' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  600.0 );
	ELSIF XZOOM = '28' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  800.0 );
	ELSIF XZOOM = '29' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  800.0 );
	ELSIF XZOOM = '30' THEN RTN := TRUNC( XVAL * XBASE * 4.0 / 1200.0 );
	ELSIF XZOOM = '31' THEN RTN := TRUNC( XVAL * XBASE * 2.0 / 1200.0 );
	END IF ;

	RETURN RTN;

END VIEW_ZOOM;
/

