/****************************************************************************/
/* GF62 ( プロジェクトマスタ定義 )                                          */
/*                                                                          */
/* Created : 2013/07/17 17:13:37                                            */
/****************************************************************************/
CREATE TABLE GF62 (
   PRJCODE      VARCHAR2 (   30 )                                       /*  10 PRJコード    */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  20 名称         */
 , COMPANY      VARCHAR2 (  200 )                                       /*  30 会社名       */
 , VIEW_DATE    VARCHAR2 (    8 )                                       /*  40 表示開始日   */
 , VIEW_ZOOM    VARCHAR2 (    2 )       DEFAULT '1'                     /*  50 表示期間     */
 , VERNO        VARCHAR2 (   10 )                                       /*  60 バージョン   */
 , DESCRIPTION  VARCHAR2 ( 4000 )                                       /*  70 概要説明     */
 , CDJ          VARCHAR2 (    1 )                                       /*  80 状況コード   */
 , YOSAN        NUMBER   (  9,2 )                                       /*  90 予算         */
 , JISSEKI      NUMBER   (    9 )                                       /* 100 実績         */
 , COLOR        VARCHAR2 (    7 )                                       /* 180 カラー       */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ユニークキー */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態フラグ   */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF62S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF62T00 
BEFORE INSERT ON GF62
FOR EACH ROW 
BEGIN 
SELECT GF62S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

