<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX013"
	title	= "DB登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 検索条件に使用する項目一覧を表示する為のQuery -->
<og:query command="{@command}" dbid="{@DBID}" scope="request" notfoundMsg="">
		select A.COLUMN_NAME as CLM,'' as CONDITION,A.COLUMN_NAME as VALUE,A.COLUMN_ID as NO
		from USER_TAB_COLUMNS A,USER_IND_COLUMNS B
		where  A.TABLE_NAME = '{@TABLE_NAME}'
		and    A.TABLE_NAME  = B.TABLE_NAME
		and    A.COLUMN_NAME = B.COLUMN_NAME
		union
		select '' as CLM,'' as CONDITION,'' as VALUE,999 as NO
		from dual
		order by NO
</og:query>

<!-- 項目が一つの DBMENU では、ラベルリソースが使用されます。 -->
<og:columnEditor column="CLM" editor="DBMENU" dbid="{@DBID}" scope="request">
		select COLUMN_NAME
		from USER_TAB_COLUMNS
		where  TABLE_NAME = '{@TABLE_NAME}'
		order by TABLE_NAME,COLUMN_ID
</og:columnEditor>

<!-- 検索条件の値フィールドは、動的カラムを使用してフィールドを作成します。 -->
<og:columnEditor column="VALUE" editor="COLUMN" scope="request" />

<form method="POST" action="forward.jsp" target="RESULT" onClick="timeSet();">
<table>
  <tr>
	<og:column name="DBID" codeKeyVal="{@DBID_INFO}" lbl="DBID" onChange="renew('query.jsp','QUERY');" />
	<og:select name="TABLE_NAME" value="{@TABLE_NAME}"
		onChange="renew('query.jsp','QUERY');" must="true" >
		<og:option value="" lbl="" />
		<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
		<og:queryOption dbid="{@DBID}" addKey="true">
				select TABLE_NAME
				from USER_TABLES
				where  INSTR(TABLE_NAME,'$') &lt; 1
				order by TABLE_NAME
		</og:queryOption>
	</og:select>
  </tr>
</table>
<og:equals val1="{@TABLE_NAME}" val2="{@TABLE_NAME}" >
<table><tr><td valign="top">
  <og:fieldset lbl="CONDITION" defaultNone="false">
	<table>
	  <tr><td colspan="2">
		<og:view
			command			= "{@command}"
			scope			= "request"
			writable		= "true"
			selectedType	= "hidden"
			columnWritable	= "CLM,CONDITION,VALUE"
			noDisplay		= "NO"
			noMessage		= "true"
			useScrollBar	= "false"
		/>
	  </td>
	  <td valign="top" rowspan="3">
		<!-- 検索結果に表示するカラム列を指定します。 -->
		<og:text>{@LBL.CLM}</og:text> <br/>
		<og:select name="CLMS" lbl="CLM" multiple="multiple" size="10" td="false">
			<og:option value="A.*" lbl="*" selected="selected" />
			<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
			<og:queryOption dbid="{@DBID}">
					select COLUMN_NAME
					from USER_TAB_COLUMNS
					where  TABLE_NAME = '{@TABLE_NAME}'
					order by TABLE_NAME,COLUMN_ID
			</og:queryOption>
		</og:select>
	  </td>
	  </tr>
	  <tr><og:input name="AND"		lbl="AND"	   maxlength="100" size="50" /> </tr>
	  <tr><og:input name="ORDER_BY" lbl="ORDER_BY" maxlength="100" size="50" /> </tr>
	</table>
  </og:fieldset>
</td>
<td valign="top">
  <og:fieldset lbl="HIKAKU_MOTO" defaultNone="false">
    <table>
	  <tr><td colspan="2">
		<og:column name="FROM_DBID" codeKeyVal="{@DBID_INFO}" lbl="FROM_DBID" td="no" />
	  </td></tr>
	  <tr><td colspan="2">
		<og:select name="ACTION" lbl="Action" td="no">
			<og:option value=""           lbl=""      />
			<og:option value="MINUS"      lbl="MINUS"      />
			<og:option value="INTERSECT"  lbl="INTERSECT"  />
			<og:option value="UNION_ALL"  lbl="UNION_ALL"  />
			<og:option value="UNION"      lbl="UNION"      />
			<og:option value="DIFFERENCE" lbl="DIFFERENCE" />
		</og:select>
	  </td></tr>
	  <tr>
		<td>
		<og:text>{@LBL.COMPARE_KEYS}</og:text><br />
		<og:select name="masterKeys" lbl="COMPARE_KEYS" multiple="multiple" size="7" td="false" >
			<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
			<og:queryOption dbid="{@DBID}">
					select COLUMN_NAME
					from USER_TAB_COLUMNS
					where  TABLE_NAME = '{@TABLE_NAME}'
					order by TABLE_NAME,COLUMN_ID
			</og:queryOption>
		</og:select>
	  </td>
	  <td rowspan="3">
		<og:text>{@LBL.DIFF_KEYS}</og:text><br />
		<og:select name="diffKeys" lbl="DIFF_KEYS" multiple="multiple" size="7" td="false" >
			<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
			<og:queryOption dbid="{@DBID}">
					select COLUMN_NAME
					from USER_TAB_COLUMNS
					where  TABLE_NAME = '{@TABLE_NAME}'
					order by TABLE_NAME,COLUMN_ID
			</og:queryOption>
		</og:select>
	  </td>
	  </tr>
    </table>
  </og:fieldset>
</td></tr></table>
</og:equals>

<og:queryButton />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
