<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2170"
	title	= "XML出力(全DB)"
	date	= "2013/08/06"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
/>

<!-- テーブルID：名称の CSV データを作成します。 -->
<og:value command="SQL" action="ROW_APPEND" >
	select TABLE_NAME || ':' || NAME_JA AS TABLES from GF02
	where   SYSTEM_ID = '{@SYSTEM_ID}'
	and     TBLSYU	  = '{@TBLSYU}'
	and     FGJ		  = '1' 
	<og:where startKey="and">
		<og:and value = "TABLE_NAME		like '{@TABLE_NAME}%'"	/>
	</og:where>
	order by SYSTEM_ID,TABLE_NAME,TBLSYU
</og:value>

<!-- 出力先のベースフォルダ -->
<og:value command="SET" key="BASE_DIR" value="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@USER.ID}/data/{@SYSTEM_ID}" />

<table border="1" frame="box" rules="all" >
  <!-- CSVデータを、カンマで分解します。 -->
  <c:forTokens items="${TABLES}" delims="," var="KEYVAL" >
    <!-- 分解後(KEYVAL) の値を、さらに、":" で分解します。テーブルID と名称です。-->
    <og:value command="SET" key="TABLE" action="SPLIT" value="{@KEYVAL}" separator=":" />
	<tr>
      <!-- 分解された値は、キー＋番号でアクセスできます。-->
	  <td><og:text>{@TABLE0}.xml</og:text></td>
	  <td><og:text>{@TABLE1}</og:text></td>
	  <td width="70px" class="S9">
		<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="0">
			select * from {@TABLE0}
		</og:query>

		<og:value command="GET" key="DB.COUNT" />
	  </td>
	</tr>

	<og:writeTable
		fileURL        = "{@BASE_DIR}"
		filename       = "{@TABLE0}.xml"
		writerClass    = "XML"
		encode         = "UTF-8" >
		<og:writeTableParam key="TableName" value="{@TABLE0}" />
		<og:writeTableParam key="First" >
			delete from {@TABLE0}
		</og:writeTableParam>
	</og:writeTable>
  </c:forTokens>
</table>

<br />
<og:text>{@BASE_DIR} Saved</og:text>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
