<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2080"
	title	= "オブジェクト一覧"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,OBJ_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" maxRowCount="{@maxRowCount}" quotCheck="false" >
	select SYSTEM_ID,TBLSYU,OBJ_TYPE,OBJ_NAME,NAME_JA,STTS,TABLE_NAME,UNIQ,FGJ
	from GF82
	<og:where>
		<og:and value="SYSTEM_ID	=    '{@SYSTEM_ID}'"	/>
		<og:and value="TBLSYU		=    '{@TBLSYU}'"		/>
		<og:and value="OBJ_NAME		like '{@OBJ_NAME}%'"	/>
		<og:and value="OBJ_TYPE		in ( {@OBJ_TYPE} )" multi="true" />
		<og:and value="STTS			=	 '{@STATUS}'"		/>
		<og:and value="TABLE_NAME	like '{@TABLE_NAME}%'"	/>
	</og:where>
	<og:appear startKey="order by" value="{@ORDER_BY}"
				defaultVal="OBJ_NAME,OBJ_TYPE" />
</og:query>

<og:viewLink command="{@command}">
	<og:link gamenId="GF2082" column="OBJ_NAME" href="index.jsp" target="CONTENTS" onLink="[OBJ_TYPE]" markList="SEQUENCE"
		keys="command,SYSTEM_ID,TBLSYU,OBJ_TYPE,SEQNAME" vals="NEW,{@SYSTEM_ID},[TBLSYU],[OBJ_TYPE],[OBJ_NAME]" />
	<og:link gamenId="GF2081" column="OBJ_NAME" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TBLSYU,OBJ_TYPE,OBJ_NAME" vals="NEW,{@SYSTEM_ID},[TBLSYU],[OBJ_TYPE],[OBJ_NAME]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  action="COPY"    accesskey="C" noWritable="null" />
	<og:submit  action="MODIFY"  accesskey="M" columnWritable="NAME_JA"/>
	<og:submit  action="DELETE"  accesskey="Z" columnWritable="null" />
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl="INSERT_GF82" /></strong></legend>
		<og:column  name="DBID"		codeKeyVal="{@DBID_INFO}" td="no" />
		<og:column  name="TBLSYU"	defaultVal="2" addNoValue="false" td="no" />
		<og:column name="OBJ_NAME"	lbl="OBJ_NAME" size="10" onBlur="this.value=value.toUpperCase();"  />
		<og:select name="OBJ_TYPE2" lbl="OBJ_TYPE">
			<og:option lbl=""			value=""			/>
			<og:option lbl="sequence"	value="SEQUENCE"	/>
			<og:option lbl="view"		value="VIEW"		/>
			<og:option lbl="trigger"	value="TRIGGER"		/>
			<og:option lbl="synonym"	value="SYNONYM"		/>
			<og:option lbl="function"	value="FUNCTION"	/>
			<og:option lbl="package"	value="PACKAGE"		/>
			<og:option lbl="pkg body"	value="PACKAGE BODY"/>
			<og:option lbl="procedure"	value="PROCEDURE"	/>
			<og:option lbl="type"		value="TYPE"		/>
			<og:option lbl="type body"	value="TYPE BODY"	/>
		</og:select>
		<og:submit  value="directObj" lbl="DIRECT" command="INSERT" />
	</fieldset>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ,FGJ"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
