<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
			  omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="DYSET"     select="" />
<!--
  <xsl:param name="DYSET"	  select='java:org.opengion.fukurou.util.HybsDateUtil.getDate("yyyyMMddHHmmss")' />
-->

  <xsl:param name="row_header" >
	 <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
	 <TBLSYU	><xsl:value-of select="$TBLSYU"    /></TBLSYU>
	 <ADDRESS	><xsl:value-of select="$ADDRESS"   /></ADDRESS>
	 <FILENAME	><xsl:value-of select="$FILENAME"  /></FILENAME>
	 <FILEPATH	><xsl:value-of select="$FILEPATH"  /></FILEPATH>
	 <MODIFIED	><xsl:value-of select="$MODIFIED"  /></MODIFIED>
	 <DYSET		><xsl:value-of select="$DYSET"     /></DYSET>
	 <PGSET		>DOC18</PGSET>
  </xsl:param>

  <xsl:template match="jsp:root" >
	<xsl:if test="(number(@version) &lt; 2.0)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >ERROR01</MSGCD>
		<MSGTXT >jsp:root タグのversion属性は、2.0 以上を指定してください。(Tomcat5=2.0,Tomcat6=2.1,Tomcat7=2.2,Tomcat8=2.3)</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:apply-templates select="//og:sql | //og:update | //og:tableExist | //og:tabTable | //og:tab | //og:stackHeader" />
	<xsl:apply-templates select="//og:link" />
	<xsl:apply-templates select="//og:head" />
	<xsl:apply-templates select="//og:writeTable" />
	<xsl:apply-templates select="//og:option" />
	<xsl:apply-templates select="//og:value" />
	<xsl:apply-templates select="//og:hidden" />
	<xsl:apply-templates select="//og:columnEditor" />
	<xsl:apply-templates select="//og:query" />
	<xsl:apply-templates select="//og:userInfo" />
	<xsl:apply-templates select="//og:view" />
	<xsl:apply-templates select="//og:submit" />
	<xsl:apply-templates select="//og:writeCheck" />
	<xsl:apply-templates select="//og:button" />
	<xsl:apply-templates select="//og:equals" />
	<xsl:apply-templates select="//og:entry" />
	<xsl:apply-templates select="//og:viewLink" />
	<xsl:apply-templates select="//og:viewMarker" />
	<xsl:apply-templates select="//og:input" />
	<xsl:apply-templates select="//og:columnCheck" />
	<xsl:apply-templates select="//og:column" />
	<xsl:apply-templates select="//og:column | //og:input | //og:select | //og:hidden | //og:submit | //og:textarea | //input | //select | //textarea"
						 mode="form-in" />

	<xsl:apply-templates select="//form" />
	<xsl:apply-templates select="//og:frame" />
	<xsl:apply-templates select="//og:message" />
	<xsl:apply-templates select="//og:appear" />
	<xsl:apply-templates select="//og:forward" />
	<xsl:apply-templates select="//og:comment" />
	<xsl:apply-templates select="//og:queryButton" />
	<xsl:apply-templates select="//og:hideMenu" />
	<xsl:apply-templates select="//og:tableUpdate" />

	<xsl:apply-templates select="//*[@msg]   | //*[@msgParamKeys]" />
	<xsl:apply-templates select="//*[@width] | //*[@height]" />

	<xsl:apply-templates select="//*[starts-with(@onClick,'window_open')]" />
	<xsl:apply-templates select="//*[@tableId]" />
	<xsl:apply-templates select="//*[@optionAttributes]" />
	<xsl:apply-templates select="//*[@style]" />
	<xsl:apply-templates select="//*[@accesskey='D']" />
	<xsl:apply-templates select="//*[@caseNN='true'] | //*[@isRenderer='true'] | //*[@markList='true'] | //*[@onLink='true'] | //*[@useGamenId='true']" />
	<xsl:apply-templates select="//*[@debug='false'] | //*[@noMessage='false'] | //*[@nullCheck='false'] | //*[@stopZero='false'] | //*[@useCache='false'] | //*[@useParam='false']" />

	<xsl:apply-templates select="//jsp:text" />
	<xsl:apply-templates select="//frameset" />
	<xsl:apply-templates select="//script" />
	<xsl:apply-templates select="//link" />
	<xsl:apply-templates select="//style" />
	<xsl:apply-templates select="//span[@type='jsp:directive']" />

	<xsl:if test="not(//og:comment) and (starts-with($FILENAME,'query') or starts-with($FILENAME,'result') or starts-with($FILENAME,'update') or starts-with($FILENAME,'entry'))" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >ERROR02</MSGCD>
		<MSGTXT >og:comment タグを記述して下さい。</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:if test="($FILENAME='copy.jsp') or ($FILENAME='modify.jsp') or ($FILENAME='delete.jsp') or ($FILENAME='insert.jsp')" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >WARNING24</MSGCD>
		<MSGTXT ><xsl:value-of select="$FILENAME" /> は、update.jsp として統合する方向で検討してください。</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:if test="(contains($FILENAME,'コピー') or string-length($FILENAME) &gt; 20)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >WARNING25</MSGCD>
		<MSGTXT ><xsl:value-of select="$FILENAME" /> は、ファイル名が長すぎます(制限20字)。バックアップファイルならば、backup フォルダに移動してください。</MSGTXT>
		<TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>
  </xsl:template>

  <xsl:template match="og:sql" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03A</MSGCD>
		 <MSGTXT >og:sql タグは廃止クラスです。代わりに og:valueタグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:update" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03B</MSGCD>
		 <MSGTXT >og:update タグは廃止クラスです。代わりに og:tableUpdateタグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:tableExist" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03C</MSGCD>
		 <MSGTXT >og:tableExist タグは廃止クラスです。代わりに og:dataCheckタグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:tabTable | og:tab" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03D</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグは廃止クラスです。og:tabLink、og:tabList の使用をご検討ください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:stackHeader" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03E</MSGCD>
		 <MSGTXT >og:stackHeader タグは廃止クラスです。代わりに og:ganttHeaderタグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="og:link" >
	 <xsl:if test="@value and not(preceding::og:link)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04A</MSGCD>
		 <MSGTXT >og:link タグのvalue属性は廃止属性です。vals属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@keys) and (@value | @vals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR05</MSGCD>
		 <MSGTXT >og:link タグのvals属性とペアの keys属性が存在しません。keys,vals属性はセットで使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@gamenId) and starts-with(@href,'../') and not(@useGamenId='false')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR06</MSGCD>
		 <MSGTXT >og:link タグで別画面へ飛ばす場合は、gamenId属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@keys) and contains(@href,'?')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR07</MSGCD>
		 <MSGTXT >og:link タグの href でパラメータを渡す場合、keys,vals属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@href) and not(@name)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING30</MSGCD>
		 <MSGTXT >og:link タグの href属性は出来るだけ指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:head" >
	 <xsl:if test="@useTimeSet | @useToggleFrame | @useInputFocus | @useHilightRow | @usePrintLine | @useRealTimeCheck | @useAutoConvert | @useFocusHilight | @useFocusFirstElm | @useAdjustFrameHeight" >	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04B</MSGCD>
		 <MSGTXT >og:head タグの属性に廃止属性が含まれます。代替方法はありませんので、廃止属性を削除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!--
	-jspInclude=true の場合、include が取り込まれるため、代替え span タグでチェックする。
	 <xsl:if test="preceding::jsp:directive.include[contains(@file,'query_info') or contains(@file,'result_info')]" >
-->
	 <xsl:if test="preceding::span[@type='jsp:directive' and ( contains(@include,'query_info') or contains(@include,'result_info') )]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR08</MSGCD>
		 <MSGTXT >og:head タグより前に、<xsl:value-of select="@include" /> がインクルードされています。og:head タグの後ろに移動してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!--
	-jspInclude=true の場合、include が取り込まれるため、代替え span タグでチェックする。
	 <xsl:if test="(not($FILENAME='forward.jsp') and not(//jsp:directive.include[@file='/jsp/common/htmlend.jsp']))" >
-->
	 <xsl:if test="(not($FILENAME='forward.jsp') and not(//span[@type='jsp:directive' and @include='/jsp/common/htmlend.jsp']))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING26</MSGCD>
		 <MSGTXT >og:head タグを記述する場合は、/jsp/common/htmlend.jsp ファイルをインポートしてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:writeTable" >
	 <xsl:if test="@direct" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04C</MSGCD>
		 <MSGTXT >og:writeTable タグのdirect属性は廃止属性です。結果をダイレクトするとエンコード等でおかしな動きをする可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:option" >
	 <xsl:if test="@code" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04D</MSGCD>
		 <MSGTXT >og:option タグのcode属性は廃止属性です。カラムリソースで、コードカラム属性を定義して使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="ancestor::og:queryOption" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING18</MSGCD>
		 <MSGTXT >og:option タグは、queryOption タグのBODY部に入れずに、og:select タグの直下に配置してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:value" >
	 <xsl:if test="@nullSet" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04E</MSGCD>
		 <MSGTXT >og:value タグのnullSet属性は廃止属性です。属性そのものを削除可能です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="last() &gt; 10 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING05</MSGCD>
		 <MSGTXT >og:value タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="count(//og:value[@command='SQL' and contains(*,'DUAL')]) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING06</MSGCD>
		 <MSGTXT >og:value タグの SQL 構文で、DUAL を複数使用しています。まとめる事が可能か検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:hidden" >
	 <xsl:if test="@names" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04F</MSGCD>
		 <MSGTXT >og:hidden タグのnames属性は廃止属性です。keys属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@name and @keys) or (@value and @vals) or (@name and @vals) or (@keys and @value)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR09</MSGCD>
		 <MSGTXT >og:hidden タグは、name,value属性のペアか、keys,valsのペアで指定してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="string-length(@value) &gt; 80" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING34</MSGCD>
		 <MSGTXT >og:hidden タグの value属性の文字数が多いようです(制限80字)。value属性は、BODY部に記述することも可能です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:columnEditor" >
	 <xsl:if test="@parameter and not(preceding::og:columnEditor)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04G</MSGCD>
		 <MSGTXT >og:columnEditor タグのparameter属性は廃止属性です。param属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@msg] | *[@msgParamKeys]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04H</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> の msg属性や msgParamKeys属性は廃止属性です。lbl属性,lblParamKeys属性に置き換えてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@width] | *[@height]" >
	 <xsl:if test="not(string(number(@width | @height))='NaN') and not(name()='og:chartCreate')">
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR10</MSGCD>
		 <MSGTXT >width や height属性 を指定する場合は、単位(pt,px,%)が必要です。(IE7 必須)</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:query" >
	 <xsl:if test="string-length(.) &gt; 1000" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING01</MSGCD>
		 <MSGTXT >og:query タグの設定文字数が多すぎます(制限1000文字 ⇒ <xsl:value-of select="string-length(.)" />)。QUERY文を見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:userInfo" >
	 <xsl:if test="last() &gt; 10 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING02</MSGCD>
		 <MSGTXT >og:userInfo タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:view" >
	 <xsl:if test="descendant::og:message" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING03</MSGCD>
		 <MSGTXT >og:message タグは、{@LBL.XXXX} に置き換え可能です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and (ancestor::table | ancestor::div)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21A</MSGCD>
		 <MSGTXT >og:view タグを、table,div などで囲うとヘッダー固定が崩れる可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and ((following::og:link) | (following::og:column))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21B</MSGCD>
		 <MSGTXT >og:view タグの後ろに、link や column タグがあると、ヘッダー固定時に見えなくなります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@useScrollBar) and (last() &gt; 1) and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21C</MSGCD>
		 <MSGTXT >og:view タグが複数存在すると、ヘッダー固定が崩れる可能性があります。どちらかの og:view を、useScrollBar="false" でヘッダー固定を解除してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@useScrollBar='true'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING21D</MSGCD>
		 <MSGTXT >og:view のヘッダー固定は、推奨機能なので、個別に設定しないでください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:submit" >
	 <xsl:if test="not(//og:writeCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR11A</MSGCD>
		 <MSGTXT >og:submit タグは、og:writeCheck タグの子要素として使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with($FILENAME,'query') and not(//og:queryButton))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING19</MSGCD>
		 <MSGTXT >og:submit タグが、og:queryButton タグに置き換え可能か検討してみてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@value='update'" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING28A</MSGCD>
		 <MSGTXT >og:submit タグで、value="update" は、action属性で置換えを検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with($FILENAME,'update') and (@value='entry' or @value='reset'))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING28B</MSGCD>
		 <MSGTXT >og:submit タグで、value="entry" 又は "entry" の場合は、action属性で置換えを検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@accesskey and not(@action)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING28C</MSGCD>
		 <MSGTXT >og:submit タグで、action属性を使うと、accesskeyは初期設定されます。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:writeCheck" >
	 <xsl:if test="not(descendant::og:submit)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR11B</MSGCD>
		 <MSGTXT >og:writeCheck タグの子要素には、og:submit タグを使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING07</MSGCD>
		 <MSGTXT >og:writeCheck タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with($FILENAME,'result') and not(//og:errorMessage))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING16</MSGCD>
		 <MSGTXT >og:writeCheck タグを使用する場合は、og:errorMessage タグを記述して下さい。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	  </xsl:if>
  </xsl:template>

  <xsl:template match="og:button" >
	 <xsl:if test="(starts-with($FILENAME,'query') and @type='submit' and not(//og:queryButton))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING20</MSGCD>
		 <MSGTXT >og:button タグが、og:queryButton タグに置き換え可能か検討してしてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:equals" >
	 <xsl:if test="last() &gt; 10 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING04</MSGCD>
		 <MSGTXT >og:equals タグを使いすぎです(制限10個)。og:switch～og:caseタグやcaseKey,caseVal,caseNN属性等を使用してソースを判りやすく記述してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:entry" >
	 <xsl:if test="(position()=last()) and count(//og:entry[not(ancestor::og:equals)]) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR12</MSGCD>
		 <MSGTXT >og:entry タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:viewLink" >
	 <xsl:if test="last() &gt; 1 and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR13</MSGCD>
		 <MSGTXT >og:viewLink タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:viewMarker" >
	 <xsl:if test="last() &gt; 1 and not(ancestor::og:equals) and not(@isRenderer='false')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR14</MSGCD>
		 <MSGTXT >og:viewMarker タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:input" >
	 <xsl:if test="(//og:writeCheck) and (@type='submit')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING08</MSGCD>
		 <MSGTXT >og:input タグは、og:writeCheck タグの子要素として使用しないでください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:columnCheck" >
	 <xsl:if test="preceding::og:entry" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR15A</MSGCD>
		 <MSGTXT >og:columnCheck タグでチェックする前に、og:entry タグがあります。エラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(//og:entry) and starts-with($FILENAME,'result') and (//og:writeCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR15B</MSGCD>
		 <MSGTXT >og:columnCheck タグのチェック後に、og:entry タグありません。エラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@nullCheck or @mustAnyCheck) and not(ancestor::og:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING17</MSGCD>
		 <MSGTXT >og:columnCheck タグの nullCheck属性と mustAnyCheck属性は自動チェックされます。設定不要です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:column" >
	 <xsl:if test="last() &gt; 12 and position()=last() and not(//og:hideMenu) and starts-with($FILENAME,'query')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING35</MSGCD>
		 <MSGTXT >og:column タグが多すぎます(制限12個)。og:hideMenu を使って、検索条件の絞り込みを行いましょう。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:column | og:input | og:select | og:hidden | og:submit | og:textarea | input | select | textarea"
				mode="form-in" >
	 <xsl:if test="not(@writable='false' or @writable='FALSE') and not(ancestor::form) and not(@onClick='history.back()')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR16</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグが、form タグの中にありません。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="form" >
	 <xsl:if test="starts-with(@action,'../')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR17</MSGCD>
		 <MSGTXT >form タグの action属性に、相対パスを使用するのは避けてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="descendant::og:view and not(@method='POST')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING11</MSGCD>
		 <MSGTXT >テーブル登録時の form タグには、method="POST" を使用することを検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="descendant::og:view and not(starts-with(@onSubmit,'return oneClick'))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING12</MSGCD>
		 <MSGTXT >テーブル登録時の form タグには、２度押し防止JavaScript(return oneClick();)の使用を検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:frame" >
	 <xsl:if test="starts-with(@src,'../')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR18</MSGCD>
		 <MSGTXT >og:frame タグの src属性に、相対パスを指定するのは、良くない慣習です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:message" >
	 <xsl:if test="last() &gt; 10 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING14</MSGCD>
		 <MSGTXT >og:message タグを使いすぎです(制限10個)。{@LBL.XXXX} に置き換え可能です。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:appear" >
	 <xsl:if test="not(@defaultVal)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING15</MSGCD>
		 <MSGTXT >og:appear タグで、defaultVal属性を指定しないと、SQL構文エラーになる可能性があります。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@startKey='order by') and not(@startKey='ORDER BY')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING22A</MSGCD>
		 <MSGTXT >og:appear タグは、startKey="ORDER BY" の専用グと考えてください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@startKey='order by' or @startKey='ORDER BY') and ( not(contains(@value,'order_by')) and not(contains(@value,'ORDER_BY')))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING22B</MSGCD>
		 <MSGTXT >og:appear タグの、value属性は、標準的には、{&#64;ORDER_BY} の引数を与えるように統一してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:forward" >
	 <xsl:if test="not(@gamenId) and starts-with(@page,'../')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR19</MSGCD>
		 <MSGTXT >og:forward タグで別画面へ飛ばす場合は、gamenId属性を使用してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:comment" >
	 <xsl:if test="not(@system) or not(@pgid)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR20</MSGCD>
		 <MSGTXT >og:comment タグのシステム名(system)、プログラムID(pgid)は必須です。記述して下さい。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(contains(@system,$SYSTEM_ID))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING32A</MSGCD>
		 <MSGTXT >og:comment タグ の system(=<xsl:value-of select="@system" />)が、システムID(=<xsl:value-of select="$SYSTEM_ID" />)と合っているか確認してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@pgid=$ADDRESS)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING32B</MSGCD>
		 <MSGTXT >og:comment タグ の pgid(=<xsl:value-of select="@pgid" />)が、アドレス(=<xsl:value-of select="$ADDRESS" />)と合っているか確認してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:queryButton" >
	 <xsl:if test="//og:select[@name='ORDER_BY'] and not(descendant::og:select) and starts-with($FILENAME,'query')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING23</MSGCD>
		 <MSGTXT >並び順(ORDER_BY)の og:select タグを使うときは、og:queryButton のBODY部に記述するとスペースが節約できます。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:hideMenu" >
	 <xsl:if test="following::og:queryButton and starts-with($FILENAME,'query')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING36</MSGCD>
		 <MSGTXT >og:hideMenu は、og:queryButton より後ろに書くと、ボタンの位置が動かないので良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="og:tableUpdate" >
	 <xsl:if test="not(descendant::og:tableUpdateParam)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING33</MSGCD>
		 <MSGTXT >og:tableUpdate タグの使用時には、QUERYの指定に、og:tableUpdateParam タグが利用できないか検討願います。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[starts-with(@onClick,'window_open')]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING09</MSGCD>
		 <MSGTXT >window_open の代わりに、og:popup タグの使用を検討してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@tableId]" >
	 <xsl:if test="last() &gt; 3 and position()=last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING10</MSGCD>
		 <MSGTXT >tableId属性を使いすぎです(制限3個)。あまり使うとメモリが解放されなくなります。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@optionAttributes]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING29</MSGCD>
		 <MSGTXT >optionAttributes属性は、古い仕様です。JavaScriptのイベント系(onChange,onBlur等)は専用属性をご使用ください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@style]" >
	 <xsl:if test="string-length(@style) &gt; 80" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING39</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグの style属性が長すぎます(制限80字)。idもしくは classセレクタを指定し、外部ファイル(href属性)に記述しましょう。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@accesskey='D']" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING40</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグで、accesskey='D' は使えません。DELETE なら、'Z' を使ってください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@caseNN='true'] | *[@isRenderer='true'] | *[@markList='true'] | *[@onLink='true'] | *[@useGamenId='true']" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING27A</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグの <xsl:for-each select="(@caseNN | @isRenderer | @markList | @onLink | @useGamenId)" >
				<xsl:if test="(.='true')"><xsl:value-of select="name()" /> </xsl:if>
			</xsl:for-each>属性は、初期値 true ですので、初期値をあえて設定する必要はありません。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="*[@debug='false'] | *[@noMessage='false'] | *[@nullCheck='false'] | *[@stopZero='false'] | *[@useCache='false'] | *[@useParam='false']" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING27B</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグの <xsl:for-each select="(@debug | @noMessage | @nullCheck | @stopZero | @useCache | @useParam)" >
				<xsl:if test="(.='false')"><xsl:value-of select="name()" /> </xsl:if>
			</xsl:for-each>属性は、初期値 false ですので、初期値をあえて設定する必要はありません。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="jsp:text" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING31</MSGCD>
		 <MSGTXT >jsp:text は、jsp:root 直下以外では使われなくなりました。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="frameset" >
	 <xsl:if test="not(@name='SUB_FRAME') and not(@name='TOP_FRAME') and not(@name='RES_FRAME')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING13</MSGCD>
		 <MSGTXT >フレーム分割(frameset)時の自動調整機能を有効にするには、name="SUB_FRAME" が必要です。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="script" >
	 <xsl:if test="not(ancestor::og:head) and not(ancestor::head)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING37A</MSGCD>
		 <MSGTXT >script タグは、できるだけ og:head or head タグ内に記述した方が良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@type) or not(@type='text/javascript')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING38A</MSGCD>
		 <MSGTXT >script タグは、type属性は必須で、type="text/javascript" と記述してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="string-length(.) &gt; 1000" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING42</MSGCD>
		 <MSGTXT >script タグの設定文字数が多すぎます(制限1000文字 ⇒ <xsl:value-of select="string-length(.)" />)。別ファイルで管理してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="link" >
	 <xsl:if test="not(ancestor::og:head) and not(ancestor::head)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING37B</MSGCD>
		 <MSGTXT >link タグは、できるだけ og:head or head タグ内に記述した方が良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="style" >
	 <xsl:if test="not(ancestor::og:head) and not(ancestor::head)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING37C</MSGCD>
		 <MSGTXT >style タグは、できるだけ og:head or head タグ内に記述した方が良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@type) or not(@type='text/css')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING38B</MSGCD>
		 <MSGTXT >style タグの、type属性は必須ではありませんが、できれば、type="text/css" と記述してください。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="span[@type='jsp:directive']" >
	 <xsl:if test="(@pageEncoding='non')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING41</MSGCD>
		 <MSGTXT >インクルードファイル(<xsl:value-of select="@file" />)の先頭には、jsp:directive.page タグで pageEncoding="UTF-8" を記述した方が良いです。</MSGTXT>
		 <TEXT_DATA><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

</xsl:stylesheet>
