<jsp:directive.page pageEncoding="UTF-8" />
<og:query command="{@command}" debug="{@debug}" maxRowCount="0" stopZero="true">
	select * from (
		select	RENDERER,EDITOR,DBTYPE,'' as DTYPE,CLM,CLM_NAME,
				TABLE_NAME,NAME_JA,SEQNO,
				CLS_NAME,USE_LENGTH,PHY_LENGTH,
				KBCLM,BIKO,SYSTEM_ID,FGJ,UNIQ,
				case	when 
							(
								(
										RENDERER not in ( 'MENU','DBMENU','CHBOX' )
									or	EDITOR   not in ( 'MENU','DBMENU','CHBOX' )
									or	CLS_NAME  != 'VARCHAR2'
								)
								and	(
										CLM like 'FG%'
									or  CLM like 'CD%'
									or  CLM like 'KB%'
								)
								and	(	USE_LENGTH in ( '1','2' )	)
							) then 'FG,CD,KBで始まるカラムが、MENU 関係ではありません'
						when
							(	INSTR( BIKO, ':' ) = 0
								and	(
										CLM like 'FG%'
									or  CLM like 'CD%'
									or  CLM like 'KB%'
								)
								and	(	USE_LENGTH in ( '1','2' )	)
							) then 'FG,CD,KBで始まるカラムに、備考にコードリソースが記述されていません'
						when
							(
								CLS_NAME  != 'NUMBER'
								and	(
										CLM like 'SU%'
									or  CLM like 'NO%'
									or  CLM like 'KN%'
									or  CLM like 'TK%'
									or  CLM like 'SEQ%'
								)
							) then 'SU,NO,KN,TN,SEQで始まるカラムが、NUMBER型ではありません'
						when
							(
								CLS_NAME  != 'VARCHAR2'
								and	(
										CLM like 'NM%'
								)
							) then 'NNで始まるカラムが、VARCHAR2型ではありません'
						when
							(
								CLM like 'DY%'
								and	(
										RENDERER not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	EDITOR   not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	DBTYPE   not in ( 'YMD','YMDH','MD','YM','DATE' )
									or	CLS_NAME  != 'VARCHAR2'
								)
							) then 'DYで始まるカラムが、日付型ではありません'
						when
							( regexp_instr( CLM_NAME , '[０-９Ａ-Ｚａ-ｚァ-ヶ]' ) > 0
							) then 'カラム名に全角英数字が使われています'
						else null end as RIYU
		from GF80
		where SYSTEM_ID  = '{@SYSTEM_ID}'
		and   TBLSYU      = '{@TBLSYU}'
		<og:where startKey="and">
			<og:and value="TABLE_NAME like '{@TABLE_NAME}%'" />
			<og:and value="CLM        like '{@CLM}%'" />
		</og:where>
		and   KBCLM		<= '5'
		and   FGJ		= '1'
	)
	where RIYU is not null
	order by SYSTEM_ID,CLM,TABLE_NAME
</og:query>

<!-- UNIQ のみでユニークになるが、安全のため、SYSTEM_IDとTBLSYUだけは条件に加えておく -->
<og:hidden name="SQL" >
	UPDATE GF80 SET
			CLM 			= [CLM],
			CLM_NAME		= [CLM_NAME],
			CLS_NAME		= [CLS_NAME],
			PHY_LENGTH		= [PHY_LENGTH],
			USE_LENGTH		= [USE_LENGTH],
			RENDERER		= [RENDERER],
			EDITOR			= [EDITOR],
			DBTYPE			= [DBTYPE],
			KBCLM			= [KBCLM],
			BIKO			= [BIKO],
			CDKH			= 'C',
			FGJ				= '1',
			DYUPD			= '{@USER.YMDH}',
			USRUPD			= '{@USER.ID}',
			PGUPD			= '{@GUI.KEY}'
	WHERE UNIQ		= [UNIQ]
	AND   SYSTEM_ID	= '{@SYSTEM_ID}'
	AND   TBLSYU	= '{@TBLSYU}'
</og:hidden>

<og:hidden name="noWritable">SYSTEM_ID,TABLE_NAME,NAME_JA,SEQNO,DTYPE</og:hidden>
