/****************************************************************************/
/* GF94 ( 項目チェック基準書 )                                              */
/*                                                                          */
/* Created : 2013/07/05 19:03:08                                            */
/****************************************************************************/
CREATE TABLE GF94 (
   SYSTEM_ID    VARCHAR2 (   10 )                                       /*  10 システムID       */
 , PGID         VARCHAR2 (   30 )                   NOT NULL            /*  20 PG-ID            */
 , NMSYORI      VARCHAR2 (  100 )                                       /*  30 処理グループ名   */
 , SEQ          NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  40 順               */
 , CLM          VARCHAR2 (   30 )                                       /*  50 項目             */
 , DESC_CHECK   VARCHAR2 (  500 )                                       /*  60 チェック内容     */
 , ERR_NO       VARCHAR2 (   10 )                                       /*  70 エラー番号       */
 , ERR_MSG      VARCHAR2 ( 1000 )                                       /*  80 エラーメッセージ */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  90 ユニークキー     */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 100 状態フラグ       */
 , DYSET        VARCHAR2 (   14 )                                       /* 110 登録日時         */
 , PGSET        VARCHAR2 (   10 )                                       /* 120 作成PG           */
 , PGPSET       VARCHAR2 (   10 )                                       /* 130 作成親PG         */
 , USRSET       VARCHAR2 (   10 )                                       /* 140 作成社員         */
 , DYUPD        VARCHAR2 (   14 )                                       /* 150 更新日時         */
 , PGUPD        VARCHAR2 (   10 )                                       /* 160 更新PG           */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 170 更新親PG         */
 , USRUPD       VARCHAR2 (   10 )                                       /* 180 更新者           */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF94S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF94T00 
BEFORE INSERT ON GF94
FOR EACH ROW 
BEGIN 
SELECT GF94S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

