<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0018"
	title    = "データロール"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	5.6.6.0 2013/07/05 ROLE検索方法変更
</og:comment>

<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_NAME_JA" value="NAME" />
	<og:value command="SET" key="C_ROLES" value="ROLE" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_NAME_JA" value="NAME_JA" />
	<og:value command="SET" key="C_ROLES" value="ROLES" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,USERID,NAME_JA,ROLES"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@KBROLE}" val2="2">
	<og:value command="SET" key="KEY_ROLES" value="DROLES" />
</og:equals>
<og:equals val1="{@KBROLE}" val2="2" notEquals="true">
	<og:value command="SET" key="KEY_ROLES" value="ROLES" />
</og:equals>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.SYSTEM_ID,A.USERID, A.{@C_NAME_JA}, A.{@KEY_ROLES}, A.UNIQ, 'RLS_'{@DBF.CON}B.{@C_ROLES} TMP_ROLE
				,case when '|'{@DBF.CON}A.{@KEY_ROLES}{@DBF.CON}'|' like '%|'{@DBF.CON}B.{@C_ROLES}{@DBF.CON}'|%' then '1' else '0' end IS_CHECK
		from	GEA10 A inner join GEA05 B
		on		A.SYSTEM_ID	= B.SYSTEM_ID
	</jsp:text>
		<og:where startKey="and">
			<og:and value = "'|'{@DBF.CON}B.{@C_ROLES}{@DBF.CON}'|' like '%{@ROLES}%'" />
			<og:and value = "B.KBROLE	= '{@KBROLE}'" />
			<og:and value = "B.FGJ		= '1'" />
		</og:where>
	<og:where>
		<og:and value = "A.FGJ				=		'1'"			/>
		<og:and value = "A.SYSTEM_ID		=		'{@SYSTEM_ID}'"	/>
		<og:and value = "A.USERID			like	'{@USERID}%'"	/>
		<og:and value = "A.{@C_NAME_JA}		like	'{@NAME_JA}%'"	/>
		<og:and value = "'|'{@DBF.CON}A.{@KEY_ROLES}{@DBF.CON}'|'	like	'%{@ROLES}%'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.USERID,B.{@C_ROLES}" />
</og:query>

<og:tableFilter classId="ROTATE" selectedAll="true"
	keys="ROTATE_CLM,KEY_CLM,VALUE_CLM" vals='TMP_ROLE,"SYSTEM_ID,USERID,{@C_NAME_JA},{@KEY_ROLES},UNIQ",IS_CHECK' />

<og:columnEditor columns="{@KEY_ROLES}" renderer="SLABEL" parameter="4" />

<og:columnEditor columns="RLS*" renderer="chbox" editor="chbox" />
<og:columnEditor columns="RLS*" useLabelMap="true">
	select 'RLS_'{@DBF.CON}{@C_ROLES}, NMROLE{@DBF.CON}'&lt;br&gt;('{@DBF.CON}{@C_ROLES}{@DBF.CON}')'
	from GEA05
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and KBROLE		= '{@KBROLE}'
	and FGJ			= '1'
</og:columnEditor>

<table border="1">
	<tr><th></th>
		<th><og:message lbl="KBROLE.1" /></th>
		<th><og:message lbl="KBROLE.2" /></th>
	</tr>
	<tr>
		<td><b><og:message lbl="GEM0034" /></b></td>
		<td><og:message lbl="GEM0035" /></td>
		<td><og:message lbl="GEM0036" /></td>
	</tr>
	<tr>
		<td><b><og:message lbl="GEM0038" /></b></td>
		<td><og:message lbl="GEM0039" /></td>
		<td><og:message lbl="GEM0039" /></td>
	</tr>
</table>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable,noDisplay" vals='"USERID,{@C_NAME_JA},{@KEY_ROLES}","SYSTEM_ID,UNIQ"' />
	<og:submit  value="update"   lbl="DIRECT_MODIFY"    command="MODIFY" accesskey="D"
		keys="columnWritable,noDisplay,direct" vals='"{@KEY_ROLES}","SYSTEM_ID,UNIQ",true' />

	<og:link gamenId="GE0017" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,KBROLE,FGJ"
		vals="NEW,{@SYSTEM_ID},{@KBROLE},1">[{@LBL.GE0017}]</og:link>
	<og:equals val1="{@KBROLE}" val2="1" >
		<og:link gamenId="GE0020" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID"
			vals="NEW,{@SYSTEM_ID}">[{@LBL.GE0020}]</og:link>
	</og:equals>
	<og:equals val1="{@KBROLE}" val2="2" >
		<og:link gamenId="GE0018" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,FGJ"
			vals="NEW,{@SYSTEM_ID},1">[{@LBL.GE0018}]</og:link>
	</og:equals>
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "SYSTEM_ID,UNIQ"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />

<og:hidden name="KEY_ROLES" value="{@KEY_ROLES}" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
