<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:requestCache cacheKey="{@GUI.KEY}" />

<og:fileUD typeDownload="true">
	<og:query
		command		= "NEW"
		maxRowCount	= "0"
		quotCheck	= "false"
		scope		= "request"
		mainTrans	= "false"
		queryType	= "{@USER.LASTSQLTYPE}"
		names		= "{@USER.LASTNAMES}">
		<jsp:text>
			{@USER.LASTSQL}
		</jsp:text>
	</og:query>
</og:fileUD>

<og:value command="SET" key="MODELNAME">
<og:userInfo command="GET" key="REPORT_DEFAULT_MODELNAME_{@gamenId}" />
</og:value>

<og:equals val1="{@MODELNAME}" nullCheck="true">
	<og:value command="SET" key="MODELNAME" value="Default" />
</og:equals>

<og:file action="exists" fileURL="{@SYS.REAL_PATH}report/{@gamenId}" file1="fileDownloadList.txt" notEquals="true" useStop="false">
	<og:readTable
		command		= "NEW"
		fileURL		= "{@SYS.REAL_PATH}report/{@gamenId}"
		filename	= "fileDownloadList.txt"
		tableId		= "list"
		scope		= "request"
		mainTrans	= "false"
	/>

	<og:readTable
		command		= "NEW"
		fileURL		= "{@SYS.REAL_PATH}report/{@gamenId}"
		filename	= "fileDownloadList.txt"
		maxRowCount	= "1"
		tableId		= "dummy"
		scope		= "request"
		mainTrans	= "false"
	/>
	<og:entry command="MODIFY" tableId="dummy" scope="request" selectedAll="true">
		<og:columnSet command="MODIFY" columnId="MODELNAME" action="SET" value="{@MODELNAME}"/>
	</og:entry>

	<!-- fileDownloadList.txtを結合し、出力対象のデータを設定します -->
	<og:tableMerge
		action			= "INTERSECT"
		masterTableId	= "list"
		masterScope		= "request"
		slaveTableId	= "dummy"
		slaveScope		= "request"
		masterKeys		= "MODELNAME"
		slaveKeys		= "MODELNAME"
		tableId			= "out"
		scope			= "request"
		mainTrans		= "false"
	/>

	<og:value command="SETTBL" tableId="out" tblScope="request" key="MODELNAME" action="FIRST" />
	<og:value command="SETTBL" tableId="out" tblScope="request" key="REPNAME" action="FIRST" />
	<og:value command="SETTBL" tableId="out" tblScope="request" key="TYPE" action="FIRST" />
	<og:value command="SETTBL" tableId="out" tblScope="request" key="ISREP" action="FIRST" />

	<!-- ユーザーが追加した帳票の場合 -->
	<og:equals val1="{@ISREP}" val2="Y">
		<og:file action="exists" fileURL="{@SYS.REAL_PATH}report/{@gamenId}" file1="{@MODELNAME}.ods" notEquals="true" useStop="false">
			<og:equals val1="{@TYPE}" val2="P">
				<og:value command="SET" key="endWith" value="pdf"/>
			</og:equals>

			<og:equals val1="{@TYPE}" val2="E">
				<og:value command="SET" key="endWith" value="xls"/>
			</og:equals>

			<og:report2
				fileURL		= "{@SYS.REAL_PATH}report/{@gamenId}/"
				listId		= "{@MODELNAME}"
				outFileURL	= "{@USER.ID}/"
				outFilename	= "{@MODELNAME}.{@endWith}"
				fgrun		= "{@TYPE}"
				scope		= "request"
			/>

			<og:forward page="{@SYS.FILE_OUT_URL}/{@USER.ID}/{@MODELNAME}.{@endWith}" filename="{@REPNAME}.{@endWith}" />
		</og:file>
	</og:equals>
</og:file>

<!-- ファイルが強制削除されるなどして、帳票発行ができない場合は、Defaultで発行します -->
<og:equals val1="|Default|Renderer|Excel|XLSNR|" val2="|{@MODELNAME}|" contains="true" notEquals="true">
	<og:value command="SET" key="MODELNAME" value="Default" />
</og:equals>

<og:equals val1="Excel" val2="{@MODELNAME}">
	<og:value command="SET" key="MODELNAME" value="{@MODELNAME}Renderer" />
	<og:value command="SET" key="CLMS" value="{@DB.CLM_NAMES}"/>
</og:equals>
<og:equals val1="XLSNR" val2="{@MODELNAME}"><!-- 2013/04/27 5.6.3.4 -->
	<og:value command="SET" key="MODELNAME" value="Excel" />
</og:equals>
<og:equals val1="Renderer" val2="{@MODELNAME}">
	<og:value command="SET" key="CLMS" value="{@DB.CLM_NAMES}"/>
</og:equals>

<og:writeTable
	writerClass		= "{@MODELNAME}"
	fileURL			= "{@USER.ID}"
	filename		= "fileout.xls"
	columns			= "{@CLMS}"
	encode			= "{@SYS.FILE_ENCODE}"
	scope			= "request"
/>

<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/fileout.xls" filename="{@filename}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
