<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX001"
	title	= "逆引マニュアル"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command = "{@command}" debug="false">
	<jsp:text>
		select  
				SEQ,
				TITLE,
				ANSWER,
				DIFFICULTY,
				PARTNO    || '.' || PART    PART,
				CHAPTERNO || '.' || CHAPTER CHAPTER,
				BIG_CLASS, 
				INSIDE_CLASS,
				KEYWORD,
				'' OPEN
		from    GF27
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "SEQ          =    '{@SEQ}'"           />
		<og:and value = "TITLE        LIKE '{@TITLE}%'"        />
		<og:and value = "ANSWER       LIKE '{@ANSWER}%'"       />
		<og:and value = "DIFFICULTY   LIKE '{@DIFFICULTY}%'"   />
		<og:and value = "PARTNO       =    '{@PARTNO}'"        />
		<og:and value = "CHAPTERNO    =    '{@CHAPTERNO}'"     />
		<og:and value = "BIG_CLASS    =    '{@BIG_CLASS}'"     />
		<og:and value = "INSIDE_CLASS =    '{@INSIDE_CLASS}'"  />
		<og:and value = "KEYWORD      LIKE '%{@KEYWORD}%'"     />
		<og:and value = "CONTENTS     LIKE '%{@CONTENTS}%'"    />
		<og:and value = "SAMPLE       LIKE '%{@SAMPLE}%'"      />
<!--	<og:and value = "FGJ in ( '0','1' )" />		-->
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@SORT}" defaultVal="SEQ" />
</og:query>

<og:viewLink command="{@command}">
	<og:link column="TITLE" gamenId="DOC05" href="contents.jsp" target="CONTENTS"
			keys="command,SEQ" vals="NEW,[SEQ]" />
	<og:link column="OPEN"  gamenId="DOC06" href="result.jsp" target="CONTENTS"
			keys="command,SEQ" vals="NEW,[SEQ]" >
		<img src="{@SYS.JSP}/image/EditFile.gif" alt="OPEN" />
	</og:link>
</og:viewLink>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLFormatTable"
	command 	 = "{@command}"
	writable     = "false"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
	rowspan      = "2"
>
<tr><td>[SEQ]</td><td>[TITLE]</td>
	<td>[PART]</td><td>[CHAPTER]</td><td>[OPEN]</td>
</tr>
<tr><td>[DIFFICULTY]</td><td>[ANSWER]</td>
	<td>[BIG_CLASS]</td><td>[INSIDE_CLASS]</td><td>[KEYWORD]</td>
</tr>
</og:view>

<!-- ここまで。 -->
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
