<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useHrefIcon="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6260"
	title	= "アップロード"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 注意 upload タグで、multipart/form-data から値を取り出しているため、
	 このタグより前では、{@xxxx} は、使用できません。
	 {@USER.xxxx} は、別途登録しているので、使用できます。   -->
<og:upload
	fileURL		= "{@USER.ID}"
	columns		= "FILE,FILE_ORG,FILE_NEW,BIKO,submitter,writable,SEQNO,SYSTEM_ID,PATH,THUMB_PATH"
	useBackup	= "true"
/>
<br />
<og:message lbl="MSG0003" comment="ファイルの登録が完了しました。" />

<og:entry command="ALLACTION">
	<og:columnSet command="ALLACTION" columnId="SYSTEM_ID" action="SET"    value="{@SYS.SYSTEM_ID}" />
	<og:columnSet command="ALLACTION" columnId="SYSTEM_ID" action="SET"    value="{@SYS.SYSTEM_ID}" />
	<og:columnSet command="ALLACTION" columnId="PATH"      action="SET"    value="{@SYS.FILE_URL}{@USER.ID}" />
</og:entry>

<og:tableFilter classId="THUMBNAIL" keys="PATH_CLM,FILE_CLM,THUMB_CLM" vals="PATH,FILE,THUMB_PATH" />

<og:columnEditor column="FILE" renderer="ICON" />

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="FILE"  onMark="[THUMB_PATH]" markList="[THUMB_PATH]">
		<img src="{@SYS.CONTEXT_URL}[THUMB_PATH]" alt="THUMB_PATH" />
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<og:link column="FILE_ORG" href="{@SYS.CONTEXT_URL}[PATH]/[FILE_ORG]" target="_blunk" useGamenId="false" />
</og:viewLink>

<style type="text/css">
	img.ICON { max-width:100px; max-height:100px; }

/* head タグの useHrefIcon="true" 採用
	a[href^="http://"] {
		background:transparent url(../image/ext/html.png) center left no-repeat;
		display:inline-block;
		padding-left:18px;
	 }

	a[href$='.pdf'] , a[href$='.txt'] {
		background:transparent url(../image/ext/pdf.png) center left no-repeat;
		display:inline-block;
		padding-left:18px;
	 }

	a[href$='.zip'] , a[href$='.rar'] , a[href$='.gzip'] {
		background:transparent url(../image/ext/zip.png) center left no-repeat;
		display:inline-block;
		padding-left:18px;
	 }

	a[href$='.gif'] , a[href$='.jpg'] , a[href$='.jpeg'] , a[href$='.png'] {
		background:transparent url(../image/ext/picture.png) center left no-repeat;
		display:inline-block;
		padding-left:18px;
	 }
*/
</style>

<form>
<table>
<tr>
  <td>
	<og:view
		command      = "NEW"
		viewFormType = "HTMLTable" 
		writable     = "{@writable}"
		useScrollBar = "false"
	/>
  </td>
  <td>
	<table>
	  <tr><og:input name="submitter" value="{@submitter}" /></tr>
	  <tr><og:input name="writable"  value="{@writable}"  /></tr>
	  <tr><og:input name="directory" value="{@directory}" /></tr>
	  <tr><og:input name="file_01"     value="{@file_01}"     /></tr>
	  <tr><og:input name="file_01_NEW" value="{@file_01_NEW}" /></tr>
	  <tr><og:input name="file_01_ORG" value="{@file_01_ORG}" /></tr>
	  <tr><og:input name="file_02"     value="{@file_02}"     /></tr>
	  <tr><og:input name="file_02_NEW" value="{@file_02_NEW}" /></tr>
	  <tr><og:input name="file_02_ORG" value="{@file_02_ORG}" /></tr>
	  <tr><og:input name="file_03"     value="{@file_03}"     /></tr>
	  <tr><og:input name="file_03_NEW" value="{@file_03_NEW}" /></tr>
	  <tr><og:input name="file_03_ORG" value="{@file_03_ORG}" /></tr>
	</table>
  </td>
</tr>
</table>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
