<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX013"
	title	= "DB登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<jsp:directive.include file="sqlValues.jsp" />

<!-- 検索条件に使用する項目一覧を表示する為のQuery -->
<og:query command="{@command}" dbid="{@FROM_DBID}" scope="request" notfoundMsg="" quotCheck="false">
	{@IND_COLUMNS}
</og:query>

<!-- 項目が一つの DBMENU では、ラベルリソースが使用されます。 -->
<og:columnEditor column="CLM" editor="DBMENU" dbid="{@FROM_DBID}" scope="request" >
	{@TAB_COLUMNS}
</og:columnEditor>

<!-- 検索条件の値フィールドは、動的カラムを使用してフィールドを作成します。 -->
<og:columnEditor column="VAL" editor="COLUMN" scope="request" />

<form method="POST" action="forward.jsp" target="RESULT" onClick="timeSet();">
<table>
  <tr>
	<og:select name="TABLE_NAME" value="{@TABLE_NAME}"
		onChange="renew('query.jsp','QUERY');" must="true" >
		<og:option value="" lbl="" />
		<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
		<og:queryOption dbid="{@FROM_DBID}" addKey="true" quotCheck="false">
			{@TABLES}
		</og:queryOption>
	</og:select>
	<og:column  name="FROM_DBID"  size="6"  onChange="renew('query.jsp','QUERY');" />
	<og:column  name="TO_DBID"    size="6" />
	<td>
		<og:select name="ACTION" lbl="Action" td="no">
			<og:option value=""           lbl=""           />
			<og:option value="MINUS"      lbl="MINUS"      />
			<og:option value="DIFFERENCE" lbl="DIFFERENCE" />
			<og:option value="GROUP"      lbl="GROUP"      />
		</og:select>
	</td>
  </tr>
</table>
<og:equals val1="{@TABLE_NAME}" val2="{@TABLE_NAME}" >
  <!-- 検索条件の指定 -->
<table><tr style="vertical-align:top;"><td>
  <og:fieldset lbl="CONDITION" defaultNone="false">
	<table>
	  <tr><td colspan="2">
		<og:view
			command			= "{@command}"
			scope			= "request"
			writable		= "true"
			selectedType	= "hidden"
			columnWritable	= "CLM,CONDITION,VAL"
			noDisplay		= "SEQ"
			noMessage		= "true"
			useScrollBar	= "false"
			useAfterHtmlTag = "false"
		/>
	  </td>
	  <td rowspan="3" style="vertical-align:top;">
		<og:text>{@LBL.QUERY}</og:text><br />
		<!-- 検索結果に表示するカラム列を指定します。 -->
		<og:select name="CLMS" multiple="multiple" size="10" td="false">
			<og:option value="A.*" lbl="*" selected="selected" />
			<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
			<og:queryOption dbid="{@FROM_DBID}" quotCheck="false">
				{@TAB_COLUMNS}
			</og:queryOption>
		</og:select>
	  </td>
	  </tr>
	  <tr><og:input name="AND"       lbl="AND"		maxlength="200" size="30" />	</tr>
	  <tr><og:input name="ORDER_BY"  lbl="ORDER_BY"	maxlength="200" size="30" />	</tr>
	  <tr><og:input name="UNIQ_KEYS" lbl="UNIQ"		value="{@UNIQS}" maxlength="200" size="30" />	</tr>
	</table>
  </og:fieldset>
</td><td>
  <!-- Action条件(キー差分、属性差分)の指定 -->
  <og:fieldset lbl="CONDITION" defaultNone="false">
	<table>
	  <tr>
	  <td>
		KEY<br />
		<!-- 検索結果に表示するカラム列を指定します。 -->
		<og:select name="KEY_CLMS" multiple="multiple" size="10" td="false">
			<og:option value="A.*" lbl="*" selected="selected" />
			<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
			<og:queryOption dbid="{@FROM_DBID}" quotCheck="false">
				{@TAB_COLUMNS}
			</og:queryOption>
		</og:select>
	  </td>
	  <td>
		DEF<br />
		<!-- 検索結果に表示するカラム列を指定します。 -->
		<og:select name="DEF_CLMS" multiple="multiple" size="10" td="false">
			<og:option value="A.*" lbl="*" selected="selected" />
			<!-- 項目が一つの queryOption では、ラベルリソースが使用されます。 -->
			<og:queryOption dbid="{@FROM_DBID}" quotCheck="false">
				{@TAB_COLUMNS}
			</og:queryOption>
		</og:select>
	  </td>
	  </tr>
	</table>
  </og:fieldset>
</td></tr></table>
</og:equals>

<og:queryButton />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
