/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.LDAPSearch;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class MailSenderTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0.0 (2007/11/20)";
    private static final long serialVersionUID = 400020071120L;
    private transient MailTX mail = null;
    private String host = HybsSystem.sys("COMMON_MAIL_SERVER");
    private String charset = HybsSystem.sys("MAIL_DEFAULT_CHARSET");
    private String from = null;
    private String[] to = null;
    private String[] cc = null;
    private String[] bcc = null;
    private String[] replyTo = null;
    private String subject = null;
    private String[] filename = null;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private boolean useLDAP = false;
    private String ldapKey = "uid";
    private String ldapVals = "cn,mail";

    @Override
    public int doStartTag() {
        this.mail = new MailTX(this.host, this.charset);
        return 2;
    }

    @Override
    public int doAfterBody() {
        String string = this.getBodyString();
        this.mail.setMessage(string);
        return 0;
    }

    @Override
    public int doEndTag() {
        Object object;
        String[] stringArray;
        this.debugPrint();
        if (this.useLDAP) {
            stringArray = StringUtil.csv2Array((String)this.ldapVals);
            object = new LDAPSearch();
            ((LDAPSearch)object).setAttributes(stringArray);
            ((LDAPSearch)object).init();
            this.from = this.setLDAPAddress((LDAPSearch)object, this.from);
            this.to = this.setLDAPAddress((LDAPSearch)object, this.to);
            this.cc = this.setLDAPAddress((LDAPSearch)object, this.cc);
            this.bcc = this.setLDAPAddress((LDAPSearch)object, this.bcc);
            this.replyTo = this.setLDAPAddress((LDAPSearch)object, this.replyTo);
        }
        this.mail.setFrom(this.from);
        this.mail.setTo(this.to);
        this.mail.setCc(this.cc);
        this.mail.setBcc(this.bcc);
        this.mail.setReplyTo(this.replyTo);
        this.mail.setSubject(this.subject);
        this.mail.setDebug(this.isDebug());
        if (this.filename != null && this.filename.length > 0) {
            stringArray = new String[this.filename.length];
            object = HybsSystem.url2dir(this.fileURL);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = StringUtil.urlAppend((String)object, (String)this.filename[i], (String[])new String[0]);
            }
            this.mail.setFilename(stringArray);
        }
        this.mail.sendmail();
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.mail = null;
        this.host = HybsSystem.sys("COMMON_MAIL_SERVER");
        this.charset = HybsSystem.sys("MAIL_DEFAULT_CHARSET");
        this.from = null;
        this.to = null;
        this.cc = null;
        this.bcc = null;
        this.replyTo = null;
        this.subject = null;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = null;
        this.useLDAP = false;
        this.ldapKey = "uid";
        this.ldapVals = "cn,mail";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String setLDAPAddress(LDAPSearch lDAPSearch, String string) {
        if (string == null) return string;
        if (string.indexOf(64) >= 0) return string;
        List<String[]> list = lDAPSearch.search(this.ldapKey + "=" + string);
        if (list.size() == 1) {
            String[] stringArray = list.get(0);
            if (this.ldapVals.indexOf(44) >= 0) return stringArray[0] + "<" + stringArray[1] + ">";
            return stringArray[0];
        }
        String string2 = "LDAP\u691c\u7d22\u306e\u7d50\u679c\u3001\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u8a2d\u5b9a\u5024=[" + string + "] , \u691c\u7d22\u30ad\u30fc=[" + this.ldapKey + "] , \u691c\u7d22\u5c5e\u6027=[" + this.ldapVals + "]";
        throw new HybsSystemException(string2);
    }

    private String[] setLDAPAddress(LDAPSearch lDAPSearch, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.setLDAPAddress(lDAPSearch, stringArray[i]);
        }
        return stringArray2;
    }

    public void setFrom(String string) {
        this.from = StringUtil.nval((String)this.getRequestParameter(string), (String)this.from);
    }

    public void setTo(String string) {
        this.to = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setCc(String string) {
        this.cc = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setBcc(String string) {
        this.bcc = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setReplyTo(String string) {
        this.replyTo = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setHost(String string) {
        this.host = StringUtil.nval((String)this.getRequestParameter(string), (String)this.host);
    }

    public void setSubject(String string) {
        this.subject = this.getRequestParameter(string);
    }

    public void setFilename(String string) {
        this.filename = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setCharset(String string) {
        this.charset = StringUtil.nval((String)this.getRequestParameter(string), (String)this.charset);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setUseLDAP(String string) {
        this.useLDAP = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLDAP);
    }

    public void setLdapKey(String string) {
        this.ldapKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.ldapKey);
    }

    public void setLdapVals(String string) {
        this.ldapVals = StringUtil.nval((String)this.getRequestParameter(string), (String)this.ldapVals);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("host", (Object)this.host).println("charset", (Object)this.charset).println("from", (Object)this.from).println("to", (Object[])this.to).println("cc", (Object[])this.cc).println("bcc", (Object[])this.bcc).println("replyTo", (Object[])this.replyTo).println("subject", (Object)this.subject).println("filename", (Object[])this.filename).println("fileURL", (Object)this.fileURL).println("useLDAP", (Object)this.useLDAP).println("ldapKey", (Object)this.ldapKey).println("ldapVals", (Object)this.ldapVals).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

