/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.Map;

import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGElement;

/**
 * query.jspの&lttr&gt&ltog:column&gtタグを作成します。
 *
 * ●使用例
 *		 JspConvertEntity e = new JspConvertEntity();
 * 		e.setTableName("GF92");
 * 		e.setColumnName("CLM");
 * 		List< JspConvertEntity> a = new List< JspConvertEntity>();
 * 		a.add( e );
 * 		HashMap< String , List< JspConvertEntity> > m = new HashMap< String , List<JspConvertEntity> >();
 * 		m.put( "ORDER", a );
 * 		JspTakeout_COLUMN j = new JspTakeout_COLUMN( m );
 * 		j.execute("&lt;og:column /&gt");
 *
 * @og.rev 5.6.1.2 (2013/02/22) 文字列連結から、XML処理するように変更します。
 *
 * @version  5.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK7.0,
 */
public class JspCreate_COLUMN extends AbstractJspCreate {
	public static final int TD_COUNT = 3 ;		// tdタグを繰り返す数

	private List<JspConvertEntity> QUERY_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 *
	 * 内部で使用する JspConvertEntity の リスト のマップを受け取り、初期化を行います。
	 *
	 * @param	master	JspConvertEntityのリストのマップ
	 */
	@Override
	protected void init( final Map<String,List<JspConvertEntity>> master ) {
		QUERY_ROWS = master.get("QUERY");
		IS_NULL = ! isNotEmpty( QUERY_ROWS );
		KEY  = "table";
		NAME = "query";
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) メソッドの引数を、OGAttributes から OGElement に変更します。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、引数を使用するように変更します。
	 * @og.rev 5.6.1.2 (2013/02/22) XML処理するように変更します。
	 *
	 * @param ele OGElementエレメントオブジェクト
	 * @param	nameSpace	このドキュメントのnameSpace( og とか mis とか )
	 *
	 * @return	変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
		if( IS_NULL ) { return ""; }

		// この OGElement の階層の深さを探ります。
		// newEle.getText( para ) とすることでXML全体を階層表示できる。
	//	int para = ele.getParentCount();

		// 既存の設定値をすべて削除します。ホントは自動登録した分だけを削除すべき。
		OGElement newEle  = new OGElement( "table" );
		newEle.addAttr( "summary","layout" );

		OGElement tr = null;
		for( int i=0; i<QUERY_ROWS.size(); i++ ) {
			JspConvertEntity column = QUERY_ROWS.get(i);
			if( i%TD_COUNT == 0 ) {
				tr = new OGElement( "tr" );
				newEle.addNode( tr );
			}
			OGElement clm  = new OGElement( "column" );
			clm.addAttr( "name",column.getColumnName() );

			if ( column.getDefaultValue() != null && column.getDefaultValue().trim().length() > 0) {
				clm.addAttr( "defaultVal",column.getDefaultValue() );
			}
			if ( "1".equals( column.getMust() )){
				clm.addAttr( "must","true" );
			}
			String ope = column.getRemarks();
			if( ope != null && ope.startsWith( "lk" ) ) {
				clm.addAttr( "clazz","aimai" );
			}

			tr.addNode( clm );
		}

		return newEle.getText( 0 );
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) メソッドの引数を、OGAttributes から OGElement に変更します。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、引数を使用するように変更します。
	 * @og.rev 5.6.1.2 (2013/02/22) XML処理するように変更します。
	 *
	 * @param ele OGElementエレメントオブジェクト
	 * @param	nameSpace	このドキュメントのnameSpace( og とか mis とか )
	 *
	 * @return	変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
//	@Override
//	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
//		if( IS_NULL ) { return ""; }
//
//		String ns = (nameSpace.length() == 0) ? "" : nameSpace + ":" ;	// 5.2.1.0 (2010/10/01) 名前空間
//
//		// TODO Auto-generated method stub
//		//書き出す文字列を作成開始。
//		StringBuilder sbTub = new StringBuilder();
//
//		sbTub.append( "<table summary=\"layout\">" ).append( CR );
//		for( int i=0; i<QUERY_ROWS.size(); i++ ) {
//			JspConvertEntity column = QUERY_ROWS.get(i);
//			if( i%TD_COUNT == 0 ) {
//				if( i>0 ) { sbTub.append( "  </tr>" ).append( CR ); }
//				sbTub.append( "  <tr>" ).append( CR );
//			}
//			sbTub.append( "\t<" ).append( ns ).append( "column name=\"" );
//
//			sbTub.append( column.getColumnName() );
//			sbTub.append( "\"" );
//			if ( column.getDefaultValue() != null && column.getDefaultValue().trim().length() > 0) {
//				sbTub.append( " defaultVal=\"");
//				sbTub.append( column.getDefaultValue() );
//				sbTub.append( "\" ");
//			}
//			if ( "1".equals( column.getMust() )){
//				sbTub.append( " must=\"true\" ");
//			}
//			String ope = column.getRemarks();
//			if( ope != null && ope.startsWith( "lk" ) ) { sbTub.append( " clazz=\"aimai\" "); }
//
//			sbTub.append( " />" ).append( CR );
//		}
//		sbTub.append( "  </tr>" ).append( CR );
//		sbTub.append( "</table>" ).append( CR );
//
//		return sbTub.toString();
//	}
}
