/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * PN2 レンデラーは、カラムのデータを品番情報(１１桁の文字列を３-５-３)に対して、
 * それぞれ、"PN_1","PN_2","PN_3"というクラスを付加します。
 * これにより、真ん中の部分だけの色を変えたりすることができます。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.group データ表示
 *
 * @version  5.0
 * @author	 Hiroki Nakamura
 * @since    JDK5.0,
 */
public class Renderer_PN2 extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	private static final CellRenderer dbCell = new Renderer_PN2() ;

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return dbCell;
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param	value 入力値
	 *
	 * @return	データの表示用文字列
	 */
	@Override
	public String getValue( final String value ) {
		String rtn = value;
		if( value != null && value.length() >= 10 ) {
			StringBuilder buf = new StringBuilder( HybsSystem.BUFFER_SMALL );
			buf.append( "<span class=\"PN_1\">" ).append( value.substring( 0, 3 ) ).append( "</span>" );
			buf.append( "<span class=\"PN_2\">" ).append( value.substring( 3, 8 ) ).append( "</span>" );
			buf.append( "<span class=\"PN_3\">" ).append( value.substring( 8 ) ).append( "</span>" );
			rtn = buf.toString();
		}
		return rtn;
	}
}
