<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useGantt2="true" addEvent="adjustGant" />	<!-- ガント処理 -->

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "エンジンサンプル"
	pgid	= "GF7216"
	title	= "特殊ガント"
	date	= "2012/08/17"
	author	= "S.Li"
	text	= "システム、プログラムＩＤ、処理名、作成日、作成者を修正して下さい。"
	version	= "001">
	adjustGantTable.jsを利用したガント表示です。
	ガントの表示処理をクライアント側で行います。
</og:comment>

<!--製番未入力の場合 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT	 PN
			,NOORDER
			,SUORDER
			,DYORDER
			,DYNOKI
			,rownum COLOR
	FROM GF45
	<og:where>
		<og:and value="NOORDER = '{@NOORDER}'" />
	</og:where>
	order by DYORDER,DYNOKI,NOORDER
</og:query>

<og:view
	viewFormType = "HTMLCustomTable"
	command		 = "{@command}"
	writable	 = "false"
	useScrollBar = "false"
>
<og:thead rowspan="2">
	<tr>
		<td>[NOORDER]</td>
		<td>[SUORDER]</td>
		<td>[DYORDER]</td>
		<td rowspan="2" class="gantt zoom{@VZOOM}" style="line-height:normal;text-align:left;background-image: url('../image/ganttBG{@VZOOM}.gif');" >
			<div style="position:relative;left:0px;z-index:101; " height="100%" width="100%" >
				<og:ganttHeader
					startDate		= "{@startDate}"
					endDate			= "{@endDate}"
					zoom			= "{@VZOOM}"
					daySpan 		= "{@daySpan}"
					calDB			= "GE13"
					arg1			= "A"
					breakTimes		= "{@breakTimes}"
					breakTimeStyle	= "top:30px;background-color:gray;"
					baseTimes		= "{@baseTimes}"
					baseTimeStyle	= "top:30px;background-color:transparent;border-left:2px dashed red;"
					skipHoliday		= "{@skipHoliday}"
					useMultiClm		= "{@useMultiClm}"
				/>
			</div>
		</td>
	</tr>
	<tr>
		<td colspan="2">[PN]</td>
		<td>[DYNOKI]</td>
	</tr>
</og:thead>
<og:tbody rowspan="2">
	<tr>
		<td>[NOORDER]</td>
		<td>[SUORDER]</td>
		<td>[DYORDER]</td>
		<td rowspan="2" class="gantt zoom{@VZOOM}" style="text-align:left;background-image: url('../image/ganttBG{@VZOOM}.gif');" >
			<iGantBar type="1" colorNo="[COLOR]" start="[DYORDER]" end="[DYNOKI]"	msg="[PN]" ><!-- --></iGantBar>
			<iGantBar type="0" src="../image/dia_blue.gif" start="[DYORDER]"	msg="開始" ><!-- --></iGantBar>
			<iGantBar type="0" src="../image/dia_red.gif"  end="[DYNOKI]"		msg="終了" ><!-- --></iGantBar>
		</td>
	</tr>
	<tr>
		<td colspan="2">[PN]</td>
		<td>[DYNOKI]</td>
	</tr>
</og:tbody>
</og:view>

<og:text>
	<iGant 
		margeRows	= "{@MARGEROWS}"
		fixedCols	= "6"
	><!-- --></iGant>
</og:text>
<!-- ガント描画の利用方法 
	【属性説明】
		type		: ガント要素のタイプ（0:マイルストーン 1:バー ）
		color		: バーの色（マイルストーンの場合は不要）
		src			: マイルストーンのアイコン画像(URIより設定)
		start	 	: 開始日(YYYYMMDD)、または開始時間(YYYYMMDDHH24MM)
		end			: 終了日(YYYYMMDD)、または終了時間(YYYYMMDDHH24MM)（マイルストーンの場合は不要）
		msg			: ガント要素の注釈メッセージ
	【使用例１：バー】
		<iGantBar 
			type		= "1" 
			color		= "[COLOR]" 
			start		= "[DYORDER]" 
			end			= "[DYNOKI]" 
			msg			= "[PN]" 
		/>
	【使用例２：バー】
		<iGantBar 
			type		= "0" 
			src			= "../image/dia_red.gif"
			start		= "[DYORDER]" 
			msg			= "[PN]" 
		/>
-->
<!--ガント全体の属性設定（必須）
	【属性説明】
		margeRows		: 複数行のマージ、前後の行データが一致している場合はマージする。
		fixedCols		: 左の固定列の列数（テーブル２分割機能）
		viewNumberType 	: viewタグの出力に番号列が出力されるか(出力されていない場合:delete)
	【使用例】
		<iGant 
			margeRows	= "{@MARGEROWS}"
			fixedCols	= "6"
		/>
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
