<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useGantt2="true" addEvent="adjustTable" />	<!-- 左右分割 -->

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "エンジンサンプル"
	pgid	= "GF7215"
	title	= "左右分割(特殊)"
	date	= "2012/08/17"
	author	= "S.Li"
	text	= "システム、プログラムＩＤ、処理名、作成日、作成者を修正して下さい。"
	version	= "001">
	adjustGantTable.jsの機能を利用してテーブルの左右分割スクロールを行います。
	通常の左右分割は２つのテーブルを左右に並べるため、セルの高さが異なってずれる場合が
	ありました（但し調整するロジックは入っています）が、こちらの方法は１つのテーブルを
	利用するため、ずれが抑えられます。
	リサイズされない等の副作用があるため、特別な理由が無い限りは通常の左右分割方式を利用して下さい。
</og:comment>


<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT	A.NOORDER
			,A.KNORDER
			,A.KNJISK
			,A.KNMIKM
			,A.SUORDER
			,A.PN
			,A.PHOTO
			,A.SINTYOKU
			,A.NMCUST
	FROM GF45 A
	<og:where>
		<og:and value="NOORDER = '{@NOORDER}'" />
	</og:where>
	<og:appear startKey="ORDER BY" value="{@ORDER_BY}" defaultVal="PN" />
</og:query>

<og:view
	viewFormType = "HTMLTable"
	command		 = "{@command}"
/>

<!--
 iTableタグはadjustGantTable.js内での識別用タグです。
 fixedColsの数字が左側に固定するカラムの数となります。
 addEvent( this, "load", adjustTable );
 で、ページロード時にadjustTable()関数を実行する必要があります。
 又、通常のヘッダ固定と異なりサイズ変更でのリサイズは行われません。
-->
<iTable fixedCols="5" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
