<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2080"
	title	= "オブジェクト一覧"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "NEW"
/>

<!-- トランザクション 登録処理 -->
<og:transaction >
	<!-- 対象のオブジェクト一覧を削除します。 -->
	<og:query command="NEW" maxRowCount="0">
			DELETE FROM GF82
			WHERE SYSTEM_ID = '{@MEM.SYSTEM_ID}'
			AND   TBLSYU    = '{@TBLSYU}'
		<og:where startKey="and">
			<og:and value = "OBJ_NAME	like '{@OBJ_NAME}%'"	/>
			<og:and value = "OBJ_TYPE	= '{@OBJ_TYPE2}'" />
		</og:where>
	</og:query>

	<!-- オブジェクト一覧を検索します。 -->
	<jsp:directive.include file="sqlGF82.jsp" />

	<!-- NAME_JA にリソースを適用します。 -->
	<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="SYSTEM_ID,OBJ_NAME,NAME_JA" />

	<!-- オブジェクト一覧を登録します。 -->
	<og:tableUpdate command="ENTRY" sqlType="INSERT" queryType="JDBCTableUpdate" debug="false" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF82"
		/>
	</og:tableUpdate>

<!-- =============================================================================== -->

	<!-- 対象のオブジェクト明細を削除します。 -->
	<og:query command="NEW" maxRowCount="0">
			DELETE FROM GF83
			WHERE SYSTEM_ID = '{@MEM.SYSTEM_ID}'
			AND   TBLSYU    = '{@TBLSYU}'
		<og:where startKey="and">
			<og:and value = "OBJ_NAME	like '{@OBJ_NAME}%'"	/>
			<og:and value = "OBJ_TYPE	= '{@OBJ_TYPE2}'" />
		</og:where>
	</og:query>

	<!-- オブジェクト明細を検索します。sqlGF83 は、VIEW 以外のオブジェクトタイプが対象です。 -->
	<jsp:directive.include file="sqlGF83.jsp" />

	<!-- NAME_JA にリソースを適用します。 -->
	<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="SYSTEM_ID,OBJ_NAME,NAME_JA" />

	<!-- オブジェクト明細を登録します。 -->
	<og:tableUpdate command="ENTRY" sqlType="INSERT" queryType="JDBCTableUpdate" debug="false" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF83"
			omitNames	= "NAME_JA"
		/>
	</og:tableUpdate>

	<!-- オブジェクト明細を検索します。sqlGF83V は、VIEW が対象です。(USER_VIEWS の TEXTカラムは、LONG なので、UNION できない。) -->
	<jsp:directive.include file="sqlGF83V.jsp" />

	<!-- NAME_JA にリソースを適用します。 -->
	<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="SYSTEM_ID,OBJ_NAME,NAME_JA" />

	<!-- オブジェクト明細を登録します。 -->
	<og:tableUpdate command="ENTRY" sqlType="INSERT" queryType="JDBCTableUpdate" debug="false" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF83"
			omitNames	= "NAME_JA"
		/>
	</og:tableUpdate>

<!-- =============================================================================== -->

	<!-- 対象のシーケンスを削除します。 -->
	<og:query command="NEW" maxRowCount="0">
			DELETE FROM GF09
			WHERE SYSTEM_ID = '{@MEM.SYSTEM_ID}'
			AND   TBLSYU    = '{@TBLSYU}'
		<og:where startKey="and">
			<og:and value = "SEQNAME	like '{@OBJ_NAME}%'"	/>
			<og:and value = "'SEQUENCE'	= '{@OBJ_TYPE2}'" />
		</og:where>
	</og:query>

	<!-- シーケンスを検索します。 -->
	<jsp:directive.include file="sqlGF09.jsp" />

	<!-- シーケンスを登録します。 -->
	<og:tableUpdate command="ENTRY" sqlType="INSERT" queryType="JDBCTableUpdate" debug="false" selectedAll="true">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF09"
		/>
	</og:tableUpdate>
</og:transaction >

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
