/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.EDbid;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.xml.DomParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseConfig {
    private static final String DEFAULT_DRIVER = "oracle.jdbc.OracleDriver";
    private final String XmlFilename;
    private Map<String, EDbid> dbidMap = new HashMap<String, EDbid>();
    private List<String> driverList = new ArrayList<String>();
    private static final String[] DBID_INFO_KEYS = new String[]{"dbidKey", "url", "user", "password", "readonly", "mincount", "maxcount", "pooltime", "applicationInfo", "property"};
    private static final String DBDRIVER_CLASS_KEY = "class";

    public DatabaseConfig() {
        this("../DBConfig.xml");
    }

    public DatabaseConfig(String string) {
        String string2 = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL != null) {
            string2 = uRL.getFile();
        }
        if (string2 == null && new File(string).exists()) {
            string2 = string;
        }
        if (string2 == null) {
            String string3 = "DBConfig.xml\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002File=[" + string + "]" + " WEB-INF/classes \u30d5\u30a9\u30eb\u30c0\u304c\u306a\u3044\u3068\u3001\u76f8\u5bfe\u30d1\u30b9\u3067\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string3);
        }
        this.XmlFilename = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EDbid getDbid(String string) {
        Map<String, EDbid> map = this.dbidMap;
        synchronized (map) {
            if (this.dbidMap.isEmpty()) {
                this.init();
            }
            return this.dbidMap.get(string.toUpperCase(Locale.JAPAN));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.dbidMap;
        synchronized (object) {
            this.dbidMap.clear();
        }
        object = this.driverList;
        synchronized (object) {
            this.driverList.clear();
        }
    }

    private void init() {
        Document document = DomParser.read(new File(this.XmlFilename));
        Element element = document.getDocumentElement();
        this.driverList = DatabaseConfig.getDriverList(element);
        for (String string : this.driverList) {
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = "\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + string + "]";
                LogWriter.log(string2);
                LogWriter.log(classNotFoundException);
            }
        }
        EDbid eDbid = new EDbid();
        eDbid.setUrl(System.getenv("REALM_URL"));
        eDbid.setUser(System.getenv("REALM_NAME"));
        eDbid.setPassword(System.getenv("REALM_PASSWORD"));
        this.dbidMap = DatabaseConfig.getDbidMap(element, eDbid);
    }

    private static List<String> getDriverList(Element element) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getElementsByTagName(DBDRIVER_CLASS_KEY);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(element2.getTextContent());
        }
        if (arrayList.isEmpty() && (string = System.getenv("REALM_DRIVER")) != null && string.length() > 0) {
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(DEFAULT_DRIVER);
        }
        return arrayList;
    }

    private static Map<String, EDbid> getDbidMap(Element element, EDbid eDbid) {
        HashMap<String, EDbid> hashMap = new HashMap<String, EDbid>();
        NodeList nodeList = element.getElementsByTagName("dbid");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getChildNodes();
            int n2 = nodeList2.getLength();
            EDbid eDbid2 = eDbid.clone();
            for (int j = 0; j < n2; ++j) {
                Node node = nodeList2.item(j);
                if (node.getNodeType() != 1) continue;
                Element element3 = (Element)node;
                String string = element3.getTagName();
                if ("dbidKey".equals(string)) {
                    String string2 = element3.getTextContent();
                    if (string2 == null || string2.length() <= 0) continue;
                    eDbid2.setDbidKey(string2.toUpperCase(Locale.JAPAN));
                    continue;
                }
                if ("url".equals(string)) {
                    eDbid2.setUrl(element3.getTextContent());
                    continue;
                }
                if ("user".equals(string)) {
                    eDbid2.setUser(element3.getTextContent());
                    continue;
                }
                if ("password".equals(string)) {
                    eDbid2.setPassword(element3.getTextContent());
                    continue;
                }
                if ("readonly".equals(string)) {
                    eDbid2.setReadonly(element3.getTextContent());
                    continue;
                }
                if ("mincount".equals(string)) {
                    eDbid2.setMincount(element3.getTextContent());
                    continue;
                }
                if ("maxcount".equals(string)) {
                    eDbid2.setMaxcount(element3.getTextContent());
                    continue;
                }
                if ("pooltime".equals(string)) {
                    eDbid2.setPooltime(element3.getTextContent());
                    continue;
                }
                if ("applicationInfo".equals(string)) {
                    eDbid2.setApplicationInfo(element3.getTextContent());
                    continue;
                }
                if ("property".equals(string)) {
                    eDbid2.addProp(element3.getTextContent());
                    continue;
                }
                System.err.println("\u8b66\u544a\uff1adbid \u306b\u65b0\u3057\u3044\u5c5e\u6027\u304c\u3001\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
            hashMap.put(eDbid2.getDbidKey(), eDbid2);
        }
        return hashMap;
    }

    public static String[] getDbidInfoKeys() {
        return (String[])DBID_INFO_KEYS.clone();
    }

    public String[][] getDbidInfo() {
        Element element = DomParser.read(new File(this.XmlFilename)).getDocumentElement();
        Map<String, EDbid> map = DatabaseConfig.getDbidMap(element, new EDbid());
        String[][] stringArray = new String[map.size()][DBID_INFO_KEYS.length];
        int n = 0;
        for (EDbid eDbid : map.values()) {
            stringArray[n][0] = eDbid.getDbidKey();
            stringArray[n][1] = eDbid.getUrl();
            stringArray[n][2] = eDbid.getUser();
            stringArray[n][3] = eDbid.getPassword();
            stringArray[n][4] = String.valueOf(eDbid.isReadonly());
            stringArray[n][5] = String.valueOf(eDbid.getMincount());
            stringArray[n][6] = String.valueOf(eDbid.getMaxcount());
            stringArray[n][7] = String.valueOf(eDbid.getPooltime());
            stringArray[n][8] = String.valueOf(eDbid.isApplicationInfo());
            stringArray[n][8] = String.valueOf(eDbid.getProps().toString());
            ++n;
        }
        DatabaseConfig.dbidSort(stringArray);
        return stringArray;
    }

    public void setDbidInfo(String[][] stringArray) {
        FileUtil.copy(this.XmlFilename, this.XmlFilename + "_" + System.currentTimeMillis());
        Document document = DomParser.read(new File(this.XmlFilename));
        Element element = document.getDocumentElement();
        DatabaseConfig.deleteChildElements(element, "dbid");
        if (stringArray != null && stringArray.length > 0) {
            DatabaseConfig.dbidSort(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = document.createElement("dbid");
                for (int j = 0; j < stringArray[i].length; ++j) {
                    Element element3 = document.createElement(DBID_INFO_KEYS[j]);
                    element3.setTextContent(stringArray[i][j]);
                    element2.appendChild(element3);
                }
                element.appendChild(element2);
                element.appendChild(document.createTextNode("\n\n"));
            }
        }
        DomParser.write(new File(this.XmlFilename), document);
    }

    private static void dbidSort(String[][] stringArray) {
        Arrays.sort(stringArray, new Comparator<String[]>(){

            @Override
            public int compare(String[] stringArray, String[] stringArray2) {
                if ("DEFAULT".equals(stringArray[0])) {
                    return -1;
                }
                if ("DEFAULT".equals(stringArray2[0])) {
                    return 1;
                }
                return stringArray[0].compareTo(stringArray2[0]);
            }
        });
    }

    public static String getDriverKey() {
        return DBDRIVER_CLASS_KEY;
    }

    public String[] getDriverList() {
        Element element = DomParser.read(new File(this.XmlFilename)).getDocumentElement();
        String[] stringArray = DatabaseConfig.getDriverList(element).toArray(new String[0]);
        DatabaseConfig.driverSort(stringArray);
        return stringArray;
    }

    public void setDriverList(String[] stringArray) {
        FileUtil.copy(this.XmlFilename, this.XmlFilename + "_" + System.currentTimeMillis());
        Document document = DomParser.read(new File(this.XmlFilename));
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagName("dbDriver").item(0);
        DatabaseConfig.deleteChildElements(element2, DBDRIVER_CLASS_KEY);
        if (stringArray != null && stringArray.length > 0) {
            DatabaseConfig.driverSort(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3 = document.createElement(DBDRIVER_CLASS_KEY);
                element3.setTextContent(stringArray[i]);
                element2.appendChild(element3);
            }
        }
        DomParser.write(new File(this.XmlFilename), document);
    }

    private static void driverSort(String[] stringArray) {
        Arrays.sort(stringArray, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (DatabaseConfig.DEFAULT_DRIVER.equals(string)) {
                    return -1;
                }
                if (DatabaseConfig.DEFAULT_DRIVER.equals(string2)) {
                    return 1;
                }
                return string.compareTo(string2);
            }
        });
    }

    private static void deleteChildElements(Element element, String string) {
        Node node = element.getFirstChild();
        boolean bl = false;
        while (node != null) {
            if (node.getNodeType() == 1) {
                bl = ((Element)node).getTagName().equals(string);
            }
            Node node2 = node.getNextSibling();
            if (bl) {
                element.removeChild(node);
            }
            node = node2;
        }
    }
}

