/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.opengion.fukurou.util.Closer;

public class HybsTimeSeriesCollection
extends TimeSeriesCollection {
    private static final long serialVersionUID = 5604L;
    private final boolean vhFlag;
    private final boolean isStacked;

    public HybsTimeSeriesCollection(String string) {
        this.vhFlag = string.endsWith("V");
        this.isStacked = string.startsWith("Stacked");
    }

    public void executeQuery(Connection connection, String string) throws SQLException {
        if (this.vhFlag) {
            this.innerQueryV(connection, string);
        } else {
            this.innerQueryH(connection, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerQueryV(Connection connection, String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n < 3) {
                String string2 = "HybsTimeSeriesCollection.innerQueryV() : \u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\nselect series,x(\u6642\u9593),y(\u5024) \u306f\u3001\u6700\u4f4e\u5fc5\u8981\u3067\u3059\u3002\u305d\u308c\u4ee5\u964d\u306f\u7121\u8996\u3057\u307e\u3059\u3002 SQL=" + string;
                throw new SQLException(string2);
            }
            String string3 = null;
            double d = 0.0;
            TimeSeries timeSeries = null;
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                if (string4 != null && !string4.equals(string3)) {
                    if (timeSeries != null) {
                        this.addSeries(timeSeries);
                    }
                    timeSeries = new TimeSeries((Comparable)((Object)string4));
                    string3 = string4;
                    d = 0.0;
                }
                String string5 = resultSet.getString(2);
                RegularTimePeriod regularTimePeriod = this.getTimePeriod(string5);
                double d2 = resultSet.getDouble(3);
                d = this.isStacked ? d + d2 : d2;
                timeSeries.add(regularTimePeriod, d);
            }
            if (timeSeries != null) {
                this.addSeries(timeSeries);
            }
        }
        catch (Throwable throwable) {
            Closer.resultClose(resultSet);
            Closer.stmtClose((Statement)statement);
            throw throwable;
        }
        Closer.resultClose((ResultSet)resultSet);
        Closer.stmtClose((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerQueryH(Connection connection, String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            if (n2 < 2) {
                String string2 = "HybsTimeSeriesCollection.innerQueryH() : \u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\nselect x(\u6642\u9593),y1(\u5024),y2(\u5024) , \u30fb\u30fb\u30fb\u30fb \u306f\u3001\u6700\u4f4e\u5fc5\u8981\u3067\u3059\u3002 SQL=" + string;
                throw new SQLException(string2);
            }
            int n3 = n2 - 1;
            TimeSeries[] timeSeriesArray = new TimeSeries[n3];
            double[] dArray = new double[n3];
            for (n = 0; n < n3; ++n) {
                timeSeriesArray[n] = new TimeSeries((Comparable)((Object)resultSetMetaData.getColumnLabel(n + 2)));
                dArray[n] = 0.0;
            }
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                RegularTimePeriod regularTimePeriod = this.getTimePeriod(string3);
                for (int i = 0; i < n3; ++i) {
                    double d = resultSet.getDouble(i + 2);
                    dArray[i] = this.isStacked ? dArray[i] + d : d;
                    timeSeriesArray[i].add(regularTimePeriod, dArray[i]);
                }
            }
            for (n = 0; n < n3; ++n) {
                this.addSeries(timeSeriesArray[n]);
            }
        }
        catch (Throwable throwable) {
            Closer.resultClose(resultSet);
            Closer.stmtClose((Statement)statement);
            throw throwable;
        }
        Closer.resultClose((ResultSet)resultSet);
        Closer.stmtClose((Statement)statement);
    }

    private RegularTimePeriod getTimePeriod(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 1;
        int n6 = 2010;
        if (string != null) {
            if (string.length() >= 8) {
                n6 = Integer.parseInt(string.substring(0, 4));
                n5 = Integer.parseInt(string.substring(4, 6));
                n4 = Integer.parseInt(string.substring(6, 8));
            }
            if (string.length() >= 14) {
                n3 = Integer.parseInt(string.substring(8, 10));
                n2 = Integer.parseInt(string.substring(10, 12));
                n = Integer.parseInt(string.substring(12, 14));
            }
        }
        return new Second(n, n2, n3, n4, n5, n6);
    }
}

