<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP08"
	title    = "帳票デーモン"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
	SELECT GE53.SYSTEM_ID || '_' || GE53.DMN_GRP AS TASKNAME,
			'SET' AS CMD_SET,'REMOVE' AS CMD_REMOVE,GE53.SYSTEM_ID,
			GE53.DMN_GRP,'' PRTID,'' PRT_GRP,'' MODBASE,'' MODNO,
			MIN(GE53.DMN_TIME) AS DMN_TIME,COUNT(*) AS COUNT
			,GE12.CONTXT_PATH
	FROM GE53  LEFT OUTER JOIN GE12
			ON  GE12.PARAM_ID = ('CONTEXT_INITIAL_CALL_URL_' || GE53.SYSTEM_ID || '_' || GE53.DMN_GRP )
				AND GE12.FGJ = '1'
	WHERE GE53.FGJ = '1'
	AND   GE53.DMN_GRP != 'PDF'
	GROUP BY GE53.SYSTEM_ID,GE53.DMN_GRP,GE12.CONTXT_PATH
	UNION
	SELECT GE55.PRTID AS TASKNAME,
			'SET' AS CMD_SET,'REMOVE' AS CMD_REMOVE,'' AS SYSTEM_ID,
			DMN_GRP,GE55.PRTID,GE53.PRTID,
			TO_CHAR(MOD_TBL.CNT) as MODBASE,
			TO_CHAR(MOD(ROWNUM,MOD_TBL.CNT)) MODNO,
			DMN_TIME,1 AS COUNT
			,'' AS CONTXT_PATH
	FROM GE53 , GE55 , 
			(select SYSTEM_ID,PRT_GRP,count(*) as CNT from GE55
			 where  FGJ  = '1'
			 group by SYSTEM_ID,PRT_GRP
			) MOD_TBL
	WHERE GE53.FGJ = '1'
	AND   GE55.FGJ = '1'
	AND   DMN_GRP = 'PDF'
	AND   GE53.SYSTEM_ID  = GE55.SYSTEM_ID
	AND   GE53.PRTID      = GE55.PRT_GRP
	AND   MOD_TBL.PRT_GRP = GE55.PRT_GRP
	AND   MOD_TBL.SYSTEM_ID = GE55.SYSTEM_ID
	ORDER BY DMN_GRP,PRTID
	</jsp:text>
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="NEW">
	<og:link column="CMD_SET" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,DMN_GRP,CMD,NAME_JA,PERIOD,PRTID,PRT_GRP,MODBASE,MODNO"
		vals="NEW,[SYSTEM_ID],[DMN_GRP],SET,[TASKNAME],[DMN_TIME],[PRTID],[PRT_GRP],[MODBASE],[MODNO]" lbl="ENTRY" />
	<og:link column="CMD_REMOVE" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,DMN_GRP,CMD,NAME_JA,AUTORUN"
		vals="NEW,[SYSTEM_ID],[DMN_GRP],REMOVE,[TASKNAME],[CONTXT_PATH]" lbl="DELETE" />
</og:viewLink>

<div>
<og:message lbl="MSG0078"/>
</div>

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "NEW"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	writable   = "false"
	useScrollBar = "false"
	rowspan    = "1" >
	<og:thead rowspan="1" >
		<tr>
			<td>TaskName</td><td colspan="2">Deamon</td><td>System ID</td><td>AutoRun</td>
			<td>Print ID</td><td>Daemon Group</td><td>Daemon Time</td><td>Group Count</td><td>MODBASE</td><td>MODNO</td>
		</tr>
	</og:thead>

	<og:tbody rowspan="1">
		<tr>
			<td>[TASKNAME]</td><td>[CMD_SET]</td><td>[CMD_REMOVE]</td><td>[SYSTEM_ID]</td><td>[CONTXT_PATH]</td>
			<td>[PRTID]</td><td>[DMN_GRP]</td><td>[DMN_TIME]</td><td>[COUNT]</td><td>[MODBASE]</td><td>[MODNO]</td>
		</tr>
	</og:tbody>
</og:view>
<br />
<og:link href="result.jsp" target="RESULT" keys="CMD" vals="VIEW" >
[<og:message lbl="QUERY" />]
</og:link>
<og:img src="{@SYS.JSP}/image/ecblank.gif" alt=" " width="10px" height="10px"  />
<og:link href="result.jsp" target="RESULT" keys="CMD" vals="CANCEL" >
[ALL <og:message lbl="RESET" />]
</og:link>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
