/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.FirstProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.SystemParameter;

public class Process_BulkQuery
extends AbstractProcess
implements FirstProcess,
ChainProcess {
    private static final int MAX_BULK_SET = 500;
    private static final String ACT_QUERY = "query";
    private static final String ACT_BULKSET = "bulkSet";
    private static final String ACT_MINUS = "minus";
    private static final String ACT_INTERSECT = "intersect";
    private static final String[] ACTION_LST = new String[]{"query", "bulkSet", "minus", "intersect"};
    private String actionCmd = null;
    private String dbid = null;
    private String bulkKey = null;
    private boolean bulkType = true;
    private int sqlCount = 0;
    private int setCount = 0;
    private int outCount = 0;
    private int fetchSize = 100;
    private boolean display = false;
    private boolean debug = false;
    private boolean firstTime = true;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty;

    public Process_BulkQuery() {
        super("org.opengion.fukurou.process.Process_BulkQuery", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.actionCmd = argument.getProparty("action", null, ACTION_LST);
        this.fetchSize = argument.getProparty("fetchSize", this.fetchSize);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        this.dbid = argument.getProparty("dbid");
        String string = argument.getFileProparty("sql", "sqlFile", true);
        if (this.debug) {
            this.println("\u5165\u529bSQL:" + string);
        }
        HybsEntry[] hybsEntryArray = argument.getEntrys("sql_");
        SystemParameter systemParameter = new SystemParameter(string);
        string = systemParameter.replace(hybsEntryArray);
        if (this.debug) {
            this.println("\u5909\u63dbSQL:" + string);
        }
        if (ACT_BULKSET.equalsIgnoreCase(this.actionCmd)) {
            this.bulkKey = argument.getProparty("bulkKey");
            String string2 = argument.getProparty("bulkType");
            if (string2 != null) {
                this.bulkType = string2.equalsIgnoreCase("STR");
            }
            Set<String> set = paramProcess.getBulkData();
            if (this.debug) {
                this.println(set.toString());
            }
            this.setCount = set.size();
            if (this.setCount > 0) {
                String[] stringArray = this.makeBulkQuery(string, this.bulkKey, this.bulkType, set);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.debug) {
                        this.println("BulkSQL:" + stringArray[i]);
                    }
                    this.createSetData(paramProcess, this.dbid, stringArray[i]);
                }
            }
        } else if (ACT_QUERY.equalsIgnoreCase(this.actionCmd)) {
            Set<String> set = this.createSetData(paramProcess, this.dbid, string);
            if (this.debug) {
                this.println(set.toString());
            }
            this.outCount = this.setCount = set.size();
            paramProcess.setBulkData(set);
        } else {
            Set<String> set = paramProcess.getBulkData();
            Set<String> set2 = this.createSetData(paramProcess, this.dbid, string);
            this.setCount = set2.size();
            if (ACT_MINUS.equalsIgnoreCase(this.actionCmd)) {
                set.removeAll(set2);
            } else if (ACT_INTERSECT.equalsIgnoreCase(this.actionCmd)) {
                set.retainAll(set2);
            }
            this.outCount = set.size();
            if (this.debug) {
                this.println(set.toString());
            }
            paramProcess.setBulkData(set);
        }
    }

    @Override
    public void end(boolean bl) {
    }

    @Override
    public boolean next() {
        return this.firstTime;
    }

    @Override
    public LineModel action(LineModel lineModel) {
        return lineModel;
    }

    @Override
    public LineModel makeLineModel(int n) {
        this.firstTime = false;
        LineModel lineModel = new LineModel();
        lineModel.setRowNo(n);
        return lineModel;
    }

    private Set<String> createSetData(ParamProcess paramProcess, String string, String string2) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        HashSet<String> hashSet;
        block8: {
            hashSet = new HashSet<String>();
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = paramProcess.getConnection(string);
                statement = connection.createStatement();
                if (this.fetchSize > 0) {
                    statement.setFetchSize(this.fetchSize);
                }
                if (statement.execute(string2)) {
                    resultSet = statement.getResultSet();
                    while (resultSet.next()) {
                        ++this.sqlCount;
                        String string3 = resultSet.getString(1);
                        if (this.display) {
                            this.println(string3);
                        }
                        hashSet.add(string3);
                    }
                    break block8;
                }
                this.sqlCount += statement.getUpdateCount();
            }
            catch (SQLException sQLException) {
                try {
                    String string4 = "SQL \u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "DBID=" + string + CR + "SQL =" + string2;
                    throw new RuntimeException(string4, sQLException);
                }
                catch (Throwable throwable) {
                    Closer.resultClose(resultSet);
                    Closer.stmtClose(statement);
                    ConnectionFactory.remove(connection, string);
                    throw throwable;
                }
            }
        }
        Closer.resultClose(resultSet);
        Closer.stmtClose(statement);
        ConnectionFactory.remove(connection, string);
        return hashSet;
    }

    private String[] makeBulkQuery(String string, String string2, boolean bl, Set<String> set) {
        String[] stringArray = new String[set.size() / 500 + 1];
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = null;
        if (bl) {
            for (String string4 : set) {
                stringBuilder.append(",'").append(string4).append("'");
                if (++n2 < 500) continue;
                string3 = stringBuilder.substring(1);
                stringArray[n++] = string.replace("{@" + string2 + "}", string3);
                n2 = 0;
                stringBuilder = new StringBuilder();
            }
            if (n2 > 0) {
                string3 = stringBuilder.substring(1);
                stringArray[n] = string.replace("{@" + string2 + "}", string3);
            }
        } else {
            for (String string5 : set) {
                stringBuilder.append(",").append(string5);
                if (++n2 < 500) continue;
                string3 = stringBuilder.substring(1);
                stringArray[n++] = string.replace("{@" + string2 + "}", string3);
                n2 = 0;
                stringBuilder = new StringBuilder();
            }
            if (n2 > 0) {
                string3 = stringBuilder.substring(1);
                stringArray[n] = string.replace("{@" + string2 + "}", string3);
            }
        }
        return stringArray;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "Action    : " + this.actionCmd + CR + "\t" + "DBID      : " + this.dbid + CR + "\t" + "sqlCount  : " + this.sqlCount + CR + "\t" + "setCount  : " + this.setCount + CR + "\t" + "outCount  : " + this.outCount;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_BulkQuery\u306f\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304b\u3089\u8aad\u307f\u53d6\u3063\u305f\u5185\u5bb9\u3092\u3001\u4e00\u62ec\u51e6\u7406\u3059\u308b\u305f\u3081\u306b\u3001").append(CR);
        stringBuilder.append("ParamProcess \u306e\u30b5\u30d6\u30af\u30e9\u30b9(Process_DBParam)\u306b\u30bb\u30c3\u30c8\u3057\u305f\u308a\u3001\u52a0\u5de5\u3057\u305f\u308a\u3059\u308b").append(CR);
        stringBuilder.append("FirstProcess \u3068\u3001ChainProcess \u306e\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u3092\u4e21\u65b9\u6301\u3063\u305f\u3001\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u3053\u306e\u30af\u30e9\u30b9\u306f\u3001\u4e0a\u6d41\u304b\u3089\u3001\u4e0b\u6d41\u3078\u306e\u51e6\u7406\u306f\u3001\uff11\u5ea6\u3057\u304b\u5b9f\u884c\u3055\u308c\u307e\u305b\u3093\u3002").append(CR);
        stringBuilder.append("FirstProcess \u306e\u691c\u7d22\u7d50\u679c\u306f\u3001Set \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3068\u3057\u3066\u3001Process_DBParam \u306b\u6e21\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("ChainProcess \u306f\u3001\u305d\u306e\u7d50\u679c\u3092\u53d6\u308a\u51fa\u3057\u3001\u81ea\u5206\u81ea\u8eab\u306e\u51e6\u7406\u7d50\u679c\u3068\u5408\u305b\u3066\u52a0\u5de5\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("FirstProcess \u3067\u306f\u3001-action \u306f\u3001query \u306e\u307f\u3067\u3059\u3002").append(CR);
        stringBuilder.append("  query \u306f\u3001\u6307\u5b9a\u306eSQL\u6587\u3092\u5b9f\u884c\u3057\u3001\u7d50\u679c\u306eSet\u3092ParamProcess\u306b\u8a2d\u5b9a\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("ChainProcess \u3067\u306f\u3001-action \u306f\u3001query\u3001bulkSet\u3001minus\u3001intersect \u304c\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002").append(CR);
        stringBuilder.append("  query     \u306f\u3001\u4e0a\u8a18\u3068\u540c\u3058\u3067\u3059\u3002").append(CR);
        stringBuilder.append("  minus     \u306f\u3001\u5148\u306eSet\u304b\u3089\u3001SQL\u6587\u306e\u5b9f\u884c\u7d50\u679c\u3092\u5f15\u304d\u7b97\u3057\u3001\u7d50\u679cSet\u3092\u518d\u8a2d\u5b9a\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("  intersect \u306f\u3001\u5148\u306eSet\u304b\u3089\u3001SQL\u6587\u306e\u5b9f\u884c\u7d50\u679c\u3068\u91cd\u8907\u3059\u308b\u7d50\u679cSet\u3092\u518d\u8a2d\u5b9a\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("  bulkSet   \u306f\u3001\u5148\u306eSet\u3092\u53d6\u308a\u51fa\u3057\u3001SQL\u6587\u306b\u52a0\u5473\u3057\u3066\u51e6\u7406\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u6d41\u308c\u7684\u306b\u306f\u3001query \u3067\u691c\u7d22\u3057\u3001minus\u307e\u305f\u306fintersect \u3067Set\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u52a0\u5de5\u3057\u3001").append(CR);
        stringBuilder.append("bulkSet \u3067\u5229\u7528\u3057\u307e\u3059\u3002\u4f8b\u3048\u3070\u3001ORACLE\u304b\u3089\u3001\u30e6\u30cb\u30fc\u30af\u30ad\u30fc\u306eSet\u3092\u4f5c\u6210\u3057\u3001").append(CR);
        stringBuilder.append("SQLServer\u306e\u30e6\u30cb\u30fc\u30af\u30ad\u30fc\u3092minus\u3057\u305f\u7d50\u679c\u3092\u3001ORACLE\u304b\u3089DELETE\u3059\u308c\u3070\u3001\u4e0d\u8981\u306a").append(CR);
        stringBuilder.append("\u30c7\u30fc\u30bf\u3092\u524a\u9664\u3059\u308b\u306a\u3069\u306e\u51e6\u7406\u304c\u5b9f\u884c\u53ef\u80fd\u306b\u306a\u308a\u307e\u3059\u3002\u307e\u305f\u3001\u5358\u7d14\u306b\u3001query \u3060\u3051\u3092\u3001").append(CR);
        stringBuilder.append("\u30c1\u30a7\u30a4\u30f3\u3059\u308c\u3070\u3001\u5358\u767a\u306eUPDATE\u6587\u3092\u5b9f\u884c\u3059\u308b\u3053\u3068\u304c\u53ef\u80fd\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5148\u7b49\u306f\u3001ParamProcess \u306e\u30b5\u30d6\u30af\u30e9\u30b9(Process_DBParam)\u306b").append(CR);
        stringBuilder.append("\u8a2d\u5b9a\u3055\u308c\u305f\u63a5\u7d9a(Connection)\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("SQL\u6587\u306b\u306f\u3001{@DATE.YMDH}\u7b49\u306e\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_BulkQuery().usage());
    }

    static {
        mustProparty.put("action", "\u5b9f\u884c\u3059\u308b\u51e6\u7406\u65b9\u6cd5\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002(query|minus|intersect)");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("dbid", "Process_DBParam \u306e -configFile \u3067\u6307\u5b9a\u3059\u308b DBConfig.xml \u30d5\u30a1\u30a4\u30eb\u3067\u898f\u5b9a");
        usableProparty.put("sql", "\u691c\u7d22SQL\u6587\uff08sql or sqlFile \u5fc5\u9808\uff09\u4f8b: \"select * from GEA08\"");
        usableProparty.put("sqlFile", "\u691c\u7d22SQL\u30d5\u30a1\u30a4\u30eb\uff08sql or sqlFile \u5fc5\u9808\uff09\u4f8b: select.sql");
        usableProparty.put("sql_", "SQL\u6587\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092\u6307\u5b9a\u306e\u56fa\u5b9a\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID='{&#064;SYSTEM_ID}' \u21d2 WHERE SYSTEM_ID='GE'");
        usableProparty.put("dbid2", "DB\u63a5\u7d9aID2 \u4f8b: Process_DBParam \u306e -configFile \u3067\u6307\u5b9a\u3059\u308b DBConfig.xml \u30d5\u30a1\u30a4\u30eb\u3067\u898f\u5b9a");
        usableProparty.put("sql2", "\u691c\u7d22SQL\u65872\uff08sql or sqlFile \u5fc5\u9808\uff09\u4f8b: \"select * from GEA08\"");
        usableProparty.put("sqlFile2", "\u691c\u7d22SQL\u30d5\u30a1\u30a4\u30eb2\uff08sql or sqlFile \u5fc5\u9808\uff09\u4f8b: select.sql");
        usableProparty.put("sql2_", "SQL\u65872\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092\u6307\u5b9a\u306e\u56fa\u5b9a\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID='{&#064;SYSTEM_ID}' \u21d2 WHERE SYSTEM_ID='GE'");
        usableProparty.put("bulkKey", "SQL\u6587\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092Process_BulkQuery\u7b49\u3067\u53d6\u5f97\u3057\u305f\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID IN ( {&#064;XXXX} ) \u21d2 WHERE SYSTEM_ID IN ( 'AA','BB','CC' )");
        usableProparty.put("bulkType", "Bulk\u306e\u5024\u3092\u6587\u5b57\u5217\u306b\u5909\u63db\u3059\u308b\u5834\u5408\u306b\u3001\u6587\u5b57\u578b\u304b\u3001\u6570\u5b57\u578b\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002" + CR + "\u6570\u5b57\u578b\u3067\u306f\u3001AA,BB,CC \u3068\u3057\u3001\u6587\u5b57\u578b\u3067\u306f\u3001'AA','BB','CC' \u306b\u5909\u63db\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\uff1aSTR)");
        usableProparty.put("fetchSize", "\u30d5\u30a7\u30c3\u30c1\u3059\u308b\u884c\u6570 (\u521d\u671f\u5024:100)");
        usableProparty.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024 false:\u8868\u793a\u3057\u306a\u3044)");
        usableProparty.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "\uff08\u521d\u671f\u5024 false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

