/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmpmanager.model.ActionBuilderOidTable;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * Snmp ManagerƂAgent̉SnmpCX^Xf[^e[u \NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class OidTableView extends AbstractTableView {
	/* e[u\\[gɂJ0\[g */
	private static boolean isCol0Direction = false;

	/* e[u\\[gɂJ1\[g */
	private static boolean isCol1Direction = true;

	/* e[u\\[gɂJ2\[g */
	private static boolean isCol2Direction = true;

	/* e[u\\[gɂJ3\[g */
	private static boolean isCol3Direction = true;

	/* e[u\\[gɂJ4\[g */
	private static boolean isCol4Direction = true;

	private TableColumn col0;

	private TableColumn col1;

	private TableColumn col2;

	private TableColumn col3;

	private TableColumn col4;

	/* J */
	private static final float COLUMN0_OIDDESC = 0.15f;

	private static final float COLUMN1_OID = 0.1f;

	private static final float COLUMN2_VALUE = 0.3f;

	private static final float COLUMN3_TYPE = 0.1f;

	private static final float COLUMN4_ADDRESS = 0.1f;

	/* Table */
	private Table table;

	/* TableViewer */
	private TableViewer viewer;

	/* OIDe[uANVr_[ */
	private ActionBuilderOidTable actionOidTableBuilder;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/**
	 * Snmp ManagerƂAgent̉SnmpCX^Xf[^e[u \NXCX^X𐶐܂B
	 * 
	 */
	public OidTableView() {
		// nothing
	}

	/**
	 * ActionBuilderԂ܂B
	 * 
	 * @return actionBuilder actionOidTableBuilder
	 */
	private ActionBuilderOidTable getActionBuilder() {
		return actionOidTableBuilder;
	}

	/**
	 * tH[JXZbgꂽƂ̏łB
	 */
	public void setFocus() {
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		viewer.setContentProvider(new OidTableViewContentProvider());

		/* xEtHgȂǂݒ */
		viewer.setLabelProvider(new OidTableViewLabelProvider());

		actionOidTableBuilder = new ActionBuilderOidTable(table);
		createContextMenu();
		initActions();
	}

	/**
	 * J0iOID Descriptionj̕Ԃ܂B
	 * 
	 * @return J0iOID Descriptionj̕
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_OIDDESC);
	}

	/**
	 * J1iOIDj̕Ԃ܂B
	 * 
	 * @return J1iOIDj̕
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_OID);
	}

	/**
	 * J2iValuej̕Ԃ܂B
	 * 
	 * @return J2iValuej̕
	 */
	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2_VALUE);
	}

	/**
	 * J3iTypej̕Ԃ܂B
	 * 
	 * @return J3iTypej̕
	 */
	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3_TYPE);
	}

	/**
	 * J4iAccessj̕Ԃ܂B
	 * 
	 * @return J4iAccessj̕
	 */
	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4_ADDRESS);
	}

	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	private void createTable(Composite parent) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

		int snmpPort = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo().getSnmpPort();
		statusLineManager.setMessage("Snmp Port=" + snmpPort);

		table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		col0 = new TableColumn(table, SWT.LEFT);
		col0
				.setText(OidTableViewLabelProvider.HEADER_COLUMNS[OidTableViewLabelProvider.OID_DESC]);
		col0.setWidth(computeCol0Width());

		col1 = new TableColumn(table, SWT.LEFT);
		col1
				.setText(OidTableViewLabelProvider.HEADER_COLUMNS[OidTableViewLabelProvider.OID]);
		col1.setWidth(computeCol1Width());

		col2 = new TableColumn(table, SWT.LEFT);
		col2
				.setText(OidTableViewLabelProvider.HEADER_COLUMNS[OidTableViewLabelProvider.VALUE]);
		col2.setWidth(computeCol2Width());

		col3 = new TableColumn(table, SWT.LEFT);
		col3
				.setText(OidTableViewLabelProvider.HEADER_COLUMNS[OidTableViewLabelProvider.TYPE]);
		col3.setWidth(computeCol3Width());

		col4 = new TableColumn(table, SWT.LEFT);
		col4
				.setText(OidTableViewLabelProvider.HEADER_COLUMNS[OidTableViewLabelProvider.ACCESS]);
		col4.setWidth(computeCol4Width());

		/*
		 * TableōsNbNꂽꍇ̏
		 */
		table.addSelectionListener(new OidTableListener(table));

		/**
		 * e[uړꍇ͂TCYꍇ̃Xi[łB
		 * 
		 */
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {
					public void controlMoved(ControlEvent event) {
					}

					/*
					 * e[uTCYɃe[uJZbg܂B
					 */
					public void controlResized(ControlEvent event) {
						/*
						 * OIDe[u\Ԃł΃e[uJZbg
						 */
						setResizedTableColumnWidth();
					}
				});

		/* J0iOID DescriptionjXi[ */
		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol0Direction = sortTable(table,
						OidTableViewLabelProvider.OID_DESC, isCol0Direction);
			}
		});

		/* J1iOIDjXi[ */
		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol1Direction = sortTable(table,
						OidTableViewLabelProvider.OID, isCol1Direction);
			}
		});

		/* J2iValuejXi[ */
		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol2Direction = sortTable(table,
						OidTableViewLabelProvider.VALUE, isCol2Direction);
			}
		});

		/* J3iTypejXi[ */
		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol3Direction = sortTable(table,
						OidTableViewLabelProvider.TYPE, isCol3Direction);
			}
		});

		/* J4iAccessjXi[ */
		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol4Direction = sortTable(table,
						OidTableViewLabelProvider.ACCESS, isCol4Direction);
			}
		});
	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				col0.setWidth(computeCol0Width());
				col1.setWidth(computeCol1Width());
				col2.setWidth(computeCol2Width());
				col3.setWidth(computeCol3Width());
				col4.setWidth(computeCol4Width());

			}
		}

	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* j[}l[WɃANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		manager.add(getActionBuilder().actionClearTable());
		manager.add(getActionBuilder().actionExportOidInstanceInfo());
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[}l[WXi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			/**
			 * j[}l[WXi[łB
			 */
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * ANV̏s܂B
	 * 
	 */
	private void initActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		toolBarManager.add(getActionBuilder().actionClearTable());

		// m[h폜ANV
		toolBarManager.add(getActionBuilder().actionExportOidInstanceInfo());
	}
}
