/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;



/**
 * SNMPv3 Engine ID𐶐vtFXy[WNXłB
 * SNMPv3 Engine ID̍\͈ȉłB
 *
 * SNMPv3 Engine ID
 * --+--------------+-----------------+-----------------------------
 * 1 |Enterprise ID |Format indicator |Format
 *   | (1-4 Octets) | (5th octet)     |(variable number of octets)
 * --+--------------+-----------------+-----------------------------
 *
 *
 * Format indicator(SNMPv3 Engine ID Format)
 * +--------+--------------------------------------------------------
 * | 0      |  Reserved, unused
 * +--------+--------------------------------------------------------
 * | 1      |  IPv4 address(4 octets)
 * +--------+--------------------------------------------------------
 * | 2      |  IPv6 address(16 octets)
 * |        |  Lowest non-special IP address
 * +--------+--------------------------------------------------------
 * | 3      |  MAC address(6 octets)
 * |        |  Lowest IEEE MAC address, canonical order
 * +--------+--------------------------------------------------------
 * | 4      |  Text, administratively assigned
 * |        |  Maximum remaining length 27
 * +--------+--------------------------------------------------------
 * | 5      |  Octets, administratively assigned
 * |        |  Maximum remaining length 27
 * +--------+--------------------------------------------------------
 * |6-127   |  Reserved, unused
 * +-----------------------------------------------------------------
 * |128-255 | As defined by the enterprises
 * |        |  Maximum remaining length 27
 * +--------+--------------------------------------------------------
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3AgentEnginePreferencePage extends PreferencePage
    implements IWorkbenchPreferencePage {
	/* EngineID FormatR[h */
    private static final int ENGINEID_FORMAT_IPV4_ADR_TYPE_SELECT_NO = 0;
    private static final int ENGINEID_FORMAT_IPV6_ADR_TYPE_SELECT_NO = 1;
    private static final int ENGINEID_FORMAT_MAC_ADR_TYPE_SELECT_NO = 2;
    private static final int ENGINEID_FORMAT_TEXT_TYPE_SELECT_NO = 3;
    private static final int ENGINEID_FORMAT_OCTETS_TYPE_SELECT_NO = 4;

    /* Engine IDeLXg */
    private static final int ENGINEID_TEXT_WIDTH = 250;

    /* Engine ID ForamteLXg*/
    private static final int ENGINE_FORMAT_TEXT_WIDTH = 200;

    /* eLXg */
    private static final int TEXT_WIDTH = 120;

    /* Engine ID Foramt Maximum remaining length */
    private static final int MAXIMUM_LENGTH = 27;

    /* MO */
    private static Logger logger;

    /* Engine ID Format indicator Descriptionz */
    private static final String[] ENGINE_ID_FORMAT =
        {
            "IPv4 address (1)", "IPv6 address (2)", "MAC address (3)",
            "admin text (4)", "admin hex values (5)"
        };

    /* Enterprise ID */
    private String enterpriseID;

    /* Engine ID Format Index(Enterprise ID̎FormatR[h) */
    private String engineIDFormatIndex;

    /* Engine ID Format */
    private String engineIDFormat;

    /* EngineID */
    private Text engineIDText;

    /* EnterpriseID */
    private Text enterpriseIDText;

    /* EngineID Format combo */
    private Combo engineIDFormatCombo;

    /* EngineIDFormat */
    private Text engineIDFormatText;

    /* nbVR[hZbg{^ */
    private Button hashCodeSetButton;

    /* nbVR[h\Text */
    private Text hashCodeText;

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.
     * PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        /* Snmp V3G[WFg\[X擾 */
        SnmpV3AgentConfigInfo snmpV3AgentInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        /* Snmp V3 Engine ID */
        Label label = new Label(composite, SWT.NONE);
        label.setText("Engine ID");
        label.setLayoutData(new GridData());
        engineIDText = new Text(composite, SWT.BORDER);
        engineIDText.setText(snmpV3AgentInfo.getSnmpEngineID());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = ENGINEID_TEXT_WIDTH;
        engineIDText.setLayoutData(gridData);

        /* Snmp V3 Enterprise ID */
        label = new Label(composite, SWT.NONE);
        label.setText("Enterprise ID");
        label.setLayoutData(new GridData());
        enterpriseIDText = new Text(composite, SWT.BORDER);
        enterpriseIDText.setText(snmpV3AgentInfo.getSnmpEngineID());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = ENGINE_FORMAT_TEXT_WIDTH;
        enterpriseIDText.setLayoutData(gridData);

        /* Snmp V3G[WFg Auth Priv */
        label = new Label(composite, SWT.NONE);
        label.setText("Engine ID Format");
        label.setLayoutData(new GridData());
        engineIDFormatCombo =
            new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);

        for (int i = 0; i < ENGINE_ID_FORMAT.length; i++) {
            engineIDFormatCombo.add(ENGINE_ID_FORMAT[i]);
        }

        engineIDFormatCombo.setText(ENGINE_ID_FORMAT[0]);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = ENGINE_FORMAT_TEXT_WIDTH;
        engineIDFormatCombo.setLayoutData(gridData);

        /* Snmp V3G[WFg EngineFormat */
        label = new Label(composite, SWT.NONE);
        label.setText("EngineFormat");
        label.setLayoutData(new GridData());
        engineIDFormatText = new Text(composite, SWT.BORDER);
        engineIDFormatText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = ENGINE_FORMAT_TEXT_WIDTH;
        engineIDFormatText.setLayoutData(gridData);

        hashCodeSetButton = new Button(composite, SWT.NONE);
        hashCodeSetButton.setText("HashCode");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        hashCodeText = new Text(composite, SWT.BORDER);
        hashCodeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        hashCodeText.setLayoutData(gridData);

        /* Text\̏Zbg */
        setInitialText();

        /* Xi[Zbg */
        addSelectionListener();

        return composite;
    }

    /*
     * {^Xi[ǉ܂B
     */
    private void addSelectionListener() {
        engineIDFormatCombo.addSelectionListener(
            new SelectionListener() {
                /**
                     * EngineIDtH[}bgComboBoxIXi[łB
                     *
                     * @param event ICxg
                     */
                public void widgetSelected(SelectionEvent event) {
                    int index = engineIDFormatCombo.getSelectionIndex();

                    selectEngineIDFormat(index);
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.
                 * events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        enterpriseIDText.addKeyListener(
            new KeyListener() {
                public void keyPressed(KeyEvent event) {
                }

                public void keyReleased(KeyEvent event) {
                    enterpriseID = enterpriseIDText.getText();
                    setEngineID();
                }
            });

        engineIDFormatText.addKeyListener(
            new KeyListener() {
                public void keyPressed(KeyEvent event) {
                }

                public void keyReleased(KeyEvent event) {
                    engineIDFormat = engineIDFormatText.getText();
                    setEngineID();
                }
            });

        hashCodeSetButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent e) {
                    String hashCode = createHashCode();
                    hashCodeText.setText(hashCode);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
    }

    /*
     * Engine IDtH[}bgIɂEngine ID𐶐܂B
     *
     * @param index Engine IDtH[}bgIԍ
     */
    private void selectEngineIDFormat(int index) {
        if (index == ENGINEID_FORMAT_IPV4_ADR_TYPE_SELECT_NO) {
            /*
             * IPv4 address Type
             */
            try {
                byte[] addr = InetAddress.getLocalHost().getAddress();

                /* IPv4AhX`FbN */
                if (addr.length != 4) {
                    MessageBox alertMessageBox =
                        new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

                    alertMessageBox.setMessage("Not IPv4 address !");
                    alertMessageBox.open();
                }

                String checkEngineIDFormat = hexBytetoString(addr);
                engineIDFormatIndex = "01";
                engineIDFormat = checkEngineIDFormat;
                engineIDFormatText.setText(engineIDFormat);
                setEngineID();
            } catch (UnknownHostException e) {
                MessageBox alertMessageBox =
                    new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("UnknownHostException !");
                alertMessageBox.open();

                return;
            }
        } else if (index == ENGINEID_FORMAT_IPV6_ADR_TYPE_SELECT_NO) {
            /*
             * IPv6 address Type
                 */
            try {
                byte[] addr = InetAddress.getLocalHost().getAddress();

                if (addr.length != 16) {
                    /* IPv6AhX`FbNُ */
                    MessageBox alertMessageBox =
                        new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

                    alertMessageBox.setMessage("Not IPv6 address !");
                    alertMessageBox.open();
                }

                String checkEngineIDFormat = hexBytetoString(addr);

                engineIDFormatIndex = "02";
                engineIDFormat = checkEngineIDFormat;
                engineIDFormatText.setText(engineIDFormat);
                setEngineID();
            } catch (UnknownHostException e) {
                MessageBox alertMessageBox =
                    new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("UnknownHostException !");
                alertMessageBox.open();

                return;
            }
        } else if (index == ENGINEID_FORMAT_MAC_ADR_TYPE_SELECT_NO) {
            /*
             * MAC address Type
             */
            String checkEngineIDFormat = engineIDFormatText.getText();

            if (checkEngineIDFormat.length() == 12) {
                MessageBox alertMessageBox =
                    new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("MAC address(6 octets) !");
                alertMessageBox.open();
                engineIDFormatText.setFocus();

                return;
            }

            engineIDFormatIndex = "03";
            engineIDFormat = checkEngineIDFormat;
            engineIDFormatText.setText(engineIDFormat);
            setEngineID();
        } else if (index == ENGINEID_FORMAT_TEXT_TYPE_SELECT_NO) {
            /*
             * Admin text Type
             */
            String checkEngineIDFormat = engineIDFormatText.getText();

            if (checkEngineIDFormat.length() > (MAXIMUM_LENGTH * 2)) {
                MessageBox alertMessageBox =
                    new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Maximum remaining length 27");
                alertMessageBox.open();
                engineIDFormatText.setFocus();

                return;
            }

            engineIDFormatIndex = "04";
            engineIDFormat = checkEngineIDFormat;

            setEngineID();
        } else if (index == ENGINEID_FORMAT_OCTETS_TYPE_SELECT_NO) {
            /*
             * Admin hex values Type
                 */
            String checkEngineIDFormat = engineIDFormatText.getText();

            if (checkEngineIDFormat.length() > (MAXIMUM_LENGTH * 2)) {
                MessageBox alertMessageBox =
                    new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Maximum remaining length 27");
                alertMessageBox.open();
                engineIDFormatText.setFocus();

                return;
            }

            engineIDFormatIndex = "05";
            engineIDFormat = checkEngineIDFormat;

            setEngineID();
        }
    }

    /*
     * Text\̏Zbgs܂B
     *
     */
    private void setInitialText() {
        /* Snmp V3G[WFg\[X擾 */
        SnmpV3AgentConfigInfo snmpV3AgentInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();
        String engineID = snmpV3AgentInfo.getSnmpEngineID();

        /*
         * Enterprise IDEngine ID̐擪4oCg
         */
        enterpriseID = engineID.substring(0, 8);
        enterpriseIDText.setText(enterpriseID);

        String engineFormat = engineID.substring(9, engineID.length());
        engineIDFormatText.setText(engineFormat);
        engineIDFormat = engineFormat;

        /* Engine IDtH[}bg ftHg Text TypeZbg */
        engineIDFormatCombo.select(4);
        engineIDFormatIndex = "05";
    }

    /*
     * enterpriseIDAengineIDFormatIndexyengineIDFormatengineID
     * 𐶐܂B
     *
     */
    private void setEngineID() {
        enterpriseID = enterpriseIDText.getText();

        String engineID = enterpriseID + engineIDFormatIndex + engineIDFormat;

        engineIDText.setText(engineID);
    }

    /*
     * nbVR[hԂ܂B
     * (Engine IDɗp\Ƃ܂B)
     *
     * @return nbVR[h
     */
    private String createHashCode() {
        int hashCode = this.hashCode();
        byte[] array = new byte[4];
        array[0] = (byte) ((hashCode >> 24) & 0xff);
        array[1] = (byte) ((hashCode >> 16) & 0xff);
        array[2] = (byte) ((hashCode >> 8) & 0xff);
        array[3] = (byte) (hashCode & 0xff);

        return hexBytetoString(array);
    }

    /*
     * oCgzf[^16iɕϊĕԂ܂B
     *
     * @param byteData oCgzf[^
     * @return returnString.toString();
     */
    private String hexBytetoString(byte[] byteData) {
        StringBuffer returnString = new StringBuffer("");

        for (int i = 0; byteData.length > i; i++) {
            int pos = byteData[i];

            if (pos < 0) {
                pos += 256;
            }

            returnString.append(Integer.toHexString(pos / 16));
            returnString.append((Integer.toHexString(pos % 16)));
        }

        return returnString.toString();
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        /* Snmp V3G[WFg\[X擾 */
        SnmpV3AgentConfigInfo snmpV3AgentInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();

        /* Engine IDEnterpriseo */
        String engineID = snmpV3AgentInfo.getSnmpEngineID();
        enterpriseID = engineID.substring(0, 8);
        enterpriseIDText.setText(enterpriseID);

        /* Engine ID FormatlZbg */
        engineIDFormatCombo.select(4);
        engineIDFormatIndex = "05";

        /* Engine IDEngine ID Format(擪4oCgEnterprise)o */
        String engineFormat = engineID.substring(9, engineID.length());
        engineIDFormatText.setText(engineFormat);
        engineIDFormat = engineFormat;

        /* Engine IDZbg */
        engineIDText.setText(snmpV3AgentInfo.getSnmpEngineID());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        /*
             * Enterprise`FbN
             */
        if ((enterpriseID.length() > 8) || (enterpriseID.length() < 1)) {
            MessageBox alertMessageBox =
                new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

            alertMessageBox.setMessage(
                "Out range Enterprise ID length 1-4 Octets !");
            alertMessageBox.open();
            enterpriseIDText.setFocus();

            return true;
        }

        /*
             * Engine ID Format`FbN
             */
        if (engineIDFormatIndex.equals("4") || engineIDFormatIndex.equals("5")) {
            if (engineIDFormat.length() > (MAXIMUM_LENGTH * 2)) {
                MessageBox alertMessageBox =
                    new MessageBox(getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Maximum remaining length 27");
                alertMessageBox.open();
                engineIDFormatText.setFocus();

                return true;
            }
        }

        /*
         * Engine IDݒmF
         */
        if (
            !MessageDialog.openQuestion(
                    getShell(), "Confirm",
                    "SNMP EngineID = " + engineIDText.getText() + " ?")) {
            return true;
        }

        SnmpAgentConfigInfo info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();
        SnmpV3AgentConfigInfo snmpV3Info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();

        /* Snmp v3 AgentView text͒lɍXV */
        snmpV3Info.setSnmpEngineID(engineIDText.getText());

        /* XV񂩂Document񐶐 */
        Document dom =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .updateDocument(info, snmpV3Info);

        // t@Co̓obt@擾
        BufferedWriter bufWriter = null;
        bufWriter =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getResourceFileWriter();

        // XMLt@Co
        SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                         .outputXMLFile(bufWriter, dom);

        if (bufWriter != null) {
            try {
                bufWriter.close();
            } catch (IOException e) {
                logger.warning(
                    "Abort close BufferedWriter for snmp V3 agent resource : "
                    + e.getMessage());
                e.printStackTrace();
            }
        }

        if (NetJFWatcherApplication.getAgentOperationView() != null) {
            NetJFWatcherApplication.getAgentOperationView().updateSnmpAgentInfo();
        }

        return super.performOk();
    }
}
