/*
 * Created on 2004/09/24
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpv3;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.logging.Logger;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpV3Preference;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.message.SnmpSequenceDecrypt;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;



/**
 * USM(User based Security Model)ZLeBs\bh
 * NXłB
 * F؃R[h̐E`FbNyшÍyѕs\bh
 * ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class UsmSecuritySubsystem {
    /** <p>Salt 𐶐邽߂̃f[^</p> */
    private static int ivLow = 0;

    /* MO */
    private static Logger logger;

    /*
     * USM(User based Security Model)ZLeBs\bh
     * VOgNXCX^X𐶐܂B
     */
    private UsmSecuritySubsystem() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * <p>bZ[WF؃R[h(MAC)̃`FbNs܂B<br>
     * MAC ꍇ trueAłȂꍇ false Ԃ܂B</p>
     *
     * @param request MbZ[W
     * @param msgSecurityParameters MbZ[WɂmsgSecurityParameters
     * @param key f[^
     * @return MAC ꍇ trueAłȂꍇ false
     * @throws GeneralSecurityException ZLeBOꍇɃX[܂
     */
    public synchronized boolean checkAuth(
        SnmpSequence request, SnmpSequence msgSecurityParameters, Key key)
        throws GeneralSecurityException {
        SnmpOctetString msgAuthenticationParameters =
            (SnmpOctetString) msgSecurityParameters.getSNMPObjectAt(4);

        byte[] msgAuth = (byte[]) msgAuthenticationParameters.getValue();

        if (
            msgAuth.length != SnmpV3Preference.MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN) {
            logger.warning(
                "msgAuth length != "
                + SnmpV3Preference.MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN
                + " (msgAuth length = " + msgAuth.length + ")");

            return false;
        }

        // MbZ[W̃rh
        try {
            /* message digest(12byte)msgSecurityParametersɖߍ */
            msgAuthenticationParameters.setValue(
                new byte[SnmpV3Preference.MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN]);
            msgSecurityParameters.addSNMPObject(
                msgAuthenticationParameters,
                SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_PARAMS);

            /* msgSecurityParametersmessageɖߍ */
            SnmpOctetString work =
                new SnmpOctetString(msgSecurityParameters.getBEREncoding());
            request.addSNMPObject(
                work, SnmpV3Preference.POS_SECURITY_PARA_MESSAGE);
        } catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        // MAC ̎擾
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);
        mac.update(request.getBEREncoding());

        byte[] digest = mac.doFinal();

        // `FbN
        boolean flag = true;

        for (
            int i = 0;
                i < SnmpV3Preference.MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN;
                i++) {
            if (msgAuth[i] != digest[i]) {
                flag = false;

                break;
            }
        }

        return flag;
    }

    /**
     * <p>bZ[WF؃R[h(MAC)vZAMbZ[Wɖߍ݂܂B</p>
     *
     * @param response MbZ[W
     * @param msgSecurityParameters MbZ[WłmsgSecurityParameters
     * @param key f[^
     * @throws GeneralSecurityException ZLeBOꍇɃX[܂
     */
    public synchronized SnmpOctetString setAuth(
        SnmpSequence response, SnmpSequence msgSecurityParameters, Key key)
        throws GeneralSecurityException {
        /*
         * msgSecurityParametersmsgAuthenticationParameters
         * (message digest,@12bytesHMAC-MD5 HMAC-SHA)f[^o
         */
        SnmpOctetString msgAuthenticationParameters =
            (SnmpOctetString) msgSecurityParameters.getSNMPObjectAt(4);

        // MAC ̌vZ
        Mac mac = Mac.getInstance(key.getAlgorithm());
        mac.init(key);

        // mac.update( response.encode() ) ;
        mac.update(response.getBEREncoding());

        byte[] digest = mac.doFinal();

        /*
         * MbZ[W MAC 𖄂ߍ
         * imessage digestf[^msgAuthenticationParametersɃZbgj
         */
        byte[] newDigest =
            new byte[SnmpV3Preference.MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN];
        System.arraycopy(
            digest, 0, newDigest, 0,
            SnmpV3Preference.MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN);

        SnmpOctetString msgAuthenticationParametersOctet = null;

        msgAuthenticationParametersOctet = new SnmpOctetString(newDigest);

        return msgAuthenticationParametersOctet;
    }

    /**
     * <p>xNg(IV)𐶐܂B</p>
     *
     * @param snmpEngineBoots SNMP Engine Boots
     * @return xNg(IV)
     */
    public synchronized byte[] getIV(int snmpEngineBoots) {
        byte[] iv = new byte[8];
        iv[0] = (byte) ((snmpEngineBoots >> 24) & 0xff);
        iv[1] = (byte) ((snmpEngineBoots >> 16) & 0xff);
        iv[2] = (byte) ((snmpEngineBoots >> 8) & 0xff);
        iv[3] = (byte) (snmpEngineBoots & 0xff);
        iv[4] = (byte) ((ivLow >> 24) & 0xff);
        iv[5] = (byte) ((ivLow >> 16) & 0xff);
        iv[6] = (byte) ((ivLow >> 8) & 0xff);
        iv[7] = (byte) (ivLow & 0xff);
        ivLow++;

        return iv;
    }

    /* public static byte[] getIV( String snmpEngineID, int snmpEngineBoots ) {

            byte iv[] = new byte[ 8 ] ;

            SnmpEngineBootsLowCounter bootsCounterInfo = null;
            if(!snmpEngineBootsLowCounterMap.containsKey(snmpEngineID)){
                    bootsCounterInfo = new SnmpEngineBootsLowCounter();
            } else {
                    bootsCounterInfo = (SnmpEngineBootsLowCounter)snmpEngineBootsLowCounterMap.get(snmpEngineID);
            }
            int lowCounter = bootsCounterInfo.getCounter();
            iv[ 0 ] = (byte)((snmpEngineBoots >> 24) & 0xff) ;
            iv[ 1 ] = (byte)((snmpEngineBoots >> 16) & 0xff) ;
            iv[ 2 ] = (byte)((snmpEngineBoots >>  8) & 0xff) ;
            iv[ 3 ] = (byte)( snmpEngineBoots        & 0xff) ;
            iv[ 4 ] = (byte)((lowCounter >> 24) & 0xff) ;
            iv[ 5 ] = (byte)((lowCounter >> 16) & 0xff) ;
            iv[ 6 ] = (byte)((lowCounter >>  8) & 0xff) ;
            iv[ 7 ] = (byte)( lowCounter        & 0xff) ;


            bootsCounterInfo.countUp();
            snmpEngineBootsLowCounterMap.put(snmpEngineID, bootsCounterInfo);

            // ivLow++ ;
            return iv ;
    } */

    /**
     * <p>Salt 擾܂B</p>
     *
     * @param key f[^
     * @param iv xNg(IV)
     * @return Salt
     */
    public synchronized byte[] getSalt(Key key, byte[] iv) {
        byte[] salt = new byte[8];
        System.arraycopy(key.getEncoded(), 8, salt, 0, 8);

        for (int i = 0; i < 8; i++) {
            salt[i] ^= iv[i];
        }

        return salt;
    }

    /**
     * <p>f[^𕜍܂B</p>
     *
     * @param scopedPDU Íꂽf[^
     * @param salt Salt
     * @param key f[^
     * @return ꂽf[^
     * @throws GeneralSecurityException ZLeBOꍇɃX[܂
     */
    public synchronized SnmpSequence decrypt(
        byte[] scopedPDU, byte[] salt, Key key) throws GeneralSecurityException {
        // Salt ̒`FbN
        if (salt.length != 8) {
            return null;
        }

        // DES 
        Cipher cipher = Cipher.getInstance(UsmUserManager.CIPHER_DES);
        cipher.init(
            Cipher.DECRYPT_MODE,
            SecretKeyFactory.getInstance(UsmUserManager.CIPHER_DES).generateSecret(
                new DESKeySpec(key.getEncoded())));

        // DES 
        byte[] decoded = new byte[scopedPDU.length];
        int offset = 0;
        int length = scopedPDU.length;

        while (length > 0) {
            byte[] array = cipher.update(scopedPDU, offset, length);

            int len = array.length;

            if (decoded.length < (len + offset)) {
                return null;
            }

            System.arraycopy(array, 0, decoded, offset, len);
            offset += len;
            length -= len;
        }

        // f[^xNg(IV)  XOR
        byte[] iv = getSalt(key, salt);

        for (int i = 0, li = decoded.length / 8; i < li; i++) {
            for (int j = 0; j < 8; j++) {
                decoded[(i * 8) + j] ^= iv[j];
            }

            System.arraycopy(scopedPDU, i * 8, iv, 0, 8);
        }

        // oCgfR[h
        SnmpSequence snmpSequenceMsgData = null;

        try {
            snmpSequenceMsgData = new SnmpSequenceDecrypt(decoded);
        } catch (SnmpBadValueException e) {
            logger.warning("Abort decrypt : " + e.getMessage());
            e.printStackTrace();

            return null;
        } catch (RuntimeException e) {
            logger.warning("Abort decrypt : " + e.getMessage());
            e.printStackTrace();

            return null;
        }

        return snmpSequenceMsgData;
    }

    /**
     * <p>f[^Í܂B</p>
     *
     * @param scopedPDU Íf[^
     * @param iv xNg(IV)
     * @param key f[^
     * @return Íꂽf[^
     * @throws GeneralSecurityException ZLeBOꍇɃX[܂
     */
    public static byte[] encrypt(SnmpSequence scopedPDU, byte[] iv, Key key)
        throws GeneralSecurityException {
        // oCgɃGR[hpfBO
        byte[] array = scopedPDU.getBEREncoding();
        int length = array.length;
        int padding = 8 - (length % 8);

        if (padding == 8) {
            padding = 0;
        }

        byte[] encoded = new byte[length + padding];
        System.arraycopy(array, 0, encoded, 0, length);

        for (int i = 0; i < padding; i++) {
            encoded[length + i] = SnmpBERCodec.SNMPNULL_TAG;
        }

        // DES 
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(
            Cipher.ENCRYPT_MODE,
            SecretKeyFactory.getInstance("DES").generateSecret(
                new DESKeySpec(key.getEncoded())));

        for (int i = 0, li = encoded.length / 8; i < li; i++) {
            // Íf[^xNg(IV)  XOR
            for (int j = 0; j < 8; j++) {
                encoded[(i * 8) + j] ^= iv[j];
            }

            // DES Í
            array = cipher.update(encoded, i * 8, 8);
            System.arraycopy(array, 0, encoded, i * 8, 8);
            iv = array;
        }

        // System.out.println("encrypt encoded : " + bytesToString(encoded));
        return encoded;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static UsmSecuritySubsystem getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final UsmSecuritySubsystem RESOURCE = new UsmSecuritySubsystem();
    }
}
