/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.messageformat;

import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;



/**
 * SNMPIuWFNg^CvɑΉSNMPIuWFNgCX^X
 * 擾郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 10
 */
public final class SnmpMappingTableController {
    /*
     * R}h}bsOe[uAR}hIDL[Ƃ
     * R}hۃNX̃CX^Xi[Hashe[u
     */
    private static HashMap snmpObjectTypeMap = new HashMap();

    /* logging */
    private static Logger logger;

    /**
     * R}h}bsOe[u\[XǂݍŁAR}hID
     * L[ƂR}hۃNX̃CX^XHashe[u
     * ɓo^܂B<BR>
     *
     */
    private SnmpMappingTableController() {
        logger = Logger.getLogger(this.getClass().getName());

        /*  */
        SnmpMappingResource mappingTbaleResource = new SnmpMappingResource();

        /* R}h}bsOe[uIDƃCX^X1Zbg
         * 2z */
        Object[][] mappingTable = mappingTbaleResource.getCommandMappingTable();

        /* IDL[ƂăCX^XHashɓo^ */
        for (int i = 0; i < mappingTable.length; i++) {
            snmpObjectTypeMap.put(mappingTable[i][0], mappingTable[i][1]);
        }
    }

    /**
     * R}h}bsOe[uRg[NX̃CX^X
     * Ԃ܂BiNXێĂVOgEIuWF
     * NgԂ܂j<BR>
     *
     * @return uniqueInstance R}h}bsOe[uRg[
     * NX̃CX^X
     */
    public static SnmpMappingTableController getInstance() {
        return SingletonCommandMappingTableController.uniqueInstance;
    }

    /**
     * SNMPIuWFNg^CvɑΉSNMPIuWFNgCX^XԂ
     * ܂B<BR>
     *
     * @param snmpObjectType SNMPIuWFNg^Cv
     * @return snmpObjectInstance SNMPIuWFNgCX^X
     */
    public AbstractSnmpObject getSnmpObjectInstance(
        final String snmpObjectType) {
        AbstractSnmpObject snmpObjectInstance = null;

        if (snmpObjectTypeMap.containsKey(snmpObjectType)) {
            snmpObjectInstance =
                (AbstractSnmpObject) snmpObjectTypeMap.get(snmpObjectType);
        } else {
            // assert false : "Abort Command@Instance";
            logger.warning(
                "Not found in Command mapping table : " + snmpObjectType);
        }

        return snmpObjectInstance;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonCommandMappingTableController {
        private static SnmpMappingTableController uniqueInstance =
            new SnmpMappingTableController();
    }
}
