/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.calendar.DataFilterInfo;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibIfDescriptor;
import netjfwatcher.engine.socket.info.StatisticsMibInfo;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/**
 * m[hSNMPvOt`sNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodeSnmpStatisticsChart extends AbstractEditorNodeChart {
	/* MO */
	private static Logger logger;

	/* OID̃CX^Xi[郊Xg */
	private ArrayList oidInstanceList = new ArrayList();

	/* ̎Jn */
	private String startDate;

	/* ̎ŐV */
	private String endDate;

	/**
	 * m[hSNMPvOt`sNXCX^X𐶐܂B
	 * 
	 */
	public EditorNodeSnmpStatisticsChart() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * Popupj[𐶐܂B
	 * 
	 * @param parent
	 *            PopupjzuComposite
	 */
	protected void setPopupMenu(Composite parent) {
		popUpMenu = new Menu(parent.getShell(), SWT.POP_UP);
		canvas.setMenu(popUpMenu);

		MenuItem menuItemAll = new MenuItem(popUpMenu, SWT.NULL);
		menuItemAll.setText("All");

		MenuItem menuItemRefresh = new MenuItem(popUpMenu, SWT.NULL);
		menuItemRefresh.setText("Refresh");

		if ((itemNameList != null) && (itemNameList.size() > 1)) {
			MenuItem[] menuItem = new MenuItem[itemNameList.size()];

			for (int i = 0; i < itemNameList.size(); i++) {
				menuItem[i] = new MenuItem(popUpMenu, SWT.NULL);
				menuItem[i].setText((String) itemNameList.get(i));

				final int itemCount = i;
				menuItem[i].addSelectionListener(new SelectionAdapter() {
					public void widgetSelected(SelectionEvent e) {
						mode = "";
						selectNo = itemCount;
						redraw();
					}
				});
			}
		}

		/* SOt\j[Xi[ */
		menuItemAll.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				mode = ALL_DRAW_MODE;
				selectNo = 0;
				redraw();
			}
		});

		/* XVj[Xi[ */
		menuItemRefresh.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				try {
					getChartData();
				} catch (DatabaseConnectionException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				} catch (SQLException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}

				mode = ALL_DRAW_MODE;
				selectNo = 0;
				redraw();
			}
		});
	}

	/**
	 * f[^x[XSNMPvWXgɕێ܂B
	 * 
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV擾Ɏsꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	protected void getChartData() throws DatabaseConnectionException,
			SQLException {
		if (allStatisticsDataList == null) {
			oidInstanceList = new ArrayList();
			dateList = new ArrayList();
			allStatisticsDataList = new ArrayList();
		} else {
			oidInstanceList.clear();
			dateList.clear();
			allStatisticsDataList.clear();
		}

		String ipAddress = targetNodeInfo.getIpaddress();
		String selectOid = inputOid;
		ArrayList ifDescriptorList = null;

		DBTableStatisticsMIBControl mibDBTable = null;
		String engineAddress = "";

		if (!isSocket) {
			mibDBTable = DBTableStatisticsMIBControl.getInstance();

			ifDescriptorList = mibDBTable.findIfDescriptor(ipAddress);
		} else {
			/* vMIB̎ɂāAOIDC^tF[Xn̏ꍇifDesc擾邽߂̃CX^XZbg */
			StatisticsMibControl control = new StatisticsMibControl();
			control.setSubCommand(StatisticsMibControl.IF_DESCRIPTOR_GET);
			control.setIpaddress(ipAddress);

			engineAddress = ClientEngineInfo.getClientEngineInfoInstance()
					.getEngineAddress();

			/* GWSNMPv擾 */
			ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
					engineAddress);

			try {
				StatisticsMibProperty mibproperty = statisticsMibGet
						.getStatisticsMib(control);
				ifDescriptorList = mibproperty.getMibIfDescriptorList();
			} catch (EngineConnectException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e.getMessage() + " Engine=" + engineAddress);
				shell.dispose();
			} catch (IOException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e.getMessage() + " Engine=" + engineAddress);
				shell.dispose();
			}
		}

		/* wOID̃CX^X𒊏oăXgɊi[ */
		for (int i = 0; i < ifDescriptorList.size(); i++) {
			StatisticsMibIfDescriptor statisricsMibIfDesc = (StatisticsMibIfDescriptor) ifDescriptorList
					.get(i);

			String workOid = statisricsMibIfDesc.getOid();

			int checkPoint = "Oid=".length();

			if (checkPoint >= 0) {
				/* w肳ꂽOIDɈvCX^XXgɊi[ */
				if (workOid.substring(checkPoint).equals(selectOid)) {
					oidInstanceList.add(statisricsMibIfDesc.getInstance());
				}
			}
		}

		if (maxData == null) {
			maxData = new String[oidInstanceList.size()];
			minData = new String[oidInstanceList.size()];
		}

		StatisticsMibProperty mibProperty = null;

		for (int k = 0; k < oidInstanceList.size(); k++) {
			String oidIns = (String) oidInstanceList.get(k);

			if (!isSocket) {
				/* OIDCX^X̃f[^A̎ԁAPʂȂ */
				mibProperty = mibDBTable.getDataCount(ipAddress, selectOid,
						oidIns);
			} else {
				/* vMIB̎ɂāAOIDC^tF[Xn̏ꍇifDesc擾邽߂̃CX^XZbg */
				StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
				statisticsMibControl
						.setSubCommand(StatisticsMibControl.STATISTICS_DATA_GET);
				statisticsMibControl.setIpaddress(ipAddress);
				statisticsMibControl.setOid(selectOid);
				statisticsMibControl.setOidInstance(oidIns);

				ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
						engineAddress);

				try {
					mibProperty = statisticsMibGet
							.getStatisticsMib(statisticsMibControl);
				} catch (EngineConnectException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();
				} catch (IOException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();
				}
			}

			/*
			 * f[^́A̎斳ɂreturn
			 */
			if ((mibProperty.getTotalDataCount() == 0)
					|| (mibProperty.getStartDate() == null)
					|| (mibProperty.getEndDate() == null)) {
				return;
			}

			startDate = mibProperty.getStartDate().toString();
			endDate = mibProperty.getEndDate().toString();

			maxData[k] = mibProperty.getMaxData();
			minData[k] = mibProperty.getMinData();
		}

		String filterStart;
		String filterEnd;

		String filterCheckStart = DataFilterInfo.getInstance().getStartDate();
		String filterCheckEnd = DataFilterInfo.getInstance().getEndDate();
		if (filterCheckStart == null || filterCheckStart.equals("")) {
			filterStart = startDate;
		} else {
			filterStart = filterCheckStart;
		}
		if (filterCheckEnd == null || filterCheckEnd.equals("")) {
			filterEnd = endDate;
		} else {
			filterEnd = filterCheckEnd;
		}
		int limit = DataFilterInfo.getInstance().getLimit();
		/*
		 * wOID̓vf[^ƍ̎CX^X f[^x[X擾ăXgɕێ
		 */
		for (int j = 0; j < oidInstanceList.size(); j++) {
			String instance = (String) oidInstanceList.get(j);

			ArrayList instanceDataList = new ArrayList();
			ArrayList dataList = null;

			if (!isSocket) {
				dataList = mibDBTable.findInstance(ipAddress, selectOid,
						instance, filterStart, filterEnd);
			} else {
				/* GWƒʐM邽߂ɁAvMIBOIDCX^XAWԂȂǂ̐CX^XZbg */
				StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
				statisticsMibControl
						.setSubCommand(StatisticsMibControl.STATISTICS_DATA_GET);
				statisticsMibControl.setIpaddress(ipAddress);
				statisticsMibControl.setOid(selectOid);
				statisticsMibControl.setOidInstance(instance);
				statisticsMibControl.setPeriodStartDate(filterStart);
				statisticsMibControl.setPeriodEndDate(filterEnd);

				/* GWƒʐMAf[^擾 */
				ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
						engineAddress);

				try {
					StatisticsMibProperty mibproperty = statisticsMibGet
							.getStatisticsMib(statisticsMibControl);
					dataList = mibproperty.getMibInfoList();
				} catch (EngineConnectException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();
				} catch (IOException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();
				}
			}

			/*
			 * ̎XgɃZbg
			 */
			for (int i = 0; i < dataList.size(); i++) {
				StatisticsMibInfo instanceValueList = (StatisticsMibInfo) dataList
						.get(i);

				/* ŏ̃CX^Xf[^̓XgɃZbg */
				if (j == 0) {
					/* ̎XgɃZbg */
					dateList.add(instanceValueList.getDate().toString());
				}

				/* ̎f[^XgɃZbg */
				instanceDataList.add(instanceValueList.getStatisMibValue());
				if (limit != 0 && i >= limit) {
					break;
				}
			}

			/* CX^X̍̎f[^XgSi[XgɊi[ */
			allStatisticsDataList.add(instanceDataList);
		}
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}
}
