/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.nodedetect;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.node.EditorNodeOperationInitialData;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;

/**
 * m[hThraed󋵂IɊĎĕ\Aom[hĎo^NX łB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeDetectTimerProcessor implements Runnable {
	/** Ď(ms) */
	private static final int TIMER = 1000;

	/* Logging */
	private static Logger logger;

	private IEditorSite editorSite;

	private String nodeKind = "Router";

	private String nodeGroup;

	private String snmpPeriod;

	private String pingPeriod;

	private String snmpROCommunity;

	private int snmpVersion;

	/* Display */
	private Display display;

	/* m[hoJn{^ */
	private Button startButton;

	/* m[hoLZ{^ */
	private Button cancelButton;

	/* m[h`FbN\Text */
	private Text chekNodeCountText;

	/* IP OKm[h\Text */
	private Text ipNodeCountText;

	/* SNMP OKm[h\Text */
	private Text snmpNodeCountText;

	/*
	 * m[hThraed󋵂IɊĎĕ\Aom[hĎo^NX CX^X𐶐܂B
	 */
	private NodeDetectTimerProcessor() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * m[hThraed󋵂IɊĎAEditorPartsɕ\܂B ܂Am[hɃm[ho^s܂B
	 * 
	 */
	public void run() {
		if (editorSite.getPage().isPartVisible(editorSite.getPart())) {
			int checkNode = ThreadAutoNodeDetect.getInstance().getPingOKList()
					.size()
					+ ThreadAutoNodeDetect.getInstance().getPingNGList().size();
			int totalNode = ThreadAutoNodeDetect.getInstance().getSnmpNGList()
					.size()
					+ ThreadAutoNodeDetect.getInstance().getSnmpIFNGList()
							.size()
					+ ThreadAutoNodeDetect.getInstance().getSnmpIFOKList()
							.size();

			chekNodeCountText.setText(Integer.toString(checkNode)
					+ "/"
					+ Integer.toString(ThreadAutoNodeDetect.getInstance()
							.getCheckNodeAddressList().size()));

			snmpNodeCountText.setText(Integer.toString(ThreadAutoNodeDetect
					.getInstance().getSnmpOKList().size()));
			ipNodeCountText.setText(Integer.toString(ThreadAutoNodeDetect
					.getInstance().getPingOKList().size()));

			if (checkNode == ThreadAutoNodeDetect.getInstance()
					.getCheckNodeAddressList().size()) {
				chekNodeCountText.setText(Integer.toString(checkNode)
						+ "/"
						+ Integer.toString(ThreadAutoNodeDetect.getInstance()
								.getCheckNodeAddressList().size()));
				cancelButton.setEnabled(false);

				if (totalNode != 0) {
					StringBuffer message = new StringBuffer();
					message.append("Node Register ?"
							+ System.getProperty("line.separator"));
					message.append(System.getProperty("line.separator"));
					message.append("IP Node          = "
							+ ThreadAutoNodeDetect.getInstance()
									.getSnmpNGList().size()
							+ System.getProperty("line.separator"));
					message.append("SNMP Level1 Node = "
							+ ThreadAutoNodeDetect.getInstance()
									.getSnmpIFNGList().size()
							+ System.getProperty("line.separator"));
					message.append("SNMP Level2 Node = "
							+ ThreadAutoNodeDetect.getInstance()
									.getSnmpIFOKList().size()
							+ System.getProperty("line.separator"));
					message.append("-------------------------"
							+ System.getProperty("line.separator"));
					message.append("Total Node       = " + totalNode
							+ System.getProperty("line.separator"));

					if (MessageDialog.openQuestion(editorSite.getShell(),
							"Confirm", message.toString())) {
						/*
						 * m[ho^
						 */
						ArrayList duplicateAddressList = registerNode();

						/*
						 * o^m[hɓo^ς݃m[h̏ꍇɂWarning \
						 */
						if (duplicateAddressList.size() > 0) {
							StringBuffer message2 = new StringBuffer();
							message2.append("Already register node count = "
									+ duplicateAddressList.size()
									+ System.getProperty("line.separator"));
							message2.append(System
									.getProperty("line.separator"));

							for (int ipCount = 0; ipCount < duplicateAddressList
									.size(); ipCount++) {
								message2.append("Duplicate IP Address = "
										+ (String) duplicateAddressList
												.get(ipCount)
										+ System.getProperty("line.separator"));
							}

							MessageDialog.openWarning(editorSite.getShell(),
									"Warning", message2.toString());
						} else {
							MessageDialog.openInformation(
									editorSite.getShell(), "Info",
									"Node register complete.");
						}
					}
				}

				startButton.setEnabled(true);
				cancelButton.setEnabled(false);

				/* ^C}[~ */
				display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
						this);
			} else {
				// ^C}[p
				display.timerExec(TIMER, this);
			}
		} else {
			// ^C}[p
			display.timerExec(TIMER, this);
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static NodeDetectTimerProcessor getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * TimersDisplayZbg܂B
	 * 
	 * @param display
	 *            TimersDisplay
	 */
	public void setDisplay(Display display) {
		this.display = display;
	}

	/**
	 * m[ho^̃p[^Zbg܂B
	 * 
	 * @param nodeKind
	 *            m[h
	 * @param pingPeriod
	 *            PingĎ
	 * @param snmpPeriod
	 *            SNMPĎ
	 * @param snmpROCommunity
	 *            SNMP ReadR~jeB
	 * @param snmpVersion
	 *            SNMPo[W
	 */
	public void setNodeAddParam(String nodeKind, String nodeGroup,
			String pingPeriod, String snmpPeriod, String snmpROCommunity,
			int snmpVersion) {
		this.snmpPeriod = snmpPeriod;
		this.pingPeriod = pingPeriod;
		this.snmpROCommunity = snmpROCommunity;
		this.snmpVersion = snmpVersion;
		this.nodeKind = nodeKind;
		this.nodeGroup = nodeGroup;
	}

	/**
	 * m[h󋵕\ptextȂǂZbg܂B
	 * 
	 * @param editorSite
	 *            IEditorSite
	 * @param chekNodeCountText
	 *            m[hΏIPAhX\Text
	 * @param ipNodeCountText
	 *            IP OKm[h\text
	 * @param snmpNodeCountText
	 *            SNMP OKm[h\text
	 * @param startButton
	 *            m[hJn{^
	 * @param cancelButton
	 *            m[hLZ{^
	 */
	public void setText(IEditorSite editorSite, Text chekNodeCountText,
			Text ipNodeCountText, Text snmpNodeCountText, Button startButton,
			Button cancelButton) {
		this.editorSite = editorSite;
		this.chekNodeCountText = chekNodeCountText;
		this.ipNodeCountText = ipNodeCountText;
		this.snmpNodeCountText = snmpNodeCountText;
		this.startButton = startButton;
		this.cancelButton = cancelButton;
	}

	/*
	 * m[ho^܂B ɓo^ς݃m[h݂ꍇɂ́ADuplicateAhXXgɃZbg܂B
	 */
	private ArrayList registerNode() {
		HashMap nodeMap = getNodeList();
		ArrayList dupicateAddressList = new ArrayList();
		ArrayList snmpNGList = ThreadAutoNodeDetect.getInstance()
				.getSnmpNGList();
		ArrayList snmpIFOKList = ThreadAutoNodeDetect.getInstance()
				.getSnmpIFOKList();

		ArrayList snmpIFNGList = ThreadAutoNodeDetect.getInstance()
				.getSnmpIFNGList();

		NodeAdd nodeAddInstance = NodeAdd.getInstance();

		for (int i = 0; i < snmpNGList.size(); i++) {
			NodeInformation addNodeInfo = createNodeInfo((String) snmpNGList
					.get(i), pingPeriod, "0",
					SnmpPreference.SNMP_LEVEL0_DESCRIPTION, snmpVersion,
					snmpROCommunity);

			if (addNodeInfo != null) {
				if (!nodeMap.containsKey((String) snmpNGList.get(i))) {
					nodeAddInstance.addNode(addNodeInfo, true);
				} else {
					dupicateAddressList.add((String) snmpNGList.get(i));
				}
			}
		}

		for (int i = 0; i < snmpIFNGList.size(); i++) {
			NodeInformation addNodeInfo = createNodeInfo((String) snmpIFNGList
					.get(i), pingPeriod, snmpPeriod,
					SnmpPreference.SNMP_LEVEL1_DESCRIPTION, snmpVersion,
					snmpROCommunity);

			if (addNodeInfo != null) {
				if (!nodeMap.containsKey((String) snmpIFNGList.get(i))) {
					nodeAddInstance.addNode(addNodeInfo, true);
				} else {
					dupicateAddressList.add((String) snmpIFNGList.get(i));
				}
			}
		}

		for (int i = 0; i < snmpIFOKList.size(); i++) {
			NodeInformation addNodeInfo = createNodeInfo((String) snmpIFOKList
					.get(i), pingPeriod, snmpPeriod,
					SnmpPreference.SNMP_LEVEL2_DESCRIPTION, snmpVersion,
					snmpROCommunity);

			if (addNodeInfo != null) {
				if (!nodeMap.containsKey((String) snmpIFOKList.get(i))) {
					nodeAddInstance.addNode(addNodeInfo, true);
				} else {
					dupicateAddressList.add((String) snmpIFOKList.get(i));
				}
			}
		}

		return dupicateAddressList;
	}

	/*
	 * m[ho^p̊Ď𐶐ĕԂ܂B
	 * 
	 * @return workNodeInfo m[ho^p̊Ď
	 */
	private NodeInformation createNodeInfo(String ipAddress, String pingPeriod,
			String snmpPeriod, String snmpLevel, int snmpVersion,
			String roCommunity) {
		NodeInformation workNodeInfo = new NodeInformation();

		workNodeInfo.setPingPeriod(pingPeriod);

		workNodeInfo
				.setPingThreshold(EditorNodeOperationInitialData.INITIAL_NODE_PING_THRESHOLD);

		workNodeInfo.setSnmpPeriod(snmpPeriod);

		workNodeInfo
				.setHttpPeriod(EditorNodeOperationInitialData.INITIAL_NODE_HTTP_PERIOD);

		workNodeInfo
				.setHttpTimeout(EditorNodeOperationInitialData.INITIAL_NODE_HTTP_TIMEOUT);

		workNodeInfo
				.setPopPeriod(EditorNodeOperationInitialData.INITIAL_NODE_POP_PERIOD);

		workNodeInfo
				.setPopPort(EditorNodeOperationInitialData.INITIAL_NODE_POP_PORT);

		workNodeInfo
				.setPopTimeout(EditorNodeOperationInitialData.INITIAL_NODE_POP_TIMEOUT);

		workNodeInfo
				.setSmtpPeriod(EditorNodeOperationInitialData.INITIAL_NODE_SMTP_PERIOD);

		workNodeInfo
				.setSmtpPort(EditorNodeOperationInitialData.INITIAL_NODE_SMTP_PORT);

		workNodeInfo
				.setSmtpTimeout(EditorNodeOperationInitialData.INITIAL_NODE_SMTP_TIMEOUT);

		workNodeInfo
				.setSmtpCheckPort(EditorNodeOperationInitialData.INITIAL_NODE_SMTP_PORT);
		workNodeInfo
				.setSmtpCheckTimeout(EditorNodeOperationInitialData.INITIAL_NODE_SMTP_TIMEOUT);

		workNodeInfo.setPopUser("");
		workNodeInfo.setPopPassword("");
		workNodeInfo.setSmtpSendAddress("");
		workNodeInfo.setSmtpCheckHost("");
		workNodeInfo.setSmtpCheckUser("");
		workNodeInfo.setSmtpCheckPassword("");

		workNodeInfo
				.setHttpUrl(EditorNodeOperationInitialData.INITIAL_NODE_HTTP_URL);

		workNodeInfo
				.setHttpPort(EditorNodeOperationInitialData.INITIAL_NODE_HTTP_PORT);

		String nodeName = null;

		try {
			InetAddress host = InetAddress.getByName(ipAddress);
			String addIPAddress = host.getHostAddress();
			workNodeInfo.setIpaddress(addIPAddress);
			nodeName = host.getHostName();
		} catch (UnknownHostException e2) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error", "UnknownHostException");
			shell.dispose();

			return null;
		}

		workNodeInfo.setNodename(nodeName);

		String engineAddress = EditorNodeOperationInitialData.INITIAL_ENGINE_ADDRESS;

		try {
			engineAddress = InetAddress.getLocalHost().getHostAddress();
		} catch (UnknownHostException e) {
			logger.warning("UnknownHostException : " + e.getMessage());
		}

		workNodeInfo.setEngineAddress(engineAddress);

		if ((nodeGroup != null) && !nodeGroup.equals("")) {
			workNodeInfo.setGroup(nodeGroup);
		} else {
			workNodeInfo
					.setGroup(EditorNodeOperationInitialData.INITIAL_NODE_GROUP);
		}

		workNodeInfo.setRoCommunity(roCommunity);
		workNodeInfo
				.setRwCommunity(EditorNodeOperationInitialData.INITIAL_NODE_SNMP_RWCOMMUNITY);

		switch (snmpVersion) {
		case 0:
			workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV1_DESCRIPTION);

			break;

		case 1:
			workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV2_DESCRIPTION);

			break;

		case 2:
			workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV3_DESCRIPTION);

			break;

		default:
			workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV1_DESCRIPTION);
		}

		if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL0_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL0_CODE_STRING);
		} else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL1_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL1_CODE_STRING);
		} else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL2_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL2_CODE_STRING);
		} else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL3_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL3_CODE_STRING);
		} else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL4_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL4_CODE_STRING);
		} else {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL0_CODE_STRING);
		}

		/*
		 * m[hʔ
		 */
		HashMap nodeKindMap = ThreadAutoNodeDetect.getInstance()
				.getNodeKindMap();
		String autoNodeKind = (String) nodeKindMap.get(ipAddress);

		if (autoNodeKind != null) {
			workNodeInfo.setNodeKind(autoNodeKind);
		} else {
			workNodeInfo.setNodeKind(nodeKind);
		}

		return workNodeInfo;
	}

	/*
	 * m[hĎ񃊃Xg擾AԂ܂B
	 */
	private HashMap getNodeList() {
		ArrayList nodeList = null;
		HashMap nodeListMap = new HashMap();

		try {
			DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
					.getInstance();
			nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);

			for (int i = 0; i < nodeList.size(); i++) {
				NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);
				String ipAddress = nodeInfo.getIpaddress();
				nodeListMap.put(ipAddress, nodeInfo);
			}
		} catch (SQLException e1) {
			logger.warning("Node List import error " + e1.getMessage());
		} catch (Exception e1) {
			logger.warning("Node List import error " + e1.getMessage());
		}

		return nodeListMap;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final NodeDetectTimerProcessor RESOURCE = new NodeDetectTimerProcessor();
	}
}
