/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.node;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.ping.PingExcecEngine;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;



/**
 * m[h̍\\ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodeConfig extends AbstractEditorNodeView {
    /** View^CgSuffix */
    public static final String TITLE_SUFFIX = " Node View";

    /** f[^\eLXg */
    public static final int DATE_TEXT_WIDTH = 250;

    /** eLXg\ */
    public static final int TEXT_WIDTH1 = 120;

    /* Scroll CompositeTCY */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 800 };

    /* Horizontal Span 3 */
    private static final int HORIZONTAL_SPAN3 = 3;

    /* Logging */
    private static Logger logger;

    /* m[hĎ */
    private NodeInformation targetNodeInfo;

    /* m[ho^\Text */
    private Text nodeRegisterDateText;

    /* m[hŐV`FbN\Text */
    private Text nodeLastCheckDateText;

    /* m[h\Text */
    private Text nodeNameText;

    /* m[hIPAhX\Text */
    private Text nodeIPAddressText;

    /* m[hO[v\Text */
    private Text nodeGroupText;

    /* m[hʕ\Text */
    private Text nodeKindText;

    /* PingĎ\Text */
    private Text pingPeriodText;

    /* PingĎ臒l\Text */
    private Text pingThresholdText;

    /* SNMPo[W\Text */
    private Text snmpVersionText;

    /* SNMPĎx\Text */
    private Text snmpLevelText;

    /* SNMPĎ\Text */
    private Text snmpPeriodText;

    /* SNMPĎReadR~jeB\Text */
    private Text snmpROCommunityText;

    /* SNMPĎWriteR~jeB\Text */
    private Text snmpRWCommunityText;

    /* HTTPĎ\Text */
    private Text httpPeriodText;

    /* HTTPĎURL\Text */
    private Text httpUrlText;

    /* HTTPĎ|[g\Text */
    private Text httpPortText;

    /* HTTPĎ^CAEgl\Text */
    private Text httpTimeoutText;

    /* Pop3Ď\Text */
    private Text pop3PeriodText;

    /* Pop3Ďڑ|[g\Text */
    private Text pop3PortText;

    /* Pop3Ďڑ^CAEgl\Text */
    private Text pop3TimeoutText;

    /* Pop3Ď[U\Text */
    private Text pop3UserText;

    /* Pop3ĎpX[h\Text */
    private Text pop3PasswordText;

    /* SMTPMeXgAhX\Text */
    private Text smtpTestAddressText;

    /* SMTPĎ\Text */
    private Text smtpPeriodText;

    /* SMTPڑ|[g\Text */
    private Text smtpPortText;

    /* SMTPڑ^CAEgl\Text */
    private Text smtpTimeoutText;

    /* SMTPmFpPop3zXg\Text */
    private Text smtpCheckPop3HostText;

    /* SMTPmFpPop3[U\Text */
    private Text smtpCheckPop3UserText;

    /* SMTPmFpPop3pX[h\Text */
    private Text smtpCheckPop3PasswordText;

    /* SMTPmFpPop3|[g\Text */
    private Text smtpCheckPop3PortText;

    /* SMTPmFpPop3^CAEgl\Text */
    private Text smtpCheckPop3TimeoutText;

    /* m[h\\XV{^ */
    private Button refreshButton;

    /* m[heLXg\BackGroundFi[ */
    private Color textBackColor;

    /**
     * EditorEBhEɃuEU\邽߂̃CX^X
     * 𐶐܂B
     *
     */
    public EditorNodeConfig() {
        logger = Logger.getLogger(this.getClass().getName());

        textBackColor = WHITE_COLOR;
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
     */
    public boolean isSaveAsAllowed() {
        return false;
    }

    /**
     * EditorEBhE𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        /* ͐ݒlm[hĎ擾 */
        EditorInputNodeView nodeViewEditorInput =
            (EditorInputNodeView) getEditorInput();
        targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        isSocket = nodeViewEditorInput.isSocket();

        if (targetNodeInfo == null) {
            logger.warning("NodeInfo null");
        }

        /*
         * ViewCAEg
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite(scrollComposite, SWT.NONE);
        composite0.setLayout(gridLayout0);
        composite0.setLayoutData(
            new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_FILL));

        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite1 = new Composite(composite0, SWT.NULL);
        composite1.setLayout(gridLayout);
        composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite1, SWT.NONE);
        label.setText("Node Register Date");
        label.setLayoutData(new GridData());
        nodeRegisterDateText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
        nodeRegisterDateText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = DATE_TEXT_WIDTH;
        nodeRegisterDateText.setLayoutData(gridData);

        // Button layout dummy
        label = new Label(composite1, SWT.NONE);
        label.setText("      ");

        /* Button */
        refreshButton = new Button(composite1, SWT.NONE);
        refreshButton.setText("Refresh");

        label = new Label(composite1, SWT.NONE);
        label.setText("Node Last Check Date");
        label.setLayoutData(new GridData());
        nodeLastCheckDateText =
            new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
        nodeLastCheckDateText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = DATE_TEXT_WIDTH;
        nodeLastCheckDateText.setLayoutData(gridData);

        GridLayout gridLayout2 = new GridLayout(5, false);
        Composite composite2 = new Composite(composite0, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        composite2.setLayout(gridLayout2);

        label = new Label(composite2, SWT.NONE);
        label.setText("Node Name");
        gridData = new GridData();
        label.setLayoutData(gridData);

        nodeNameText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        nodeNameText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeNameText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Ping");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pingPeriodText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        pingPeriodText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pingPeriodText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Node IPAddress");
        gridData = new GridData();
        label.setLayoutData(gridData);
        nodeIPAddressText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        nodeIPAddressText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeIPAddressText.setLayoutData(gridData);

        // Ping label verticalSpan dummy
        label = new Label(composite2, SWT.NONE);
        label.setText("");

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText(
            "Threshold" + "(" + PingExcecEngine.PING_RESPONSE_TIME_UNIT_MS
            + ")");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        pingThresholdText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        pingThresholdText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pingThresholdText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Group");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        nodeGroupText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        nodeGroupText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeGroupText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Snmp");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Version");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        snmpVersionText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        snmpVersionText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpVersionText.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Node Kind");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        nodeKindText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        nodeKindText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        nodeKindText.setLayoutData(gridData);

        // Snmp label verticalSpan dummy
        label = new Label(composite2, SWT.NONE);
        label.setText("");

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 4;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Level");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpLevelText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        snmpLevelText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpLevelText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpPeriodText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        snmpPeriodText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpPeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("RO Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpROCommunityText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        snmpROCommunityText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpROCommunityText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("RW Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        snmpRWCommunityText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        snmpRWCommunityText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        snmpRWCommunityText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Http");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        httpPeriodText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        httpPeriodText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        httpPeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("URL");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        httpUrlText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        httpUrlText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = EditorNodeOperation.URL_TEXT_WIDTH;
        httpUrlText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        httpPortText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        httpPortText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        httpPortText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        httpTimeoutText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        httpTimeoutText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        httpTimeoutText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Pop3");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pop3PeriodText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        pop3PeriodText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pop3PeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("User");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pop3UserText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        pop3UserText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pop3UserText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Password");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pop3PasswordText =
            new Text(composite2, SWT.PASSWORD | SWT.BORDER | SWT.READ_ONLY);
        pop3PasswordText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pop3PasswordText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pop3PortText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        pop3PortText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pop3PortText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        pop3TimeoutText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        pop3TimeoutText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        pop3TimeoutText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("SMTP");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpPeriodText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        smtpPeriodText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpPeriodText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpPortText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        smtpPortText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpPortText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpTimeoutText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        smtpTimeoutText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpTimeoutText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Address (xxx@xxx)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpTestAddressText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        smtpTestAddressText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpTestAddressText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Smtp check Pop3 Host");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpCheckPop3HostText =
            new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        smtpCheckPop3HostText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpCheckPop3HostText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Smtp check Pop3 User");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpCheckPop3UserText =
            new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        smtpCheckPop3UserText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpCheckPop3UserText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Smtp check Pop3 Password");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpCheckPop3PasswordText =
            new Text(composite2, SWT.PASSWORD | SWT.BORDER | SWT.READ_ONLY);
        smtpCheckPop3PasswordText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpCheckPop3PasswordText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Smtp check Pop3 Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpCheckPop3PortText =
            new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        smtpCheckPop3PortText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpCheckPop3PortText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Smtp check Pop3 Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        smtpCheckPop3TimeoutText =
            new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
        smtpCheckPop3TimeoutText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        smtpCheckPop3TimeoutText.setLayoutData(gridData);

        scrollComposite.setContent(composite0);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        targetNodeInfo = getNodeInformation();

        setTextNodeInfo(targetNodeInfo);

        /*
         * XV{^Xi[
         */
        refreshButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    refreshButton.setEnabled(false);

                    try {
                        /* m[hĎ擾eLXg\ */
                        targetNodeInfo = getNodeInformation();
                        setTextNodeInfo(targetNodeInfo);
                    } finally {
                        refreshButton.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /**
     * f[^x[Xm[hĎ擾ĕԂ܂B
     *
     * @return refreshNodeInfo m[hĎ
     */
    private NodeInformation getNodeInformation() {
        NodeInformation refreshNodeInfo = null;

        if (!isSocket) {
            /* f[^x[Xm[hĎ擾 */
            DBTableNodeRegister nodeRegisterDBTable =
                DBTableNodeRegister.getInstance();
            ArrayList nodeList = null;

            try {
                /* m[hĎeLXg\ */
                nodeList =
                    nodeRegisterDBTable.findTarget(
                        targetNodeInfo.getIpaddress());
                refreshNodeInfo = (NodeInformation) nodeList.get(0);
                setTextNodeInfo(refreshNodeInfo);
            } catch (SQLException e1) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node information get", e1.getMessage());
                logger.warning("Abort Node information get" + e1.getMessage());
                shell.dispose();
            } catch (Exception e1) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node information get", e1.getMessage());
                logger.warning("Abort Node information get" + e1.getMessage());
                shell.dispose();
            } finally {
                nodeRegisterDBTable = null;
            }
        } else {
            String testEngineAddress =
                ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();

            ConnectionNodeInformation connectNodeInfo =
                new ConnectionNodeInformation(testEngineAddress);

            try {
                refreshNodeInfo =
                    connectNodeInfo.getNodeInformation(
                        targetNodeInfo.getIpaddress());
                setTextNodeInfo(refreshNodeInfo);
            } catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Node List import error", e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            } catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Node List import error", e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
        }

        return refreshNodeInfo;
    }

    /*
     * w̃m[hĎeLXg\܂B
     */
    private void setTextNodeInfo(NodeInformation refreshNodeInfo) {
        if (refreshNodeInfo == null) {
            return;
        }

        if (refreshNodeInfo.getRegisterDate() != null) {
            nodeRegisterDateText.setText(refreshNodeInfo.getRegisterDate());
        }

        if (refreshNodeInfo.getLastCheck() != null) {
            nodeLastCheckDateText.setText(refreshNodeInfo.getLastCheck());
        }

        if (refreshNodeInfo.getNodename() != null) {
            nodeNameText.setText(refreshNodeInfo.getNodename());
        }

        if (refreshNodeInfo.getIpaddress() != null) {
            nodeIPAddressText.setText(refreshNodeInfo.getIpaddress());
        }

        if (refreshNodeInfo.getGroup() != null) {
            nodeGroupText.setText(refreshNodeInfo.getGroup());
        }

        if (refreshNodeInfo.getNodeKind() != null) {
            nodeKindText.setText(refreshNodeInfo.getNodeKind());
        }

        if (refreshNodeInfo.getPingPeriod() != null) {
            pingPeriodText.setText(refreshNodeInfo.getPingPeriod());
        }

        if (refreshNodeInfo.getPingThreshold() != null) {
            pingThresholdText.setText(refreshNodeInfo.getPingThreshold());
        }

        if (refreshNodeInfo.getSnmpVersion() != null) {
            snmpVersionText.setText(refreshNodeInfo.getSnmpVersion());
        }

        if (refreshNodeInfo.getSnmpLevel() != null) {
            if (
                refreshNodeInfo.getSnmpLevel().equals(
                        SnmpPreference.SNMP_LEVEL0_CODE_STRING)) {
                snmpLevelText.setText(SnmpPreference.SNMP_LEVEL0_DESCRIPTION);
            }

            if (
                refreshNodeInfo.getSnmpLevel().equals(
                        SnmpPreference.SNMP_LEVEL1_CODE_STRING)) {
                snmpLevelText.setText(SnmpPreference.SNMP_LEVEL1_DESCRIPTION);
            }

            if (
                refreshNodeInfo.getSnmpLevel().equals(
                        SnmpPreference.SNMP_LEVEL2_CODE_STRING)) {
                snmpLevelText.setText(SnmpPreference.SNMP_LEVEL2_DESCRIPTION);
            }

            if (
                refreshNodeInfo.getSnmpLevel().equals(
                        SnmpPreference.SNMP_LEVEL3_CODE_STRING)) {
                snmpLevelText.setText(SnmpPreference.SNMP_LEVEL3_DESCRIPTION);
            }

            if (
                refreshNodeInfo.getSnmpLevel().equals(
                        SnmpPreference.SNMP_LEVEL4_CODE_STRING)) {
                snmpLevelText.setText(SnmpPreference.SNMP_LEVEL4_DESCRIPTION);
            }
        }

        if (refreshNodeInfo.getSnmpPeriod() != null) {
            snmpPeriodText.setText(refreshNodeInfo.getSnmpPeriod());
        }

        if (refreshNodeInfo.getRoCommunity() != null) {
            snmpROCommunityText.setText(refreshNodeInfo.getRoCommunity());
        }

        if (refreshNodeInfo.getRwCommunity() != null) {
            snmpRWCommunityText.setText(refreshNodeInfo.getRwCommunity());
        }

        if (refreshNodeInfo.getHttpPeriod() != null) {
            httpPeriodText.setText(refreshNodeInfo.getHttpPeriod());
        }

        if (refreshNodeInfo.getHttpUrl() != null) {
            httpUrlText.setText(refreshNodeInfo.getHttpUrl());
        }

        if (refreshNodeInfo.getHttpPort() != null) {
            httpPortText.setText(refreshNodeInfo.getHttpPort());
        }

        if (refreshNodeInfo.getHttpTimeout() != null) {
            httpTimeoutText.setText(refreshNodeInfo.getHttpTimeout());
        }

        if (refreshNodeInfo.getPopPeriod() != null) {
            pop3PeriodText.setText(refreshNodeInfo.getPopPeriod());
        }

        if (refreshNodeInfo.getPopUser() != null) {
            pop3UserText.setText(refreshNodeInfo.getPopUser());
        }

        if (refreshNodeInfo.getPopPassword() != null) {
            pop3PasswordText.setText(refreshNodeInfo.getPopPassword());
        }

        if (refreshNodeInfo.getPopPort() != null) {
            pop3PortText.setText(refreshNodeInfo.getPopPort());
        }

        if (refreshNodeInfo.getPopTimeout() != null) {
            pop3TimeoutText.setText(refreshNodeInfo.getPopTimeout());
        }

        if (refreshNodeInfo.getSmtpPeriod() != null) {
            smtpPeriodText.setText(refreshNodeInfo.getSmtpPeriod());
        }

        if (refreshNodeInfo.getSmtpPort() != null) {
            smtpPortText.setText(refreshNodeInfo.getSmtpPort());
        }

        if (refreshNodeInfo.getSmtpTimeout() != null) {
            smtpTimeoutText.setText(refreshNodeInfo.getSmtpTimeout());
        }

        if (refreshNodeInfo.getSmtpSendAddress() != null) {
            smtpTestAddressText.setText(refreshNodeInfo.getSmtpSendAddress());
        }

        if (refreshNodeInfo.getSmtpCheckHost() != null) {
            smtpCheckPop3HostText.setText(refreshNodeInfo.getSmtpCheckHost());
        }

        if (refreshNodeInfo.getSmtpCheckUser() != null) {
            smtpCheckPop3UserText.setText(refreshNodeInfo.getSmtpCheckUser());
        }

        if (refreshNodeInfo.getSmtpCheckPassword() != null) {
            smtpCheckPop3PasswordText.setText(
                refreshNodeInfo.getSmtpCheckPassword());
        }

        if (refreshNodeInfo.getSmtpCheckPort() != null) {
            smtpCheckPop3PortText.setText(refreshNodeInfo.getSmtpCheckPort());
        }

        if (refreshNodeInfo.getSmtpCheckTimeout() != null) {
            smtpCheckPop3TimeoutText.setText(
                refreshNodeInfo.getSmtpCheckTimeout());
        }
    }

    /**
     * Xe[^XC\Zbg܂B
     */
    protected void setStatusLine() {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getEditorSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);
    }

}
