/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.alarm;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAllAlarm;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.AlarmViewFilter;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;



/**
 * AlarmXge[u\ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmListTableView extends AbstractTableView {
    /* A[\eLXg */
    private static final int COUNT_TEXT_WIDTH = 100;

    /* e[u\\[gɂJ0\[g */
    private static boolean isCol0Direction = false;

    /* e[u\\[gɂJ1\[g */
    private static boolean isCol1Direction = true;

    /* e[u\\[gɂJ2\[g */
    private static boolean isCol2Direction = true;

    /* e[u\\[gɂJ3\[g */
    private static boolean isCol3Direction = true;

    /* e[u\\[gɂJ4\[g */
    private static boolean isCol4Direction = true;

    /* e[uJImage܂ރJ */
    private static final int[] IMAGE_COLUMN = { 4 };

    /* MO */
    private static Logger logger = null;

    /* Table */
    private static Table table;

    /* A[\Text */
    private static Text alarmCountText;

    /* XV{^ */
    private static Button refreshButton;

    /* TableViewer */
    private static TableViewer viewer;

    /* Xe[^XC}l[W */
    private static SubStatusLineManager statusLineManager;

    /* J */
    private static final float COLUMN0NO = 0.03f;
    private static final float COLUMN1NAME = 0.1f;
    private static final float COLUMN2ADDRESS = 0.1f;
    private static final float COLUMN3REGDATE = 0.1f;
    private static final float COLUMN4MESSAGE = 0.15f;

    /* A[֘AANV */
    private AlarmAction alarmAction = new AlarmAction();

    /**
     * AlarmXge[u\ViewNXCX^X𐶐܂B
     *
     */
    public AlarmListTableView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * tH[JXZbgꂽ̏łB
     */
    public void setFocus() {
    }

    /**
     * e[uViewi\`̌ځjԂ܂B
     *
     * @return viewer TableViewer
     */
    public TableViewer getViewer() {
        return viewer;
    }

    /**
     * r[ꂽƂɂ܂sꃁ\bhłB
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        createTable(parent);
        viewer = new TableViewer(table);
        viewer.setUseHashlookup(true);

        /* ContentProviderZbg */
        viewer.setContentProvider(new AlarmListTableViewContentProvider());

        /* xEtHgȂǂݒ */
        viewer.setLabelProvider(new AlarmListTableViewLabelProvider());

        /* Contextj[Zbg */
        createContextMenu();

        /* ANVZbg */
        initActions();

        /* A[e[uZbg */
        setAlarmListTableView();
    }

    /**
     * J0iNo.j̕Ԃ܂B
     *
     * @return J0iNo.j̕
     */
    private int computeCol0Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN0NO);
    }

    /**
     * J1iNode Namej̕Ԃ܂B
     *
     * @return J1iNode Namej̕
     */
    private int computeCol1Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN1NAME);
    }

    /**
     * J2iIP Addressj̕Ԃ܂B
     *
     * @return J2iIP Addressj̕
     */
    private int computeCol2Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN2ADDRESS);
    }

    /**
     * J3iNode Register datej̕Ԃ܂B
     *
     * @return J3iNode Register datej̕
     */
    private int computeCol3Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN3REGDATE);
    }

    /**
     * J4ibZ[Wj̕Ԃ܂B
     *
     * @return J4ibZ[Wj̕
     */
    private int computeCol4Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN4MESSAGE);
    }

    /**
     * e[u𐶐܂B
     * e[ůeJwb_[̃^CgAJZbg܂B
     *
     * @param parent Composite
     */
    private void createTable(Composite parent) {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);

        int snmpPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpPort();
        statusLineManager.setMessage("Snmp Port=" + snmpPort);

        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout(gridLayout);

        /*  */
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new RowLayout(SWT.HORIZONTAL));

        GridData data = new GridData();
        data.horizontalAlignment = GridData.FILL;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData(data);

        Label labelAddress = new Label(composite, SWT.NONE);
        labelAddress.setText("Alarm count");

        alarmCountText = new Text(composite, SWT.BORDER | SWT.RIGHT);
        alarmCountText.setLayoutData(new RowData(COUNT_TEXT_WIDTH, -1));

        refreshButton = new Button(composite, SWT.NONE);
        refreshButton.setText("Refresh");

        GridData data2 = new GridData();
        data2.horizontalAlignment = GridData.FILL;
        data2.verticalAlignment = GridData.FILL;

        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;

        table =
            new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);

        table.setLayoutData(data2);

        /**
         * XV{^Xi[
         */
        refreshButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    refreshButton.setEnabled(false);

                    /* AlarmXge[uXV */
                    setAlarmListTableView();
                    refreshButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /* e[uJZbg */
        final TableColumn col0 = new TableColumn(table, SWT.CENTER);
        col0.setText(
            AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO]);
        col0.setWidth(computeCol0Width());

        final TableColumn col1 = new TableColumn(table, SWT.CENTER);
        col1.setText(
            AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE]);
        col1.setWidth(computeCol1Width());

        final TableColumn col2 = new TableColumn(table, SWT.CENTER);
        col2.setText(
            AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME]);
        col2.setWidth(computeCol2Width());

        final TableColumn col3 = new TableColumn(table, SWT.CENTER);
        col3.setText(
            AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS]);
        col3.setWidth(computeCol3Width());

        final TableColumn col4 = new TableColumn(table, SWT.CENTER);
        col4.setText(
            AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE]);
        col4.setWidth(computeCol4Width());

        /**
         * e[uړꍇ͂TCYꍇ̃Xi[łB
         *
         */
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
                  .addControlListener(
            new ControlListener() {

                public void controlMoved(ControlEvent e) {
                    // System.out.println("controlMoved");
                }

                /**
                 * e[uTCYɃe[uJZbg܂B
                 */
                public void controlResized(ControlEvent e) {
                    // System.out.println("controlResized");

                    // col0.setWidth(computeCol0Width());
                    // col1.setWidth(computeCol1Width());
                    // col2.setWidth(computeCol2Width());
                    // col3.setWidth(computeCol3Width());
                    // col4.setWidth(computeCol4Width());
                }
            });

        col0.addListener(
            SWT.Selection,
            new Listener() {
                public void handleEvent(Event e) {
                    /* J\[gA\[gێ */
                    isCol0Direction =
                        sortIntegerTable(
                            table,
                            AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO,
                            isCol0Direction, IMAGE_COLUMN);
                }
            });

        col1.addListener(
            SWT.Selection,
            new Listener() {
                public void handleEvent(Event e) {
                    /* J\[gA\[gێ */
                    isCol1Direction =
                        sortTable(
                            table,
                            AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE,
                            isCol1Direction, IMAGE_COLUMN);
                }
            });
        col2.addListener(
            SWT.Selection,
            new Listener() {
                public void handleEvent(Event e) {
                    /* J\[gA\[gێ */
                    isCol2Direction =
                        sortTable(
                            table,
                            AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME,
                            isCol2Direction, IMAGE_COLUMN);
                }
            });
        col3.addListener(
            SWT.Selection,
            new Listener() {
                public void handleEvent(Event e) {
                    /* J\[gA\[gێ */
                    isCol3Direction =
                        sortTable(
                            table,
                            AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_GROUP,
                            isCol3Direction, IMAGE_COLUMN);
                }
            });
        col4.addListener(
            SWT.Selection,
            new Listener() {
                public void handleEvent(Event e) {
                    /* J\[gA\[gێ */
                    isCol4Direction =
                        sortTable(
                            table,
                            AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS,
                            isCol4Direction, IMAGE_COLUMN);
                }
            });
    }

    /*
     *  ( Javadoc)
     * @see rctf.rssr.snmpmanager.
     * AbstractTableView#setTableItem(org.eclipse.swt.widgets.Table,
     * org.eclipse.swt.widgets.TableItem, java.lang.String[])
     */
    protected TableItem setTableItem(
        Table paraTable, TableItem item, String[] strs) {
        Object obj = item.getForeground();
        item.dispose();
        item = new TableItem(paraTable, SWT.NONE);

        item.setText(strs);
        item.setData(strs);
        item.setForeground((org.eclipse.swt.graphics.Color) obj);

        return item;
    }

    /**
     * j[o[
     * preWindowOpenɌĂ΂܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        /* ReLXgj[Zbg */
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
        manager.add(alarmAction.getActionShowAllNodeAlarmListTable());

        /* Alarme[uI񒊏o */
        if ((table.getSelectionIndex() >= 0) && (table.getSelection() != null)) {
            TableItem[] item = table.getSelection();

            String[] alarmInfo = (String[]) item[0].getData();

            /* AlarmmFANVZbg */
            ((ActionConfirmAlarm) alarmAction.getActionConfirmAlarm())
            .setConfirmAlarm(
                alarmInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO],
                alarmInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS]);
            manager.add(alarmAction.getActionConfirmAlarm());
        }

        /* SAlarmmFANVZbg */
        ((ActionConfirmAllAlarm) alarmAction.getActionConfirmAllAlarm())
        .setAlarmIPAddress(DBTableAlarm.ALL_NODE);
        manager.add(alarmAction.getActionConfirmAllAlarm());
    }

    /**
     * ContextMenu𐶐܂B
     *
     */
    private void createContextMenu() {
        /* j[}l[WZbg */
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(
            new IMenuListener() {
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        /*
         * ReLXgj[𐶐Zbg
         */
        Menu menu = mm.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        getSite().registerContextMenu(mm, viewer);
    }

    /**
     * ANV̏s܂B
     *
     */
    private void initActions() {
        IToolBarManager toolBarManager =
            getViewSite().getActionBars().getToolBarManager();

        toolBarManager.add(alarmAction.getActionShowAllNodeAlarmListTable());
    }

    /**
     * Alarm\Xge[u̕\XV܂B
     *
     */
    public void setAlarmListTableView() {
        /* e[ȗSč폜ătbV */
        table.removeAll();
        viewer.refresh();

        /* Alarm擾 */
        ArrayList alarmInfoList = getAlarmList();

        if (alarmInfoList != null) {
            /* AlarmZbg */
            alarmCountText.setText(Integer.toString(alarmInfoList.size()));
        } else {
            return;
        }

        /* AlarmXg\e[uZbg */
        for (int i = 0; i < alarmInfoList.size(); i++) {
            String[] alarmCellArray =
                new String[AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS.length];

            AlarmInformation alarmInfo =
                (AlarmInformation) alarmInfoList.get(i);

            // alarmCellArray[0] = Integer.toString(i + 1);
            alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO] =
                alarmInfo.getAlarmID();
            alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE] =
                alarmInfo.getAlarmDate();
            alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME] =
                alarmInfo.getNodename();
            alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS] =
                alarmInfo.getIpaddress();
            alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE] =
                alarmInfo.getAlarmMessage();

            TableItem item = new TableItem(table, SWT.NONE);

            item.setText(alarmCellArray);
            item.setData(alarmCellArray);

            /* AlarmxAlarm\Foreground colorZbg */
            if (alarmInfo.getAlarmLevel().equals(AlarmViewFilter.ERROR_LEVEL)) {
                item.setForeground(
                    TableListViewColor.getInstance().getAlarmErrorLevelColor());
            } else if (
                alarmInfo.getAlarmLevel().equals(AlarmViewFilter.WARNING_LEVEL)) {
                item.setForeground(
                    TableListViewColor.getInstance().getAlarmWarningLevelColor());
            } else if (
                alarmInfo.getAlarmLevel().equals(AlarmViewFilter.INFO_LEVEL)) {
                item.setForeground(
                    TableListViewColor.getInstance().getAlarmInfoLevelColor());
            } else {
                logger.warning(
                    "Unknown alarm level : " + alarmInfo.getAlarmLevel());
            }
        }
    }

    /**
     * Alarm񃊃Xgf[^x[X擾ĕԂ܂B
     *
     * @return alarmInfoList Alarm񃊃Xg
     */
    public ArrayList getAlarmList() {
        ArrayList alarmInfoList = null;
        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();

        try {
            /* A[擾 */
            alarmInfoList = alarmDBTable.findAllAlarm(0, "all", null, null);
        } catch (SQLException e) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Alarm List import error", e.getMessage());
            logger.warning("Alarm List import error " + e.getMessage());
            shell.dispose();

            return alarmInfoList;
        } catch (DatabaseConnectionException e) {
            Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Alarm List import error", e.getMessage());
            logger.warning("Alarm List import error " + e.getMessage());
            shell.dispose();

            return alarmInfoList;
        }

        return alarmInfoList;
    }

    /**
     * A[Liste[uANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class AlarmAction extends ActionBuilderAlarmList {
        /*
         *  ( Javadoc)
         * @see rctf.rssr.engine.view.model.ActionBuilderAlarmList#refreshNodeAlarmTable()
         */
        public void refreshNodeAlarmTable() {
            /* A[Liste[uXV */
            setAlarmListTableView();
        }
    }
    
    protected void setResizedTableColumnWidth() {
    }
        
}
