/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;







import java.io.IOException;

import java.net.SocketException;
import java.net.UnknownHostException;

import java.security.GeneralSecurityException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;


/**
 * wMIB OIDɂMIB̎sÃf[^ɕϊ郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibGetNextInfo {
    // MO
    private static Logger logger = null;

    /**
     * MIB̎ێzTCY
     * mib[0] : MIB
     * mib[1] : OID
     * mib[2] : MIBl
     * mib[3] : Type
     * mib[4] : Access
     *
     */
    public static final int MIB_ARRAY = 5;
    /** MIB Descriptioni[zԍ */
    public static final int MIB_DESCRIPTION_POS = 0;

    /** MIB Descriptioni[zԍ */
    public static final int MIB_OID_POS = 1;
    /** MIB Valuei[zԍ */
    public static final int MIB_VALUE_POS = 2;
    /** MIB Typei[zԍ */
    public static final int MIB_TYPE_POS = 3;
    /** MIB Accessi[zԍ */
    public static final int MIB_ACCESS_POS = 4;

    // ^[QbgƂȂm[hIPAhX
    private String targetIP;

    /* Snmp ManagerfBXpb`[NXCX^X  */
    private ManagerDispatcher dispacher;

    /* Snmp Version */
    private int version;

    /* MIB`Map */
    private HashMap oidTreeMap = ManagerMibTree.getInstance().getOidHashMap();

    /**
     * MIB̎NXCX^X𐶐܂B
     *
     * @throws SocketException SocketɎsꍇ
     */
    protected MibGetNextInfo() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());

        /* Dispacher */
        dispacher = new ManagerDispatcher();
    }

    /**
     * MIB̎CX^XɃvpeBZbg܂B
     *
     * @param targetIPAddress ^[QbgAhX
     * @param version SNMPo[W
     * @param community R~jeB
     * @throws UnknownHostException MzXgsȏꍇ
     */
    public void setMibGetNext(
        String targetIPAddress, int version, String community)
        throws UnknownHostException {
        this.targetIP = targetIPAddress;
        this.version = version;

        /* SNMP Manager DispatcherZbg */
        dispacher.setManagerDispatcher(targetIPAddress, community, version);
    }

    /**
     * wOIDɂMIB̎悵AɕϊĕԂ܂B
     *
     * @param requestOid NGXgOID
     * @return responseSnmpValueString f[^
     * @throws SnmpUnmuchRequestIDException NGXgIDҒlƃA}b`̏ꍇ
     * @throws SnmpUnmuchRequestMsgIDException nsgIDҒlƃA}b`̏ꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpMIBGetException MIB̎悪sꍇ
     * @throws SnmpSetException SetRequestsꍇ
     * @throws SnmpConfigurationException SNMP\񂪈ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     * @throws SnmpBadValueException f[^͂ňُ킪ꍇ
     * @throws IOException f[^MɎsꍇ
     */
    public String getMibValueString(String requestOid)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpErrorStatusException, 
            SnmpMIBGetException, SnmpSetException, SnmpConfigurationException, 
            SnmpV3ConfigurationException, SnmpBadValueException, IOException {
        String responseSnmpValueString = "Abort mib get";

        SnmpVarBindList newVars =
            dispacher.dispathGetMessage(
                version, SnmpBERCodec.SNMPGETNEXTREQUEST, requestOid);

        // SNMPVarBindList newVars = comInterface.getNextMIBEntry(oid);
        // SNMPVarBindList newVars = comInterface.getMIBEntry(itemID);
        if (newVars != null) {
            SnmpSequence pair = (SnmpSequence) (newVars.getSNMPObjectAt(0));
            SnmpObjectIdentifier snmpOID =
                (SnmpObjectIdentifier) pair.getSNMPObjectAt(0);

            AbstractSnmpObject snmpValue = pair.getSNMPObjectAt(1);
            responseSnmpValueString = snmpValue.toString();

            if (version == SnmpPreference.SNMPV3) {
                String reportOID =
                    checkReportOID(snmpOID.toString(), responseSnmpValueString);

                if (!reportOID.equals("")) {
                	/*
                	 * f[^|[gOID
                	 */
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPV3ReportOID(
                        targetIP, snmpOID.toString(), reportOID,
                        responseSnmpValueString);
                    logger.warning(reportOID + "=" + responseSnmpValueString);

                    throw new SnmpMIBGetException("Response is report OID " + reportOID + "=" + responseSnmpValueString);
                }
            }

            /*
             * OctetString typȅꍇAAgentɂẮAŌnull
             * tĂ肱ꂪf[^x[XANZXɈe
             * yڂ߂ɏ
             */
            int nullLocation = responseSnmpValueString.indexOf('\0');

            if (nullLocation >= 0) {
                responseSnmpValueString =
                    responseSnmpValueString.substring(0, nullLocation);
            }
        }

        return responseSnmpValueString;
    }

    /**
     * wOIDɑΉMIB̎悵A
     * ̎悵ȉ̏ArrayListɊi[ĕԂ܂B
     *
     * EMIB
     * EOID
     * EType
     * EValue
     * ENext OID
     * EAccess
     *
     * MIb GetNextŊOID܂܂ȂȂ_ŏI܂B
     * OID܂܂Ȃ܂MIBArrayListɊi[܂B
     *
     * @param oid ̎OID
     * @return mibvaluesList ̎MIBlMibValueNXCX^XƂĊi[ArrayList
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     */
    public ArrayList getNextMibValueList(String oid) throws SnmpMIBGetException {
        ArrayList getNextMibValuesList = new ArrayList();

        String firstOid = oid;
        String retrievedOID = oid;

        SnmpVarBindList newVars = null;

        try {
            // ̎OIDKwłȂȂ܂Ń[v
            while (true) {
                newVars =
                    dispacher.dispathGetMessage(
                        version, SnmpBERCodec.SNMPGETNEXTREQUEST, retrievedOID);

                // MIB OID̎s
                // newVars = comInterface.getNextMIBEntry(retrievedID);
                SnmpSequence pair = (SnmpSequence) (newVars.getSNMPObjectAt(0));
                SnmpObjectIdentifier getNextOID =
                    (SnmpObjectIdentifier) pair.getSNMPObjectAt(0);

                AbstractSnmpObject snmpObject = pair.getSNMPObjectAt(1);

                String typeString = snmpObject.getTagCode();

                /*
                 * SnmpV3̏ꍇɃG[WFg̉|[gOID
                 * ̃`FbNs
                 */
                if (version == SnmpPreference.SNMPV3) {
                    String reportOID =
                        checkReportOID(
                            getNextOID.toString(), snmpObject.toString());

                    if (!reportOID.equals("")) {
                        AlarmMessageMake message =
                            AlarmMessageMake.getInstance();
                        message.setErrorSNMPV3ReportOID(
                            targetIP, getNextOID.toString(), reportOID,
                            snmpObject.toString());

                        /*
                             * |[gOID̏ꍇɂ́AvJEg
                             * yLog̎悵nullԂ
                             */
                        logger.warning(reportOID + "=" + snmpObject.toString());

                        return null;
                    }
                }

                /*
                 *
                 */
                if ((getNextOID.toString()).indexOf(firstOid) < 0) {
                    break;
                }

                // GetMibConvert mib_convert = GetMibConvert.getInstance();
                MibValue mibvalue =
                    this.valueConvert(
                        retrievedOID, typeString, snmpObject,
                        getNextOID.toString());

                getNextMibValuesList.add(mibvalue);
                retrievedOID = getNextOID.toString();
            }
        } catch (SnmpV3AuthAbortException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        } catch (SnmpV3DecryptAbortException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        } catch (SnmpV3ConfigurationException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        } catch (SnmpMIBGetException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        } catch (SnmpSetException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        } catch (Exception e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        }

        return getNextMibValuesList;
    }

    /**
     * OID|[gOID`FbNA|[gOID̏ꍇɂ͓v
     * JEgAOID DescriptionԂ܂B
     *
     * @param checkOID OID
     * @param value |[gOID̏ꍇ̃JEgl
     * @return oidDescription |[gOID̏ꍇDescription
     */
    public String checkReportOID(String checkOID, String value) {
        String reportOidDescription = "";

        try {
            if (checkOID.equals(SnmpPreference.UNSUPPORTED_SECURITY_LEVEL)) {
                reportOidDescription =
                    SnmpPreference.UNSUPPORTED_SECURITY_LEVEL_DESCRIPTION;
                SnmpV3UsmStatisticsManager.getInstance()
                                          .setUsmStatsUnsupportedSecLevels(
                    targetIP, Integer.parseInt(value));
            } else if (checkOID.equals(SnmpPreference.NOT_IN_TIME_PACKET)) {
                reportOidDescription =
                    SnmpPreference.NOT_IN_TIME_PACKET_DESCRIPTION;
                SnmpV3UsmStatisticsManager.getInstance()
                                          .setUsmStatsNotInTimeWindows(
                    targetIP, Integer.parseInt(value));
            } else if (checkOID.equals(SnmpPreference.UNKNOWN_USER_NAME)) {
                reportOidDescription =
                    SnmpPreference.UNKNOWN_USER_NAME_DESCRIPTION;
                SnmpV3UsmStatisticsManager.getInstance()
                                          .setUsmStatsUnknownUserNames(
                    targetIP, Integer.parseInt(value));
            } else if (checkOID.equals(SnmpPreference.UNKNOWN_ENGINE_ID)) {
                reportOidDescription =
                    SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION;
                SnmpV3UsmStatisticsManager.getInstance()
                                          .setUsmStatsUnknownEngineIDs(
                    targetIP, Integer.parseInt(value));
            } else if (checkOID.equals(SnmpPreference.WRONG_DIGEST)) {
                reportOidDescription = SnmpPreference.WRONG_DIGEST_DESCRIPTION;
                SnmpV3UsmStatisticsManager.getInstance()
                                          .setUsmStatsWrongDigests(
                    targetIP, Integer.parseInt(value));
            } else if (checkOID.equals(SnmpPreference.DECRYPTION_ERROR)) {
                reportOidDescription =
                    SnmpPreference.DECRYPTION_ERROR_DESCRIPTION;
                SnmpV3UsmStatisticsManager.getInstance()
                                          .setUsmStatsDecryptionErrors(
                    targetIP, Integer.parseInt(value));
            }
        } catch (NumberFormatException e) {
            logger.warning(checkOID + value);
        }

        return reportOidDescription;
    }

    /**
     * MIB̎CX^XClose܂B
     *
     */
    public void closedMibGetNext() {
        dispacher.closeConnection();
    }

    /**
     * ̎MIB OIDȂǂStringɕϊƂƂOIDMIB`ɂMIB Description
     * MibValueCX^XɊi[܂B
     *
     * @param oid OID
     * @param type OID^Cv
     * @param snmpValue SNMPIuWFNg
     * @param oidNext Next OID
     * @return MibValue
     */
    public MibValue valueConvert(
        final String oid, final String type, final AbstractSnmpObject snmpValue,
        final String oidNext) {
        String[] mib = new String[MIB_ARRAY];

        /*
         * MIB Type (OctetString or Other)
         * OctetString typȅꍇAAgentɂẮAŌnull
         * tĂ肱ꂪf[^x[XANZXɈe
         * yڂ߂ɏ
         */
        if (type.indexOf(SnmpBERCodec.SNMPOCTETSTRING) >= 0) {
            String snmpString = snmpValue.toString();

            // truncate at first null character
            int nullLocation = snmpString.indexOf('\0');

            if (nullLocation >= 0) {
                snmpString = snmpString.substring(0, nullLocation);
            }

            /* 
             * mib[0] : MIB
             * mib[1] : OID
             * mib[2] : MIBl
             * mib[3] : Type
             * mib[4] : Access
             *
             */
            mib[MIB_OID_POS] = oidNext;
            mib[MIB_VALUE_POS] = snmpString;
            mib[MIB_TYPE_POS] = type;

            /* 
             * OID̍Ōォŏ.ʒu𒊏o
             */
            String searchOid = oidNext;
            mib[MIB_DESCRIPTION_POS] = "unknown";
            mib[MIB_ACCESS_POS] = "n";

            /* 
             * oidkeyƂHashMap
             * key݂Ȃ΁Aoid̒ZčēxAkey݃`FbN
             * key݂܂oid̒ZĂ
             * key݂΂ɂHashMap MIB Nameget
             */
            for (int i = 0; i < oid.length(); i++) {
                if (oidTreeMap.containsKey(searchOid)) {
                    MibInfo miboid = (MibInfo) oidTreeMap.get(searchOid);
                    mib[MIB_DESCRIPTION_POS] =
                        miboid.getDescrip()
                        + mib[MIB_OID_POS].substring(
                            miboid.getOid().length(), mib[MIB_OID_POS].length());
                    mib[MIB_ACCESS_POS] = miboid.getAccess();

                    break;
                }

                // searchOid = mib[1].substring(0, oidworkPos - i);
                int checkOidPos = searchOid.lastIndexOf(".");

                if (checkOidPos >= 0) {
                    searchOid = searchOid.substring(0, checkOidPos);
                } else {
                    break;
                }
            }
        } else {
        	 // OcteteStringȊOMIB Type
            mib[MIB_OID_POS] = oidNext;
            mib[MIB_VALUE_POS] = snmpValue.toString();
            mib[MIB_TYPE_POS] = type;

            String searchOid = oidNext;

            mib[MIB_DESCRIPTION_POS] = "unknown";
            mib[MIB_ACCESS_POS] = "n";

            for (int i = 0; i < oid.length(); i++) {
                if (oidTreeMap.containsKey(searchOid)) {
                    MibInfo miboid = (MibInfo) oidTreeMap.get(searchOid);
                    mib[MIB_DESCRIPTION_POS] =
                        miboid.getDescrip()
                        + mib[MIB_OID_POS].substring(
                            miboid.getOid().length(), mib[MIB_OID_POS].length());
                    mib[MIB_ACCESS_POS] = miboid.getAccess();

                    break;
                }

                int checkOidPos = searchOid.lastIndexOf(".");

                if (checkOidPos >= 0) {
                    searchOid = searchOid.substring(0, checkOidPos);
                } else {
                    break;
                }
            }
        }

        /*  */
        MibValue mibvalue =
            MibValueQueue.getInstance().popMibValueQueue(targetIP + oid);
        mibvalue.setMibValue(
            mib[MIB_DESCRIPTION_POS], oidNext, mib[MIB_TYPE_POS],
            mib[MIB_VALUE_POS], oidNext, mib[MIB_ACCESS_POS]);

        return mibvalue;
    }
}
