/*
 * Created on 2004/10/19
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import netjfwatcher.snmp.messageformat.SnmpVarBindList;


/**
 * snmpV3G[WFgf[^ێNXłB
 * snmpV3f[^͂ăZbg܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ManagerV3MessageInfo {
    /* msgo[W */
    private int msgVersion;

    /* msgID */
    private int msgID;

    /* msgMaxSize */
    private int msgMaxSize;

    /* msgFlags */
    private String msgFlags;

    /* msgSecurityModel */
    private int msgSecurityModel;

    /* msgAuthoritative EngineID */
    private String msgAuthoritativeEngineID;

    /* msgAuthoritative Boots */
    private int msgAuthoritativeBoots;

    /* msgAuthoritative EngineTime */
    private int msgAuthoritativeEngineTime;

    /* msgUserName */
    private String msgUserName;

    /* context EngineID */
    private String contextEngineID;

    /*  */
    private String contextName;

    /* SNMPVarBindList */
    private SnmpVarBindList retrievedVars;

    /**
     * Context-EngineIDԂ܂B
     *
     * @returnv contextEngineID Context-EngineID
     */
    public String getContextEngineID() {
        return contextEngineID;
    }

    /**
     * Context-NameԂ܂B
     *
     * @return contextName Context-Name
     */
    public String getContextName() {
        return contextName;
    }

    /**
     * msgAuthoritativeBootsԂ܂B
     *
     * @return msgAuthoritativeBoots msgAuthoritativeBoots
     */
    public int getMsgAuthoritativeBoots() {
        return msgAuthoritativeBoots;
    }

    /**
     * msgAuthoritativeEngineIDԂ܂B
     *
     * @return msgAuthoritativeEngineID msgAuthoritativeEngineID
     */
    public String getMsgAuthoritativeEngineID() {
        return msgAuthoritativeEngineID;
    }

    /**
     * msgAuthoritativeEngineTimeԂ܂B
     *
     * @return msgAuthoritativeEngineTime msgAuthoritativeEngineTime
     */
    public int getMsgAuthoritativeEngineTime() {
        return msgAuthoritativeEngineTime;
    }

    /**
     * msgFlagsԂ܂B
     *
     * @return msgFlags msgFlags
     */
    public String getMsgFlags() {
        return msgFlags;
    }

    /**
     * msgIDԂ܂B
     *
     * @return msgID msgID
     */
    public int getMsgID() {
        return msgID;
    }

    /**
     * msgMaxSizeԂ܂B
     *
     * @return msgMaxSize msgMaxSize
     */
    public int getMsgMaxSize() {
        return msgMaxSize;
    }

    /**
     * msgSecurityModelԂ܂B
     *
     * @return msgSecurityModel
     */
    public int getMsgSecurityModel() {
        return msgSecurityModel;
    }

    /**
     * msgUserNameԂ܂B
     *
     * @return msgUserName
     */
    public String getMsgUserName() {
        return msgUserName;
    }

    /**
     * msgVersionԂ܂B
     *
     * @return msgVersion
     */
    public int getMsgVersion() {
        return msgVersion;
    }

    /**
     * retrievedVarsԂ܂B
     *
     * @return retrievedVars
     */
    public SnmpVarBindList getRetrievedVars() {
        return retrievedVars;
    }

    /**
     * ContextEngineIDZbg܂B
     *
     * @param string ContextEngineID
     */
    public void setContextEngineID(String string) {
        contextEngineID = string;
    }

    /**
     * contextNameZbg܂B
     *
     * @param string contextName
     */
    public void setContextName(String string) {
        contextName = string;
    }

    /**
     * MsgAuthoritativeBootsZbg܂B
     *
     * @param i MsgAuthoritativeBoots
     */
    public void setMsgAuthoritativeBoots(int i) {
        msgAuthoritativeBoots = i;
    }

    /**
     * msgAuthoritativeEngineIDZbg܂B
     *
     * @param string msgAuthoritativeEngineID
     */
    public void setMsgAuthoritativeEngineID(String string) {
        msgAuthoritativeEngineID = string;
    }

    /**
     * MsgAuthoritativeEngineTimeZbg܂B
     *
     * @param i MsgAuthoritativeEngineTime
     */
    public void setMsgAuthoritativeEngineTime(int i) {
        msgAuthoritativeEngineTime = i;
    }

    /**
     * MsgFlagsZbg܂B
     *
     * @param string MsgFlags
     */
    public void setMsgFlags(String string) {
        msgFlags = string;
    }

    /**
     * MsgIDZbg܂B
     *
     * @param i MsgID
     */
    public void setMsgID(int i) {
        msgID = i;
    }

    /**
     * MsgMaxSizeZbg܂B
     *
     * @param i MsgMaxSize
     */
    public void setMsgMaxSize(int i) {
        msgMaxSize = i;
    }

    /**
     * MsgSecurityModelZbg܂B
     *
     * @param i MsgSecurityModel
     */
    public void setMsgSecurityModel(int i) {
        msgSecurityModel = i;
    }

    /**
     * MsgUserNameZbg܂B
     *
     * @param string MsgUserName
     */
    public void setMsgUserName(String string) {
        msgUserName = string;
    }

    /**
     * MsgVersionZbg܂B
     *
     * @param i MsgVersion
     */
    public void setMsgVersion(int i) {
        msgVersion = i;
    }

    /**
     * SNMPVarBindListZbg܂B
     *
     * @param list SNMPVarBindList
     */
    public void setRetrievedVars(SnmpVarBindList list) {
        retrievedVars = list;
    }
}
