/*
 * Created on 2004/09/28
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmMessageResource;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;


/**
 * SNMP V1/V2/V3}l[W̋ʏ钊ۃNXłB
 *
 * (1) SNMP\Pbg^CAEgAgC񐔂̐ݒ
 * (2) ^[Qbg̃G[WFgAhXɑΉG[WFg̒o
 * (3) G[WFg̉f[^̉
 *
 * ADatagramSocketClose͏ʑŎs܂B
 * ́AMIB̎ɂāAMIB OID܂Ń[vɂČJԂ
 * s߂łB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractManagerMessageProcessingSubsystem
    extends DataStringDisplay {
    /** RequestIDA}b`̃gC wait^C}[ */
    public static final int UNMUCH_REQUEST_ID_RETRY_WAIT_TIME = 3000;

    /** f[^Mobt@TCY */
    public static final int MAXSIZE = 8196;

    /* MO */
    private static Logger logger;

    /** SNMP|[gԍ */
    protected int snmpPort;

    /** SNMP^[Qbg(Agent)AhX */
    protected InetAddress targetAddress;

    /** SNMPMDatagramSocket */
    protected DatagramSocket dSocket;

    /** SNMP V3Ǘ */
    protected SnmpV3ManagerConfigInfo snmpV3ManagerConfInfo;

    /** SNMP V3ɂ郆[U */
    protected String snmpV3UserName;

    /** SNMPgC */
    protected int retryCounter;

    /** SNMPgC */
    protected int retryResourceCounter;

    /** SNMPo[W */
    protected int version;

    /** SNMP Community */
    protected String community;

    /** SNMPMbZ[Wp̃NXCX^X */
    protected SnmpManagerCreateSendMessage messageSendInstance =
        new SnmpManagerCreateSendMessage();

    /** SNMPMf[^͗p̃NXCX^X */
    protected SnmpManagerMessageReceive messageReceiveInstance =
        new SnmpManagerMessageReceive();

    /**
     * SNMP V1/V2/V3}l[W̋ʏ钊ۃNX
     * ܂B
     */
    public AbstractManagerMessageProcessingSubsystem() {
        logger = Logger.getLogger(this.getClass().getName());

        /* Snmp Portԍ\[X񂩂擾 */
        snmpPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpPort();
    }

    /**
     * SNMP}l[W Message proccessingZbg܂B
     *
     * @param dSocket DatagramSocket
     * @param hostAddress m[hIPAhX
     * @param community R~jeB
     * @throws SnmpConfigurationException SNMP\񂪈ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     */
    public abstract void setManagerMP(
        DatagramSocket dSocket, InetAddress hostAddress, String community)
        throws SnmpConfigurationException, SnmpV3ConfigurationException;

    /**
     * SNMP V1/V2C/V3n̊eo[WɑΉSNMP Socket^CAEgl
     * yуgC񐔂ݒ肵܂B
     * ܂ASNMP V3ł̃[Uݒ肵܂B
     *
     * @param dSocket DatagramSocket
     * @param hostAddress m[hIPAhX
     * @throws SnmpConfigurationException SNMP\񂪈ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     */
    protected void setConfig(DatagramSocket dSocket, InetAddress hostAddress)
        throws SnmpConfigurationException, SnmpV3ConfigurationException {
        /*
         * Socket TimeoutyуgC񐔂\[Xǂݍ
         * ZbgOɃftHglZbg
         */
        int socketTimeout = SnmpPreference.SNMP_MANAGER_SOCKET_TIMEOUT;
        retryResourceCounter = SnmpPreference.SNMP_MANAGER_SOCKET_RETRY;

        String socketTimeoutString = "";
        String snmpRetryString = "";

        /*
         * Snmpo[WɑΉTimeoutlyуgC񐔂Zbg
         */
        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:
            socketTimeoutString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV1Timeout();
            snmpRetryString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV1Retry();

            break;

        case SnmpPreference.SNMPV2C:
            socketTimeoutString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV2Timeout();
            snmpRetryString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV2Retry();

            break;

        case SnmpPreference.SNMPV3:
            socketTimeoutString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV3Timeout();
            snmpRetryString =
                SystemResourceConfig.getInstance().getResourceFileParse()
                                    .getResourceInfo().getSnmpV3Retry();

            break;

        default:
            logger.warning("Illegal SNMP Version " + version);
        }

        /*
         * SNMP Socket Timeoutݒ
         */
        try {
            socketTimeout = Integer.parseInt(socketTimeoutString);
        } catch (NumberFormatException e1) {
            /* SNMP Socket Timeoutݒُ */
            logger.warning(
                "Snmp socket timeout set error" + " at value="
                + socketTimeoutString);
            throw new SnmpConfigurationException(
                "Snmp socket timeout set error" + " at value="
                + socketTimeoutString);
        }

        try {
            dSocket.setSoTimeout(socketTimeout);
        } catch (SocketException e) {
            /* SNMP Socket Timeoutݒُ */
            e.printStackTrace();
            logger.warning("Snmp socket set timeout : " + e.getMessage());
            throw new SnmpConfigurationException(
                "Snmp socket set timeout : " + e.getMessage());
        }

        /*
         * SNMP Retry񐔐ݒ
         */
        try {
            retryResourceCounter = Integer.parseInt(snmpRetryString);
        } catch (NumberFormatException e) {
            /* SNMP Retry񐔐ݒُ */
            logger.warning("Socket retry set error. value=" + snmpRetryString);
            throw new SnmpConfigurationException(
                "Socket retry set error. value=" + snmpRetryString);
        }

        /*
         * Snmp V3̏ꍇA[UNXCX^X̃G[WFg
         * Ǘɐݒ
         */
        if (version == SnmpPreference.SNMPV3) {
            /*
             * ^[QbgIPAhXSnmp V3 User nameo
             */
            snmpV3ManagerConfInfo =
                SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                                   .getSnmpV3AgentInfo(
                    hostAddress.getHostAddress());

            if (snmpV3ManagerConfInfo != null) {
                snmpV3UserName =
                    ((SnmpV3ManagerUserConfigInfo) snmpV3ManagerConfInfo.getUserList()
                                                                        .get(0))
                    .getUsername();

                String paddingZero =
                    snmpV3ManagerConfInfo.getAsn1BerZeroPadding();

                if (
                    paddingZero.equals("yes") || paddingZero.equals("YES")
                        || paddingZero.equals("Yes")) {
                    // System.out.println("setZeroPadding(true) : " + paddingZero);
                    AbstractSnmpObject.setZeroPadding(true);
                } else {
                    /* System.out.println(
                        "setZeroPadding(false) : " + paddingZero);
                    */
                    AbstractSnmpObject.setZeroPadding(false);
                }
            } else {
                logger.warning(
                    "Agent not found address : " + hostAddress.getHostAddress());
                throw new SnmpV3ConfigurationException(
                    "Agent not found address : " + hostAddress.getHostAddress());
            }
        }
    }

    /**
     * Get RequestyGetNext RequestR}hs\bhłB
     *
     * @param code R}hR[h
     * @param requestOID OID
     * @return SnmpVarBindList
     * @throws SnmpUnmuchRequestIDException NGXgIDҒlƈvȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDҒlƈvȂꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpMIBGetException MIB̎悪sꍇ
     * @throws SnmpSetException Set Requestsꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     * @throws IOException f[^Msꍇ
     */
    abstract public SnmpVarBindList getProcess(byte code, String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpBadValueException, 
            SnmpV3DecryptAbortException, SnmpV3AuthAbortException, 
            SnmpErrorStatusException, SnmpMIBGetException, SnmpSetException, 
            SnmpV3ConfigurationException, IOException;

    /**
     * Set RequestR}hs\bhłB
     *
     *
     * @param code R}hR[h
     * @param requestOID OID
     * @param newValue ZbgSNMPIuWFNg
     * @return SnmpVarBindList
     * @throws SnmpUnmuchRequestIDException NGXgIDA}b`ȏꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDA}b`ȏꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XŐłȂꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpBadValueException f[^܂͉͂Ɏsꍇ
     * @throws SnmpSetException SetRequestňُ킪ꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     * @throws IOException f[^M܂͎Msꍇ
     */
    abstract public SnmpVarBindList setProcess(
        byte code, String requestOID, AbstractSnmpObject newValue)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpErrorStatusException, 
            SnmpMIBGetException, SnmpSetException, SnmpV3ConfigurationException, 
            IOException, SnmpBadValueException;

    /**
     * GetRequestR}hs܂B
     *
     * @param requestOID OID
     * @return SnmpVarBindList
     * @throws SnmpUnmuchRequestIDException NGXgIDA}b`ȏꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDA}b`ȏꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XŐłȂꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpBadValueException f[^܂͉͂Ɏsꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     * @throws IOException f[^M܂͎Msꍇ
     */
    public abstract SnmpVarBindList getMIBEntry(String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpBadValueException, 
            SnmpMIBGetException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpV3ConfigurationException, 
            SnmpErrorStatusException, IOException;

    /**
     * Get Next Requests܂B
     *
     * @param requestOID OID
     * @throws SnmpUnmuchRequestIDException NGXgIDA}b`ȏꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDA}b`ȏꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XŐłȂꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpBadValueException f[^܂͉͂Ɏsꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     * @throws IOException f[^M܂͎Msꍇ
     * @return SnmpVarBindList Agent SNMP varBindList
     */
    public abstract SnmpVarBindList getNextMIBEntry(String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpErrorStatusException, 
            SnmpMIBGetException, SnmpBadValueException, 
            SnmpV3ConfigurationException, IOException;

    /**
     * SNMP Set Requests܂B
     *
     * @param requestOID OID
     * @param newValue SetSNMPIuWFNg
     * @return SnmpVarBindList
     * @throws SnmpUnmuchRequestIDException NGXgIDA}b`ȏꍇ
     * @throws SnmpUnmuchRequestMsgIDException msgIDA}b`ȏꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException f[^ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException F؂ňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XŐłȂꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpBadValueException f[^܂͉͂Ɏsꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
     * @throws IOException f[^M܂͎Msꍇ
    */
    public abstract SnmpVarBindList setMIBEntry(
        String requestOID, AbstractSnmpObject newValue)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpErrorStatusException, 
            SnmpBadValueException, SnmpSetException, SnmpMIBGetException, 
            SnmpV3DecryptAbortException, SnmpV3AuthAbortException, 
            SnmpV3ConfigurationException, IOException;

    /**
     *
     *
     * @param requestID NGXgID
     * @param requestOID OID
     * @param messageEncoding oCgz
     * @param dSocket DatagramSocket
     * @return SnmpVarBindList
     * @throws SnmpUnmuchRequestIDException NGXgIDA}b`ȏꍇ
     * @throws SnmpErrorStatusException G[Xe[^XŐłȂꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     * @throws SnmpBadValueException f[^܂͉͂Ɏsꍇ
     * @throws IOException f[^M܂͎Msꍇ
     */
    protected SnmpVarBindList sendAndReceive(
        int requestID, String requestOID, byte[] messageEncoding,
        DatagramSocket dSocket)
        throws SnmpUnmuchRequestIDException, SnmpErrorStatusException, 
            SnmpMIBGetException, SnmpBadValueException, NoRouteToHostException, 
            SocketTimeoutException, IOException {
        SnmpVarBindList retrievedVars = null;
        retryCounter = retryResourceCounter;

        while (true) {
            try {
                messageReceiveInstance.setSnmpReceiveSocket(
                    targetAddress, dSocket);
                this.sendByteDataToAgent(messageEncoding, requestOID, dSocket);
                retrievedVars =
                    messageReceiveInstance.parseReceiveData(
                        requestID, requestOID, dSocket);

                int socketTimeout = dSocket.getSoTimeout();

                if (
                    AlarmRecovery.getInstance().isOccurredAlarmId(
                            targetAddress.getHostAddress(),
                            AlarmMessageResource.SNMP_GET_TIMEOUT)) {
                    /* Zbg */
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setRecoverySNMPTimeout(
                        targetAddress.getHostAddress(), requestOID,
                        socketTimeout);
                }

                if (
                    AlarmRecovery.getInstance().isOccurredAlarmId(
                            targetAddress.getHostAddress(),
                            AlarmMessageResource.SNMP_NO_ROUTE_TOHOST)) {
                    /* Ping臒lI[o[Zbg */
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setRecoverySNMPNoRouteToHost(
                        targetAddress.getHostAddress(), requestOID);
                }

                if (
                    AlarmRecovery.getInstance().isOccurredAlarmId(
                            targetAddress.getHostAddress(),
                            AlarmMessageResource.SNMP_IOEXCEPTION)) {
                    /* IOExceptionZbg */
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setRecoverySNMPIOException(
                        targetAddress.getHostAddress(), requestOID);
                }

                break;
            } catch (SnmpUnmuchRequestIDException e1) {
                retryCounter--;
                logger.info(
                    "SnmpUnmuchRequestIDException Retry : " + retryCounter);

                if (retryCounter <= 0) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();

                    message.setErrorSNMPUnmuchRequestID(
                        targetAddress.getHostAddress(), e1.getMessage());

                    throw e1;
                }

                try {
                    Thread.sleep(UNMUCH_REQUEST_ID_RETRY_WAIT_TIME);
                } catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            } catch (NoRouteToHostException e) {
                /*
                * NoRouteToHostExceptioñA[
                * bZ[WA[L[Put
                */
                AlarmMessageMake message = AlarmMessageMake.getInstance();
                message.setErrorSNMPNoRouteToHost(
                    targetAddress.getHostAddress(), requestOID);

                logger.warning(
                    "NoRouteToHostException " + e.getMessage() + " : "
                    + targetAddress.getHostAddress() + " : " + requestOID);

                throw new NoRouteToHostException(
                    "Target IP=" + targetAddress.getHostAddress() + " OID="
                    + requestOID + " : " + e.getMessage());
            } catch (SocketTimeoutException e1) {
                SnmpStatisticsManager.getInstance().addSnmpSocketTimeout(
                    targetAddress.getHostAddress());
                retryCounter--;
                logger.info("Socket Timeout Exception Retry : " + retryCounter);

                try {
                    logger.info("Timeout : " + dSocket.getSoTimeout());
                } catch (SocketException e) {
                    logger.warning(
                        e.getMessage() + " Socket Timeout Exception Retry : "
                        + retryCounter);
                    e.printStackTrace();
                    throw new SnmpMIBGetException(e.getMessage());
                }

                if (retryCounter <= 0) {
                    /*
                     * SNMP TimeoutꍇɃA[
                     * bZ[WA[L[Put
                     */
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPTimeout(
                        targetAddress.getHostAddress(), requestOID,
                        dSocket.getSoTimeout());

                    logger.warning(
                        e1.getMessage() + " : "
                        + targetAddress.getHostAddress() + " : " + requestOID);
                    throw new SocketTimeoutException(
                        e1.getMessage() + " : IP="
                        + targetAddress.getHostAddress() + " : OID="
                        + requestOID);
                }
            } catch (SnmpBadValueException e) {
                retryCounter--;
                logger.info("SNMPBadValueException Retry : " + retryCounter);

                try {
                    logger.info("Timeout : " + dSocket.getSoTimeout());
                } catch (SocketException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                    throw new SnmpBadValueException(e1.getMessage());
                }

                if (retryCounter <= 0) {
                    logger.warning(
                        e.getMessage() + " : " + targetAddress.getHostAddress()
                        + " : " + requestOID);
                    e.printStackTrace();

                    throw new SnmpBadValueException(e.getMessage());
                }
            } catch (IOException e2) {
                AlarmMessageMake message = AlarmMessageMake.getInstance();
                message.setErrorSNMPIOException(
                    targetAddress.getHostAddress(), requestOID, e2.getMessage());

                logger.warning(
                    "IOException " + e2.getMessage() + " : "
                    + targetAddress.getHostAddress() + " : " + requestOID);
                throw new IOException(
                    "Target IP=" + targetAddress.getHostAddress() + " OID="
                    + requestOID + " : " + e2.getMessage());
            }
        }

        return retrievedVars;
    }

    /**
     * wOIDɂSNMPbZ[Wf[^AgentɑM܂B
     *
     * @param messageEncoding Mf[^oCgz
     * @param requestOID OID
     * @param sendDSocket DatagramSocket
     * @throws NoRouteToHostException MAhXsȏꍇ
     * @throws IOException MɎsꍇ
     */
    public void sendByteDataToAgent(
        byte[] messageEncoding, String requestOID, DatagramSocket sendDSocket)
        throws NoRouteToHostException, IOException {
        logger.fine(
            "Target IP=" + targetAddress.getHostAddress() + " Port=" + snmpPort);
        logger.fine(
            "Send data : "
            + hexBytetoString(messageEncoding, messageEncoding.length));

        DatagramPacket outPacket =
            new DatagramPacket(messageEncoding, messageEncoding.length);
        sendDSocket.send(outPacket);

        /* logger.info(
            "Socket InetAddress=" + sendDSocket.getInetAddress().getHostAddress()
            + " Port=" + sendDSocket.getPort());
            */
    }
}
