/*
 * Created on 2004/05/08
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.snmp;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableSystemMIB;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;



/**
 * SNMP System MIB̎悵Af[^x[XɊi[郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpSystemMibGet {
    /*
     * System MIB̎OID̔z
     */
    private static final String[] SYSTEM_MIB_OID =
        {
            "1.3.6.1.2.1.1.1", // sysDescr
            "1.3.6.1.2.1.1.2", // sysObjectID
            "1.3.6.1.2.1.1.3", // sysUpTime
            "1.3.6.1.2.1.1.4", // sysContact
            "1.3.6.1.2.1.1.5", // sysName
            "1.3.6.1.2.1.1.6" // sysLocation
        };

    /* MO */
    private static Logger logger = null;

    /* VXeMIBli[z */
    private String[] initialyzeSystemMibValueArray;

    /* VXeMIBi[z */
    private String[] systemMibValue;

    /* Target IP Address */
    private String targetIP;

    /* Snmp Version */
    private int version;

    /* R~jeB */
    private String community;

    /* Snmp System MIBf[^x[Xi[CX^X */
    private DBTableSystemMIB systemMibTable;

    /**
     * Snmp System MIB̎CX^X𐶐܂B
     *
     */
    public SnmpSystemMibGet() {
        logger = Logger.getLogger(this.getClass().getName());
        systemMibTable = DBTableSystemMIB.getInstance();
        initialyzeSystemMibValueArray = new String[SYSTEM_MIB_OID.length];
        systemMibValue = new String[SYSTEM_MIB_OID.length];
    }

    /**
     * Snmp System MIB̎ɂăp[^Zbg܂B
     *
     * @param targeIP Target IP Address
     * @param version Snmp Version
     * @param community R~jeB
     */
    public void setSnmpSystemMibGet(
        final String targeIP, final int version, final String community) {
        this.targetIP = targeIP;
        this.version = version;
        this.community = community;
    }

    /**
     * m[hǉɃm[hSystem MIB̎悵Af[^f[^x[X
     * e[uXV܂B
     *
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     */
    public void getInitialyzeSystemMIB() throws SnmpMIBGetException {
        MibGetNextInfo mibGetInstance = null;

        int i = 0;

        try {
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        targetIP, Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetIP, "Initialyze System MIB", checkCount, version);
            }

            mibGetInstance.setMibGetNext(targetIP, version, community);

            for (; i < SYSTEM_MIB_OID.length; i++) {
                initialyzeSystemMibValueArray[i] =
                    mibGetInstance.getMibValueString(SYSTEM_MIB_OID[i]);
            }

            if (initialyzeSystemMibValueArray != null) {
                /* System MIB̎f[^ɂăf[^x[Xe[uXV */
                this.setInitialyzeDBSystemMIB(initialyzeSystemMibValueArray);
            }
        } catch (SnmpV3AuthAbortException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[i]);
            e.printStackTrace();
        } catch (SnmpV3DecryptAbortException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[i]);
            e.printStackTrace();
        } catch (SnmpMIBGetException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[i]);
            e.printStackTrace();
            throw e;
        } catch (SnmpSetException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[i]);
            e.printStackTrace();
        } catch (SnmpV3ConfigurationException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[i]);
            e.printStackTrace();
        } catch (Exception e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[i]);
            e.printStackTrace();
        } finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetIP, Thread.currentThread().getName());
            }
        }
    }

    /**
     * System MIB̎܂́AŐVm[h擾ɌĂ΂Am[h
     * System MIB̎sAf[^x[Xe[uɊi[܂B
     *
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     */
    public void getSystemMIB() throws SnmpMIBGetException {
        MibGetNextInfo mibGetInstance = null;
        int systemMIBCounter = 0;

        try {
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        targetIP, Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    e1.printStackTrace();
                    logger.warning(e1.getMessage());
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetIP, "system MIB", checkCount, version);
            }

            mibGetInstance.setMibGetNext(targetIP, version, community);

            for (; systemMIBCounter < SYSTEM_MIB_OID.length;
                    systemMIBCounter++) {
                systemMibValue[systemMIBCounter] =
                    mibGetInstance.getMibValueString(
                        SYSTEM_MIB_OID[systemMIBCounter]);

                if (systemMibValue[systemMIBCounter] == null) {
                    logger.warning(
                        "Abort get System MIB = "
                        + SYSTEM_MIB_OID[systemMIBCounter]);

                    return;
                }
            }

            if (systemMibValue != null) {
                /* System MIBf[^f[^x[Xe[uɊi[ */
                this.setDBSystemMIB(systemMibValue);
            }
        } catch (SnmpV3AuthAbortException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[systemMIBCounter]);
            e.printStackTrace();
        } catch (SnmpV3DecryptAbortException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[systemMIBCounter]);
            e.printStackTrace();
        } catch (SnmpMIBGetException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[systemMIBCounter]);
            e.printStackTrace();
            throw e;
        } catch (SnmpSetException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[systemMIBCounter]);
            e.printStackTrace();
        } catch (SnmpV3ConfigurationException e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[systemMIBCounter]);
            e.printStackTrace();
        } catch (Exception e) {
            logger.warning(
                e.getMessage() + " :IP=" + targetIP + " : OID="
                + SYSTEM_MIB_OID[systemMIBCounter]);
            e.printStackTrace();
        } finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetIP, Thread.currentThread().getName());
            }
        }
    }

    /**
     * System MIB̎f[^f[^x[Xe[uɊi[܂B
     * ܂ASystem MIB̎悵AωĎsƂ܂B
     *
     * @param value System MIBli[z
     */
    private void setInitialyzeDBSystemMIB(String[] value) {
        NodeWatchInfo nodeInfo = null;

        try {
            systemMibTable.putSystemMIBTable(targetIP, community, value);

            /* System MIBĎZbg */
            nodeInfo =
                BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(targetIP);
            nodeInfo.setSystemMIBStatus(NodeWatchInfo.SYSTEM_MIB_OK);
            BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodeInfo);
        } catch (SQLException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            e.printStackTrace();
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            e.printStackTrace();
        } finally {
            systemMibTable = null;
            nodeInfo = null;
        }
    }

    /**
     * System MIBf[^x[Xe[uXV܂B
     *
     * @param value System MIBf[^̔̕z
     */
    private void setDBSystemMIB(String[] value) {
        try {
            systemMibTable.updateSystemMIBTable(targetIP, community, value);
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            e.printStackTrace();
        }
    }
}
