/*
 * Created on 2004/10/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * IPop3Ďm[h̃XgIɓǂŃL[PushThread
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadListReadQueuePushPop3Control implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * IPop3Ďm[h̃XgIɓǂŃL[PushThread
     * NXCX^X𐶐܂B
     */
    public ThreadListReadQueuePushPop3Control() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IPop3Ďm[h̃XgIɓǂŃL[Push܂B
     *
     */
    public void run() {
        int count = 0;
        Iterator it = null;

        while (true) {
            // PingĎm[hXgǂݍ
            Map list = ListQueuePopControl.getInstance().getPopHashMap();

            for (it = list.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                NodeWatchInfo info = (NodeWatchInfo) list.get(key);

                if (info == null) {
                    continue;
                }

                NodeWatchInfo nodeInfo =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        info.getIpaddress());

                if (nodeInfo == null) {
                    continue;
                }

                // HTTPo
                count = Integer.parseInt(info.getCountPopPeriod());

                if (count != 0) {
                    count--;
                    info.setCountPopPeriod(Integer.toString(count));

                    if (count == 0) {
                        // HTTPsL[Push
                        QueueForPop3.getInstance().pushQue(info);

                        // HTTPJE^Zbg
                        info.setCountPopPeriod(info.getPopPeriod());
                    }
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
